/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config.configupdater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import me.minebuilders.clearlag.config.configupdater.entries.ConfigBasicEntry;
import me.minebuilders.clearlag.config.configupdater.entries.ConfigCommentEntry;
import me.minebuilders.clearlag.config.configupdater.entries.ConfigEntry;
import me.minebuilders.clearlag.config.configupdater.entries.ConfigListEntry;
import me.minebuilders.clearlag.config.configupdater.entries.TreeConfigEntry;

public class ConfigUpdater {
    private List<String> carriedOverPaths = new ArrayList<String>();
    private Set<String> nonMergableKeys = new HashSet<String>();
    private List<ConfigEntry> updatingToConfig = null;
    private List<ConfigEntry> updatingFromConfig = null;

    public void setUpdatingToConfig(InputStream in) throws Exception {
        this.updatingToConfig = this.loadConfig(in);
    }

    public void setUpdatingFromConfig(InputStream in) throws Exception {
        this.updatingFromConfig = this.loadConfig(in);
    }

    public void addCarriedOverPath(String path) {
        this.carriedOverPaths.add(path);
    }

    public void addNonMergableKey(String key) {
        this.nonMergableKeys.add(key);
    }

    public int updateConfig(File writeToFile) throws Exception {
        int mergedVariables = 0;
        for (ConfigEntry updatingToEntry : this.updatingToConfig) {
            if (updatingToEntry instanceof ConfigCommentEntry || this.nonMergableKeys.contains(updatingToEntry.getKey())) continue;
            for (ConfigEntry updatingFromEntry : this.updatingFromConfig) {
                if (!updatingToEntry.getKey().equals(updatingFromEntry.getKey())) continue;
                updatingToEntry.merge(updatingFromEntry);
                ++mergedVariables;
            }
        }
        for (String carriedOverPath : this.carriedOverPaths) {
            block12: for (ConfigEntry updatingFromEntry : this.updatingFromConfig) {
                if (!updatingFromEntry.getKey().equals(carriedOverPath)) continue;
                ListIterator<ConfigEntry> updatingToIter = this.updatingToConfig.listIterator();
                while (updatingToIter.hasNext()) {
                    if (!updatingToIter.next().getKey().equals(carriedOverPath)) continue;
                    updatingToIter.set(updatingFromEntry);
                    continue block12;
                }
            }
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(writeToFile));){
            for (ConfigEntry updatingToEntry : this.updatingToConfig) {
                updatingToEntry.write(bw, 0);
            }
        }
        return this.updatingToConfig.size() - mergedVariables;
    }

    private List<ConfigEntry> loadConfig(InputStream in) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<ConfigEntry> configEntryList = new ArrayList<ConfigEntry>();
        Stack<TreeEntryNode> treeStack = new Stack<TreeEntryNode>();
        ConfigListEntry currentListEntry = null;
        String line = reader.readLine();
        String nextLine = reader.readLine();
        do {
            int position = this.getPosition(line);
            while (!treeStack.isEmpty() && ((TreeEntryNode)treeStack.peek()).position >= position) {
                treeStack.pop();
            }
            String trimmedLine = line.substring(position);
            if (trimmedLine.startsWith("-")) {
                if (currentListEntry != null) {
                    currentListEntry.add(trimmedLine);
                }
            } else {
                ConfigEntry configEntry;
                TreeEntryNode currentTree;
                TreeEntryNode treeEntryNode = currentTree = treeStack.isEmpty() ? null : (TreeEntryNode)treeStack.peek();
                if (this.isComment(trimmedLine)) {
                    configEntry = new ConfigCommentEntry(line);
                } else {
                    String[] bits = trimmedLine.split(":", 2);
                    String key = bits[0];
                    if (bits.length <= 1 || this.isComment(bits[1])) {
                        if (nextLine != null && nextLine.trim().startsWith("-")) {
                            currentListEntry = new ConfigListEntry(key, new Object[0]);
                            configEntry = currentListEntry;
                        } else {
                            TreeEntryNode treeEntryNode2 = new TreeEntryNode(new TreeConfigEntry(key), position);
                            configEntry = treeEntryNode2.treeConfigEntry;
                            treeStack.add(treeEntryNode2);
                        }
                    } else {
                        configEntry = new ConfigBasicEntry(key, bits[1]);
                    }
                }
                if (currentTree != null) {
                    currentTree.treeConfigEntry.addConfigEntry(configEntry);
                } else {
                    configEntryList.add(configEntry);
                }
            }
            line = nextLine;
        } while ((nextLine = reader.readLine()) != null && line != null || line != null);
        return configEntryList;
    }

    private boolean isComment(String str) {
        if (str.isEmpty() || str.startsWith("#")) {
            return true;
        }
        String noSpaceStr = str.replace(" ", "");
        return noSpaceStr.startsWith("#") || noSpaceStr.isEmpty();
    }

    private int getPosition(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static class TreeEntryNode {
        private TreeConfigEntry treeConfigEntry;
        private int position;

        public TreeEntryNode(TreeConfigEntry treeConfigEntry, int position) {
            this.treeConfigEntry = treeConfigEntry;
            this.position = position;
        }
    }
}

