/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpChunkCmd
extends CommandModule {
    @LanguageValue(key="command.tpchunk.")
    private MessageTree lang;

    public TpChunkCmd() {
        this.argLength = 2;
    }

    @Override
    protected void run(Player player, String[] args) throws WrongCommandArgumentException {
        World world;
        if (args.length >= 3) {
            world = Bukkit.getServer().getWorld(args[2]);
            if (world == null) {
                throw new WrongCommandArgumentException(this.lang.getMessage("invalidworld"), args[2]);
            }
        } else {
            world = player.getWorld();
        }
        if (!Util.isInteger(args[0]) || !Util.isInteger(args[1])) {
            throw new WrongCommandArgumentException(this.lang.getMessage("invalidinteger"), Util.isInteger(args[0]) ? args[1] : args[0]);
        }
        Chunk chunk = world.getChunkAt(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
        Block b = chunk.getBlock(8, 0, 8);
        int x = b.getX();
        int y = b.getY();
        int z = b.getZ();
        player.teleport(new Location(world, (double)x, (double)world.getHighestBlockYAt(new Location(world, (double)x, (double)y, (double)z)), (double)z));
        this.lang.sendMessage("teleported", (CommandSender)player, chunk.getX(), chunk.getZ());
    }
}

