/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.minebuilders.clearlag.Callback;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.RAMUtil;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SampleMemoryCmd
extends CommandModule {
    @LanguageValue(key="command.samplememory.")
    private MessageTree lang;

    public SampleMemoryCmd() {
        this.argLength = 1;
    }

    @Override
    protected void run(CommandSender sender, String[] args) throws WrongCommandArgumentException {
        if (!Util.isInteger(args[0])) {
            throw new WrongCommandArgumentException(this.lang.getMessage("invalidinteger"), args[0]);
        }
        this.lang.sendMessage("begin", sender, args[0]);
        new MemorySamlier(Integer.parseInt(args[0]) * 20, s -> {
            long highestMemory;
            int validMemorySamples = 0;
            long lowestMemory = highestMemory = ((Long)((MemorySamlier)s).memoryList.get(0)).longValue();
            long totalMemoryUsage = 0L;
            Iterator iterator = ((MemorySamlier)s).memoryList.iterator();
            while (iterator.hasNext()) {
                long memory = (Long)iterator.next();
                if (memory <= 0L) continue;
                if (memory > highestMemory) {
                    highestMemory = memory;
                }
                if (memory < lowestMemory) {
                    lowestMemory = memory;
                }
                totalMemoryUsage += memory;
                ++validMemorySamples;
            }
            long averageMemory = totalMemoryUsage / (long)validMemorySamples;
            this.lang.sendMessage("header", sender, new Object[0]);
            this.lang.sendMessage("memory", sender, Util.getChatColorByNumberLength((int)highestMemory, 100, 200) + Long.toString(highestMemory), Util.getChatColorByNumberLength((int)averageMemory, 30, 100) + Long.toString(averageMemory));
            if (((MemorySamlier)s).gcCollectionTickstamps.size() > 1) {
                long highestGC;
                long lowestGC = highestGC = ((Sample)((MemorySamlier)s).gcCollectionTickstamps.get(0)).data;
                long totalGC = 0L;
                int totalBetweenGCTime = 0;
                Sample lastSample = null;
                for (Sample sample : ((MemorySamlier)s).gcCollectionTickstamps) {
                    if (highestGC < sample.data) {
                        highestGC = sample.data;
                    }
                    if (lowestGC > sample.data) {
                        lowestGC = sample.data;
                    }
                    totalGC += sample.data;
                    if (lastSample != null) {
                        totalBetweenGCTime += sample.timeStamp - lastSample.timeStamp;
                    }
                    lastSample = sample;
                }
                long averageGC = totalGC / (long)((MemorySamlier)s).gcCollectionTickstamps.size();
                int averageBetweenTime = totalBetweenGCTime / (((MemorySamlier)s).gcCollectionTickstamps.size() - 1);
                this.lang.sendMessage("gc", sender, ((MemorySamlier)s).gcCollectionTickstamps.size(), Util.getChatColorByNumberLength((int)highestGC, 100, 200) + "" + highestGC, Util.getChatColorByNumberLength((int)lowestGC, 100, 200) + "" + lowestGC, Util.getChatColorByNumberLength((int)averageGC, 100, 200) + "" + averageGC, averageBetweenTime);
            } else {
                this.lang.sendMessage("notenoughtime", sender, new Object[0]);
            }
        }).runTaskTimer((Plugin)Clearlag.getInstance(), 1L, 1L);
    }

    private static class Sample {
        private int timeStamp;
        private long data;

        public Sample(int timeStamp, long data) {
            this.timeStamp = timeStamp;
            this.data = data;
        }
    }

    private static class MemorySamlier
    extends BukkitRunnable {
        private int currentTick = 0;
        private int runTicks;
        private long gcCollections = this.getTotalGCEvents();
        private long gcLastPauseTime = this.getTotalGCCompleteTime();
        private long lastMemoryUsed = RAMUtil.getUsedMemory();
        private List<Sample> gcCollectionTickstamps = new LinkedList<Sample>();
        private List<Long> memoryList;
        private Callback<MemorySamlier> callback;

        public MemorySamlier(int runTicks, Callback<MemorySamlier> callback) {
            this.runTicks = runTicks;
            this.callback = callback;
            this.memoryList = new ArrayList<Long>(runTicks);
        }

        public void run() {
            long currentGcCollections = this.getTotalGCEvents();
            if (currentGcCollections != this.gcCollections) {
                long currentTotalGCPauseTime = this.getTotalGCCompleteTime();
                this.gcCollectionTickstamps.add(new Sample(this.currentTick, currentTotalGCPauseTime - this.gcLastPauseTime));
                this.gcCollections = currentGcCollections;
                this.gcLastPauseTime = currentTotalGCPauseTime;
            }
            long memoryUsedDif = RAMUtil.getUsedMemory() - this.lastMemoryUsed;
            this.memoryList.add(memoryUsedDif);
            this.lastMemoryUsed = RAMUtil.getUsedMemory();
            if (++this.currentTick > this.runTicks) {
                this.cancel();
                this.callback.call(this);
            }
        }

        private long getTotalGCEvents() {
            long totalGarbageCollections = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionCount();
                if (count < 0L) continue;
                totalGarbageCollections += count;
            }
            return totalGarbageCollections;
        }

        private long getTotalGCCompleteTime() {
            long totalGarbageCollections = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionTime();
                if (count < 0L) continue;
                totalGarbageCollections += count;
            }
            return totalGarbageCollections;
        }
    }
}

