/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.adapters.VersionAdapter;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import me.minebuilders.clearlag.statrenderers.ProcessRenderer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class PerformanceCmd
extends CommandModule {
    @LanguageValue(key="command.performance.")
    private MessageTree lang;
    @AutoWire
    private VersionAdapter versionAdapter;

    public PerformanceCmd() {
        this.name = "performance";
    }

    @Override
    protected void run(Player p, String[] args) throws WrongCommandArgumentException {
        if (p.getInventory().getItemInHand() != null && p.getInventory().getItemInHand().getType() != Material.AIR) {
            p.getWorld().dropItem(p.getLocation(), p.getItemInHand());
        }
        int sampleRate = 1;
        if (args.length > 0) {
            if (!Util.isInteger(args[0])) {
                throw new WrongCommandArgumentException(this.lang.getMessage("invalidinteger"), args[0]);
            }
            sampleRate = Math.max(1, Integer.parseInt(args[0]));
        }
        MapView view = Bukkit.createMap((World)p.getWorld());
        view.setScale(MapView.Scale.NORMAL);
        for (MapRenderer renderer : view.getRenderers()) {
            view.removeRenderer(renderer);
        }
        ItemStack mapItemStack = this.versionAdapter.createMapItemStack(view);
        view.addRenderer((MapRenderer)new ProcessRenderer(p, sampleRate, mapItemStack, this.versionAdapter, view, Thread.currentThread()));
        p.setItemInHand(mapItemStack);
        this.lang.getMessage("message").sendMessage((CommandSender)p, new Object[0]);
    }
}

