/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import java.util.ArrayList;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.RAMUtil;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import me.minebuilders.clearlag.tasks.TPSTask;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Hopper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CheckCmd
extends CommandModule {
    @AutoWire
    private TPSTask tpsTask;
    @LanguageValue(key="command.check.")
    private MessageTree lang;

    @Override
    protected void run(CommandSender sender, String[] args) throws WrongCommandArgumentException {
        ArrayList<World> worlds;
        if (args.length > 0) {
            worlds = new ArrayList<World>(args.length);
            for (String arg : args) {
                World world = Bukkit.getWorld((String)arg);
                if (world == null) {
                    throw new WrongCommandArgumentException(this.lang.getMessage("invalidworld"), arg);
                }
                worlds.add(world);
            }
        } else {
            worlds = Bukkit.getWorlds();
        }
        int removed1 = 0;
        int mobs = 0;
        int animals = 0;
        int chunks = 0;
        int spawners = 0;
        int activehoppers = 0;
        int inactivehoppers = 0;
        int players = 0;
        for (World w : worlds) {
            for (Chunk c : w.getLoadedChunks()) {
                for (BlockState blockState : c.getTileEntities()) {
                    if (blockState instanceof CreatureSpawner) {
                        ++spawners;
                        continue;
                    }
                    if (!(blockState instanceof Hopper)) continue;
                    if (!this.isHopperEmpty((Hopper)blockState)) {
                        ++activehoppers;
                        continue;
                    }
                    ++inactivehoppers;
                }
                for (BlockState blockState : c.getEntities()) {
                    if (blockState instanceof Monster) {
                        ++mobs;
                        continue;
                    }
                    if (blockState instanceof Player) {
                        ++players;
                        continue;
                    }
                    if (blockState instanceof Creature) {
                        ++animals;
                        continue;
                    }
                    if (!(blockState instanceof Item)) continue;
                    ++removed1;
                }
                ++chunks;
            }
        }
        this.lang.sendMessage("header", sender, new Object[0]);
        this.lang.sendMessage("printed", sender, removed1, mobs, animals, players, chunks, activehoppers, inactivehoppers, spawners, Util.getTime(System.currentTimeMillis() - Clearlag.getInstance().getInitialBootTimestamp()), this.tpsTask.getStringTPS(), RAMUtil.getUsedMemory(), RAMUtil.getMaxMemory(), RAMUtil.getMaxMemory() - RAMUtil.getUsedMemory());
        this.lang.sendMessage("footer", sender, new Object[0]);
    }

    private boolean isHopperEmpty(Hopper hop) {
        for (ItemStack it : hop.getInventory().getContents()) {
            if (it == null) continue;
            return false;
        }
        return true;
    }
}

