/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag;

import java.util.ArrayList;
import java.util.List;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandListener
implements CommandExecutor {
    @LanguageValue(key="command.lagg.")
    private MessageTree lang;
    private List<CommandModule> cmds = new ArrayList<CommandModule>();

    public CommandListener() {
        Clearlag.getInstance().getCommand("lagg").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandModule enteredSubCommand;
        CommandModule commandModule = enteredSubCommand = args.length > 0 ? this.getCmd(args[0]) : null;
        if (enteredSubCommand == null) {
            List<CommandModule> cmds = this.getUserCmds(sender);
            if (cmds.size() == 0) {
                this.lang.sendMessage("nopermission", sender, new Object[0]);
                return false;
            }
            Message helpLineMessage = this.lang.getMessage("helpline");
            this.lang.sendMessage("header", sender, new Object[0]);
            for (CommandModule cmd : cmds) {
                helpLineMessage.sendMessage(sender, cmd.getDisplayName(), cmd.getDescription());
            }
            this.lang.sendMessage("footer", sender, new Object[0]);
        } else {
            try {
                enteredSubCommand.processCmd(sender, args);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(e.getMessage());
            }
            catch (WrongCommandArgumentException e) {
                e.getError().sendMessage(sender, e.getReplacables());
            }
        }
        return true;
    }

    public void addCmd(CommandModule cmd) {
        this.cmds.add(cmd);
    }

    private CommandModule getCmd(String s) {
        s = s.toLowerCase();
        for (CommandModule cmd : this.cmds) {
            if (cmd == null || !cmd.getDisplayName().equals(s)) continue;
            return cmd;
        }
        return null;
    }

    private List<CommandModule> getUserCmds(CommandSender p) {
        ArrayList<CommandModule> mod = new ArrayList<CommandModule>();
        for (CommandModule cmd : this.cmds) {
            if (!p.hasPermission("lagg." + cmd.getName())) continue;
            mod.add(cmd);
        }
        return mod;
    }
}

