/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag;

import java.util.ArrayList;
import me.minebuilders.clearlag.BukkitUpdater;
import me.minebuilders.clearlag.CommandListener;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.adapters.LatestVersionAdapter;
import me.minebuilders.clearlag.adapters.LegacyVersionAdapter;
import me.minebuilders.clearlag.adapters.VersionAdapter;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.commands.AdminCmd;
import me.minebuilders.clearlag.commands.AreaCmd;
import me.minebuilders.clearlag.commands.CheckChunkCmd;
import me.minebuilders.clearlag.commands.CheckCmd;
import me.minebuilders.clearlag.commands.ChunkCmd;
import me.minebuilders.clearlag.commands.ClearCmd;
import me.minebuilders.clearlag.commands.GcCmd;
import me.minebuilders.clearlag.commands.HaltCmd;
import me.minebuilders.clearlag.commands.KillmobsCmd;
import me.minebuilders.clearlag.commands.MemoryCmd;
import me.minebuilders.clearlag.commands.PerformanceCmd;
import me.minebuilders.clearlag.commands.ProfileCmd;
import me.minebuilders.clearlag.commands.ReloadCmd;
import me.minebuilders.clearlag.commands.SampleMemoryCmd;
import me.minebuilders.clearlag.commands.TickSamplerCmd;
import me.minebuilders.clearlag.commands.TpChunkCmd;
import me.minebuilders.clearlag.commands.TpsCmd;
import me.minebuilders.clearlag.commands.UnloadChunksCmd;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.language.LanguageManager;
import me.minebuilders.clearlag.listeners.ChunkEntityLimiterListener;
import me.minebuilders.clearlag.listeners.ChunkLimiterListener;
import me.minebuilders.clearlag.listeners.ChunkOverloadListener;
import me.minebuilders.clearlag.listeners.ChunkPerEntityLimiterListener;
import me.minebuilders.clearlag.listeners.DispenceLimitEvent;
import me.minebuilders.clearlag.listeners.EggSpawnListener;
import me.minebuilders.clearlag.listeners.EntityAISpawnListener;
import me.minebuilders.clearlag.listeners.EntityBreedListener;
import me.minebuilders.clearlag.listeners.FireSpreadListener;
import me.minebuilders.clearlag.listeners.HopperLimitListener;
import me.minebuilders.clearlag.listeners.ItemLivetimeListener;
import me.minebuilders.clearlag.listeners.ItemMergeListener;
import me.minebuilders.clearlag.listeners.MobLimitListener;
import me.minebuilders.clearlag.listeners.MobSpawerListener;
import me.minebuilders.clearlag.listeners.TNTMinecartListener;
import me.minebuilders.clearlag.listeners.TntReduceListener;
import me.minebuilders.clearlag.managers.EntityManager;
import me.minebuilders.clearlag.modules.BroadcastHandler;
import me.minebuilders.clearlag.modules.Module;
import me.minebuilders.clearlag.reflection.AutoWirer;
import me.minebuilders.clearlag.tasks.ClearTask;
import me.minebuilders.clearlag.tasks.HaltTask;
import me.minebuilders.clearlag.tasks.LagSpikeTask;
import me.minebuilders.clearlag.tasks.LimitTask;
import me.minebuilders.clearlag.tasks.LiveTask;
import me.minebuilders.clearlag.tasks.LogPurger;
import me.minebuilders.clearlag.tasks.RAMCheckTask;
import me.minebuilders.clearlag.tasks.TPSCheckTask;
import me.minebuilders.clearlag.tasks.TPSTask;
import me.minebuilders.clearlag.triggeredremoval.TriggerManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Clearlag
extends JavaPlugin {
    @AutoWire
    private ConfigHandler config;
    private static Clearlag instance;
    private static Module[] modules;
    private AutoWirer autoWirer = new AutoWirer();
    private VersionAdapter versionAdapter = null;
    private final long initialBootTimestamp = System.currentTimeMillis();

    public void onEnable() {
        instance = this;
        this.versionAdapter = this.findVersionAdapter();
        if (this.versionAdapter == null) {
            Util.warning("Clearlag failed to find a valid version adapter for your version (" + Util.getRawBukkitVersion() + ")");
            Util.warning("Expect bugs, and errors with certain modules!");
        } else {
            Util.log("Using version-adapter: " + this.versionAdapter.getClass().getSimpleName());
            this.autoWirer.addWireable(this.versionAdapter);
        }
        this.autoWirer.addWireable((Object)instance);
        this.autoWirer.addWireable(new ConfigHandler());
        this.autoWirer.addWireable(this.getConfig());
        this.autoWirer.addWireable(new CommandListener());
        this.autoWirer.addWireable(new HaltTask());
        modules = new Module[]{new BroadcastHandler(), new LanguageManager(), new EntityManager(), new ClearCmd(), new AreaCmd(), new CheckCmd(), new ChunkCmd(), new GcCmd(), new TpsCmd(), new KillmobsCmd(), new ReloadCmd(), new TpChunkCmd(), new UnloadChunksCmd(), new HaltCmd(), new AdminCmd(), new ProfileCmd(), new CheckChunkCmd(), new SampleMemoryCmd(), new TickSamplerCmd(), new MemoryCmd(), new PerformanceCmd(), new ChunkLimiterListener(), new DispenceLimitEvent(), new EggSpawnListener(), new ItemLivetimeListener(), new EntityAISpawnListener(), new FireSpreadListener(), new ItemMergeListener(), new MobLimitListener(), new MobSpawerListener(), new TNTMinecartListener(), new TntReduceListener(), new ChunkEntityLimiterListener(), new ChunkPerEntityLimiterListener(), new EntityBreedListener(), new ChunkOverloadListener(), new TPSTask(), new LiveTask(), new ClearTask(), new LimitTask(), new TPSCheckTask(), new RAMCheckTask(), new LogPurger(), new HopperLimitListener(), new TriggerManager(), new LagSpikeTask()};
        this.autoWirer.addWireables(modules);
        for (Object module : this.autoWirer.getWires()) {
            try {
                this.autoWirer.wireObject(module);
            }
            catch (Exception e) {
                Util.log("Failed to wire module: " + module.getClass().getName());
                e.printStackTrace();
            }
        }
        this.startModules();
        if (this.getConfig().getBoolean("settings.auto-update")) {
            new BukkitUpdater(this.getFile());
        }
        Util.log("Clearlag is now enabled!");
    }

    private VersionAdapter findVersionAdapter() {
        ArrayList<Class> versionAdapterTypes = new ArrayList<Class>();
        versionAdapterTypes.add(LatestVersionAdapter.class);
        versionAdapterTypes.add(LegacyVersionAdapter.class);
        for (Class versionAdapterType : versionAdapterTypes) {
            try {
                VersionAdapter tryingVersionAdapter = (VersionAdapter)versionAdapterType.newInstance();
                if (!tryingVersionAdapter.isCompatible()) continue;
                return tryingVersionAdapter;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private void startModules() {
        Util.log("Loading modules...");
        for (Module mod : modules) {
            ConfigPath configPath = mod.getClass().getAnnotation(ConfigPath.class);
            if (configPath != null && this.getConfig().get(configPath.path() + ".enabled") != null && !this.getConfig().getBoolean(configPath.path() + ".enabled")) continue;
            mod.setEnabled();
        }
        Util.log("Modules enabed, loading config values");
        try {
            this.config.setModuleConfigValues();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Util.log("Modules have been loaded!");
    }

    public void onDisable() {
        Util.log("Clearlag is now disabled!");
    }

    public static Clearlag getInstance() {
        return instance;
    }

    public static Module[] getModules() {
        return modules;
    }

    public static Module getModule(String name) {
        for (Module module : modules) {
            if (!module.getClass().getSimpleName().equalsIgnoreCase(name)) continue;
            return module;
        }
        return null;
    }

    public AutoWirer getAutoWirer() {
        return this.autoWirer;
    }

    public long getInitialBootTimestamp() {
        return this.initialBootTimestamp;
    }

    public VersionAdapter getVersionAdapter() {
        return this.versionAdapter;
    }
}

