/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.config.EssentialsConfiguration;
import java.io.File;
import java.util.Map;
import net.essentialsx.discordlink.EssentialsDiscordLink;

public class DiscordLinkSettings
implements IConf {
    private final EssentialsDiscordLink plugin;
    private final EssentialsConfiguration config;
    private LinkPolicy linkPolicy;
    private Map<String, String> roleSyncGroups;
    private Map<String, String> roleSyncRoles;

    public DiscordLinkSettings(EssentialsDiscordLink plugin) {
        this.plugin = plugin;
        this.config = new EssentialsConfiguration(new File(plugin.getDataFolder(), "config.yml"), "/config.yml", EssentialsDiscordLink.class);
        this.reloadConfig();
    }

    public LinkPolicy getLinkPolicy() {
        return this.linkPolicy;
    }

    public boolean isBlockUnlinkedChat() {
        return this.config.getBoolean("block-unlinked-chat", false);
    }

    public boolean isUnlinkOnLeave() {
        return this.config.getBoolean("unlink-on-leave", true);
    }

    public boolean isRelayMail() {
        return this.config.getBoolean("relay-mail", true);
    }

    public boolean isRoleSyncRemoveRoles() {
        return this.config.getBoolean("role-sync.remove-roles", true);
    }

    public boolean isRoleSyncRemoveGroups() {
        return this.config.getBoolean("role-sync.remove-groups", true);
    }

    public int getRoleSyncResyncDelay() {
        return this.config.getInt("role-sync.resync-delay", 5);
    }

    public boolean isRoleSyncPrimaryGroupOnly() {
        return this.config.getBoolean("role-sync.primary-group-only", false);
    }

    public Map<String, String> getRoleSyncGroups() {
        return this.roleSyncGroups;
    }

    private Map<String, String> _getRoleSyncGroups() {
        return this.config.getStringMap("role-sync.groups");
    }

    public Map<String, String> getRoleSyncRoles() {
        return this.roleSyncRoles;
    }

    private Map<String, String> _getRoleSyncRoles() {
        return this.config.getStringMap("role-sync.roles");
    }

    public void reloadConfig() {
        this.config.load();
        this.linkPolicy = LinkPolicy.fromName(this.config.getString("link-policy", "none"));
        this.roleSyncGroups = this._getRoleSyncGroups();
        this.roleSyncRoles = this._getRoleSyncRoles();
        this.plugin.onReload();
    }

    public static enum LinkPolicy {
        KICK,
        FREEZE,
        NONE;


        static LinkPolicy fromName(String name) {
            for (LinkPolicy policy : LinkPolicy.values()) {
                if (!policy.name().equalsIgnoreCase(name)) continue;
                return policy;
            }
            return NONE;
        }
    }
}

