/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.Enchantments;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import java.util.Locale;
import net.ess3.api.IEssentials;
import net.ess3.provider.MaterialTagProvider;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class SignEnchant
extends EssentialsSign {
    public SignEnchant() {
        super("Enchant");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException, ChargeException {
        boolean allowUnsafe;
        ItemStack stack;
        String itemName = sign.getLine(1);
        MaterialTagProvider tagProvider = ess.getMaterialTagProvider();
        try {
            stack = itemName.equals("*") || itemName.equalsIgnoreCase("any") || tagProvider != null && tagProvider.tagExists(itemName) ? null : this.getItemStack(sign.getLine(1), 1, ess);
        }
        catch (SignException e) {
            sign.setLine(1, "\u00a7c<item|any>");
            throw e;
        }
        String[] enchantLevel = sign.getLine(2).split(":");
        int level = 1;
        Enchantment enchantment = Enchantments.getByName(enchantLevel[0]);
        if (enchantment == null) {
            sign.setLine(2, "\u00a7c<enchant>");
            throw new SignException(I18n.tl("enchantmentNotFound", new Object[0]));
        }
        if (enchantLevel.length > 1) {
            try {
                level = Integer.parseInt(enchantLevel[1]);
            }
            catch (NumberFormatException ex) {
                sign.setLine(2, "\u00a7c<enchant>");
                throw new SignException(ex.getMessage(), ex);
            }
        }
        boolean bl = allowUnsafe = ess.getSettings().allowUnsafeEnchantments() && player.isAuthorized("essentials.enchantments.allowunsafe") && player.isAuthorized("essentials.signs.enchant.allowunsafe");
        if (level < 0 || !allowUnsafe && level > enchantment.getMaxLevel()) {
            level = enchantment.getMaxLevel();
            sign.setLine(2, enchantLevel[0] + ":" + level);
        }
        try {
            if (stack != null) {
                if (allowUnsafe) {
                    stack.addUnsafeEnchantment(enchantment, level);
                } else {
                    stack.addEnchantment(enchantment, level);
                }
            }
        }
        catch (Throwable ex) {
            throw new SignException(ex.getMessage(), ex);
        }
        this.getTrade(sign, 3, ess);
        return true;
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException, ChargeException {
        ItemStack playerHand = Inventories.getItemInHand(player.getBase());
        MaterialTagProvider tagProvider = ess.getMaterialTagProvider();
        String itemName = sign.getLine(1);
        ItemStack search = itemName.equals("*") || itemName.equalsIgnoreCase("any") || tagProvider != null && tagProvider.tagExists(itemName) && tagProvider.isTagged(itemName, playerHand.getType()) ? null : this.getItemStack(itemName, 1, ess);
        Trade charge = this.getTrade(sign, 3, ess);
        charge.isAffordableFor(player);
        String[] enchantLevel = sign.getLine(2).split(":");
        Enchantment enchantment = Enchantments.getByName(enchantLevel[0]);
        if (enchantment == null) {
            throw new SignException(I18n.tl("enchantmentNotFound", new Object[0]));
        }
        int level = 1;
        if (enchantLevel.length > 1) {
            try {
                level = Integer.parseInt(enchantLevel[1]);
            }
            catch (NumberFormatException ex) {
                throw new SignException(ex.getMessage(), ex);
            }
        }
        if (playerHand == null || playerHand.getAmount() != 1 || playerHand.containsEnchantment(enchantment) && playerHand.getEnchantmentLevel(enchantment) == level) {
            throw new SignException(I18n.tl("missingItems", 1, sign.getLine(1)));
        }
        if (search != null && playerHand.getType() != search.getType()) {
            throw new SignException(I18n.tl("missingItems", 1, search.getType().toString().toLowerCase(Locale.ENGLISH).replace('_', ' ')));
        }
        try {
            if (level == 0) {
                playerHand.removeEnchantment(enchantment);
            } else if (ess.getSettings().allowUnsafeEnchantments() && player.isAuthorized("essentials.signs.enchant.allowunsafe")) {
                playerHand.addUnsafeEnchantment(enchantment, level);
            } else {
                playerHand.addEnchantment(enchantment, level);
            }
        }
        catch (Exception ex) {
            throw new SignException(ex.getMessage(), ex);
        }
        String enchantmentName = enchantment.getName().toLowerCase(Locale.ENGLISH);
        if (level == 0) {
            player.sendMessage(I18n.tl("enchantmentRemoved", enchantmentName.replace('_', ' ')));
        } else {
            player.sendMessage(I18n.tl("enchantmentApplied", enchantmentName.replace('_', ' ')));
        }
        charge.charge(player);
        Trade.log("Sign", "Enchant", "Interact", username, charge, username, charge, sign.getBlock().getLocation(), player.getMoney(), ess);
        player.getBase().updateInventory();
        return true;
    }
}

