/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.essentialsx.dep.club.minnced.discord.webhook.WebhookClient;
import net.essentialsx.dep.club.minnced.discord.webhook.WebhookClientBuilder;
import net.essentialsx.dep.club.minnced.discord.webhook.receive.ReadonlyMessage;
import net.essentialsx.dep.club.minnced.discord.webhook.send.AllowedMentions;
import net.essentialsx.dep.club.minnced.discord.webhook.send.WebhookMessage;
import net.essentialsx.dep.club.minnced.discord.webhook.util.ThreadPools;
import net.essentialsx.dep.okhttp3.OkHttpClient;
import net.essentialsx.discord.EssentialsDiscord;

public class WrappedWebhookClient {
    private static final Logger logger;
    private static final MethodHandle queueGetter;
    private final WebhookClient webhookClient;
    private final ScheduledExecutorService executorService;
    private final BlockingQueue<?> webhookQueue;

    public WrappedWebhookClient(long id, String token, OkHttpClient client) {
        this.executorService = ThreadPools.getDefaultPool(id, null, true);
        this.webhookClient = new WebhookClientBuilder(id, token).setWait(false).setAllowedMentions(AllowedMentions.none()).setHttpClient(client).setExecutorService(this.executorService).build();
        BlockingQueue queue = null;
        try {
            queue = queueGetter == null ? null : queueGetter.invoke(this.webhookClient);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.webhookQueue = queue;
    }

    public CompletableFuture<ReadonlyMessage> send(WebhookMessage message) {
        return this.webhookClient.send(message);
    }

    public boolean isShutdown() {
        return this.webhookClient.isShutdown();
    }

    public void abandonRequests() {
        if (this.webhookQueue != null) {
            this.webhookQueue.clear();
        }
    }

    public void close() {
        this.webhookClient.close();
        if (this.executorService.isTerminated()) {
            return;
        }
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new InterruptedException("ExecutorService did not terminate in time.");
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Webhook (ID: " + this.webhookClient.getId() + ") took longer than expected to shutdown, this may have caused some problems.", e);
        }
    }

    static {
        MethodHandle queueGetter1;
        logger = EssentialsDiscord.getWrappedLogger();
        try {
            Field queueField = WebhookClient.class.getDeclaredField("queue");
            queueField.setAccessible(true);
            queueGetter1 = MethodHandles.lookup().unreflectGetter(queueField);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.log(Level.SEVERE, "Could not acquire queue handle", e);
            queueGetter1 = null;
        }
        queueGetter = queueGetter1;
    }
}

