/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.util;

import com.earth2me.essentials.utils.DownsampleUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import net.essentialsx.api.v2.events.discord.DiscordMessageEvent;
import net.essentialsx.api.v2.services.discord.MessageType;
import net.essentialsx.dep.club.minnced.discord.webhook.send.AllowedMentions;
import net.essentialsx.dep.net.dv8tion.jda.api.Permission;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Guild;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Member;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Message;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Role;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Webhook;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.essentialsx.dep.okhttp3.OkHttpClient;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.util.WrappedWebhookClient;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public final class DiscordUtil {
    public static final String ADVANCED_RELAY_NAME = "EssX Advanced Relay";
    public static final String CONSOLE_RELAY_NAME = "EssX Console Relay";
    public static final List<Message.MentionType> NO_GROUP_MENTIONS;
    public static final AllowedMentions ALL_MENTIONS_WEBHOOK;
    public static final AllowedMentions NO_GROUP_MENTIONS_WEBHOOK;
    public static final CopyOnWriteArrayList<String> ACTIVE_WEBHOOKS;

    private DiscordUtil() {
    }

    public static WrappedWebhookClient getWebhookClient(long id, String token, OkHttpClient client) {
        return new WrappedWebhookClient(id, token, client);
    }

    public static CompletableFuture<Webhook> getOrCreateWebhook(TextChannel channel, String webhookName) {
        if (!channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, Permission.MANAGE_WEBHOOKS)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Webhook> future = new CompletableFuture<Webhook>();
        channel.retrieveWebhooks().queue(webhooks -> {
            for (Webhook webhook : webhooks) {
                if (!webhook.getName().equals(webhookName) || webhook.getToken() == null) continue;
                ACTIVE_WEBHOOKS.addIfAbsent(webhook.getId());
                future.complete(webhook);
                return;
            }
            DiscordUtil.createWebhook(channel, webhookName).thenAccept(future::complete);
        });
        return future;
    }

    private static void cleanWebhooks(Guild guild, String webhookName) {
        if (!guild.getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS)) {
            return;
        }
        guild.retrieveWebhooks().queue(webhooks -> {
            for (Webhook webhook : webhooks) {
                if (!webhook.getName().equalsIgnoreCase(webhookName) || ACTIVE_WEBHOOKS.contains(webhook.getId())) continue;
                webhook.delete().reason("EssentialsX Discord: webhook cleanup").queue();
            }
        });
    }

    public static CompletableFuture<Webhook> createWebhook(TextChannel channel, String webhookName) {
        if (!channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, Permission.MANAGE_WEBHOOKS)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Webhook> future = new CompletableFuture<Webhook>();
        channel.createWebhook(webhookName).queue(webhook -> {
            future.complete((Webhook)webhook);
            ACTIVE_WEBHOOKS.addIfAbsent(webhook.getId());
        });
        return future;
    }

    public static String getRoleFormat(Member member) {
        List<Role> roles;
        List<Role> list = roles = member == null ? null : member.getRoles();
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        return roles.get(0).getName();
    }

    public static String getRoleColorFormat(Member member) {
        if (member == null || member.getColorRaw() == 0x1FFFFFFF) {
            return "";
        }
        int rawColor = 0xFF000000 | member.getColorRaw();
        if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_16_1_R01)) {
            return FormatUtil.replaceFormat((String)("&#" + Integer.toHexString(rawColor).substring(2)));
        }
        return FormatUtil.replaceFormat((String)("&" + DownsampleUtil.nearestTo((int)rawColor)));
    }

    public static boolean hasRoles(Member member, List<String> roleDefinitions) {
        if (member.hasPermission(Permission.ADMINISTRATOR)) {
            return true;
        }
        List<Role> roles = member.getRoles();
        for (String roleDefinition : roleDefinitions) {
            roleDefinition = roleDefinition.trim();
            boolean id = NumberUtil.isNumeric((String)roleDefinition);
            if (roleDefinition.equals("*") || member.getId().equals(roleDefinition)) {
                return true;
            }
            for (Role role : roles) {
                if (!role.getId().equals(roleDefinition) && (id || !role.getName().equalsIgnoreCase(roleDefinition))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAvatarUrl(JDADiscordService jda, Player player) {
        return jda.getSettings().getAvatarURL().replace("{uuid}", player.getUniqueId().toString()).replace("{name}", player.getName());
    }

    public static void dispatchDiscordMessage(JDADiscordService jda, MessageType messageType, String message, boolean allowPing, String avatarUrl, String name, UUID uuid) {
        if (jda.getPlugin().getSettings().getMessageChannel(messageType.getKey()).equalsIgnoreCase("none")) {
            return;
        }
        DiscordMessageEvent event = new DiscordMessageEvent(messageType, FormatUtil.stripFormat((String)message), allowPing, avatarUrl, FormatUtil.stripFormat((String)name), uuid);
        if (messageType == MessageType.DefaultTypes.SERVER_STOP) {
            jda.sendMessage(event, event.getMessage(), event.isAllowGroupMentions());
            return;
        }
        if (Bukkit.getServer().isPrimaryThread()) {
            Bukkit.getPluginManager().callEvent((Event)event);
        } else {
            Bukkit.getScheduler().runTask((Plugin)jda.getPlugin(), () -> Bukkit.getPluginManager().callEvent((Event)event));
        }
    }

    static {
        ALL_MENTIONS_WEBHOOK = AllowedMentions.all();
        NO_GROUP_MENTIONS_WEBHOOK = new AllowedMentions().withParseEveryone(false).withParseRoles(false).withParseUsers(true);
        ACTIVE_WEBHOOKS = new CopyOnWriteArrayList();
        ImmutableList.Builder types = new ImmutableList.Builder();
        types.add((Object)Message.MentionType.USER);
        types.add((Object)Message.MentionType.CHANNEL);
        types.add((Object)Message.MentionType.EMOJI);
        NO_GROUP_MENTIONS = types.build();
    }
}

