/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.util;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.discord.util.MessageUtil;
import org.bukkit.entity.Player;

public class DiscordMessageRecipient
implements IMessageRecipient {
    private final InteractionMember member;
    private final AtomicBoolean died = new AtomicBoolean(false);

    public DiscordMessageRecipient(InteractionMember member) {
        this.member = member;
    }

    public void sendMessage(String message) {
    }

    public IMessageRecipient.MessageResponse sendMessage(IMessageRecipient recipient, String message) {
        return IMessageRecipient.MessageResponse.UNREACHABLE;
    }

    public IMessageRecipient.MessageResponse onReceiveMessage(IMessageRecipient sender, String message) {
        if (this.died.get()) {
            sender.setReplyRecipient(null);
            return IMessageRecipient.MessageResponse.UNREACHABLE;
        }
        String cleanMessage = MessageUtil.sanitizeDiscordMarkdown(FormatUtil.stripFormat((String)message));
        this.member.sendPrivateMessage(I18n.tl((String)"replyFromDiscord", (Object[])new Object[]{sender.getName(), cleanMessage})).thenAccept(success -> {
            if (!success.booleanValue()) {
                this.died.set(true);
            }
        });
        return IMessageRecipient.MessageResponse.SUCCESS;
    }

    public String getName() {
        return this.member.getTag();
    }

    public UUID getUUID() {
        return null;
    }

    public String getDisplayName() {
        return this.member.getTag();
    }

    public boolean isReachable() {
        return !this.died.get();
    }

    public IMessageRecipient getReplyRecipient() {
        return null;
    }

    public void setReplyRecipient(IMessageRecipient recipient) {
    }

    public boolean isHiddenFrom(Player player) {
        return this.died.get();
    }
}

