/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.util;

import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.VersionUtil;
import net.ess3.provider.providers.BukkitSenderProvider;
import net.ess3.provider.providers.PaperCommandSender;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.util.MessageUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DiscordCommandSender {
    private final CommandSender sender;
    private BukkitTask task;
    private String responseBuffer = "";
    private long lastTime = System.currentTimeMillis();

    public DiscordCommandSender(JDADiscordService jda, ConsoleCommandSender sender, CmdCallback callback) {
        BukkitSenderProvider.MessageHook hook = message -> {
            this.responseBuffer = this.responseBuffer + (this.responseBuffer.isEmpty() ? "" : "\n") + MessageUtil.sanitizeDiscordMarkdown(FormatUtil.stripFormat((String)message));
            this.lastTime = System.currentTimeMillis();
        };
        this.sender = this.getCustomSender(sender, hook);
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)jda.getPlugin(), () -> {
            if (!this.responseBuffer.isEmpty() && System.currentTimeMillis() - this.lastTime >= 1000L) {
                callback.onMessage(this.responseBuffer);
                this.responseBuffer = "";
                this.lastTime = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.lastTime >= 20000L) {
                this.task.cancel();
            }
        }, 0L, 20L);
    }

    private CommandSender getCustomSender(ConsoleCommandSender consoleSender, BukkitSenderProvider.MessageHook hook) {
        if (VersionUtil.isPaper() && VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_16_5_R01)) {
            if (PaperCommandSender.forwardingSenderAvailable()) {
                return PaperCommandSender.createCommandSender(arg_0 -> ((BukkitSenderProvider.MessageHook)hook).sendMessage(arg_0));
            }
            return new PaperCommandSender(consoleSender, hook);
        }
        return new BukkitSenderProvider(consoleSender, hook);
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public static interface CmdCallback {
        public void onMessage(String var1);
    }
}

