/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.listeners;

import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.discord.DiscordRelayEvent;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiParser;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Member;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Message;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.User;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.ChannelType;
import net.essentialsx.dep.net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.essentialsx.dep.net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.essentialsx.discord.EssentialsDiscord;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.interactions.InteractionChannelImpl;
import net.essentialsx.discord.interactions.InteractionMemberImpl;
import net.essentialsx.discord.util.DiscordUtil;
import net.essentialsx.discord.util.MessageUtil;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class DiscordListener
extends ListenerAdapter {
    private static final Logger logger = EssentialsDiscord.getWrappedLogger();
    private final JDADiscordService plugin;

    public DiscordListener(JDADiscordService plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        String finalMessage;
        if (event.getMessage().getChannelType() != ChannelType.TEXT) {
            return;
        }
        if (event.getAuthor().isBot() && !event.isWebhookMessage() && (!this.plugin.getSettings().isShowBotMessages() || event.getAuthor().getId().equals(this.plugin.getJda().getSelfUser().getId()))) {
            return;
        }
        if (event.isWebhookMessage() && (!this.plugin.getSettings().isShowWebhookMessages() || DiscordUtil.ACTIVE_WEBHOOKS.contains(event.getAuthor().getId()))) {
            return;
        }
        List<String> keys = this.plugin.getPlugin().getSettings().getKeysFromChannelId(event.getChannel().getIdLong());
        if (keys == null || keys.size() == 0) {
            if (this.plugin.isDebug()) {
                logger.log(Level.INFO, "Skipping message due to no channel keys for id " + event.getChannel().getIdLong() + "!");
            }
            return;
        }
        User user = event.getAuthor();
        Member member = event.getMember();
        String effectiveName = member == null ? event.getAuthor().getName() : member.getEffectiveName();
        Message message = event.getMessage();
        if (!this.plugin.getSettings().getDiscordFilters().isEmpty()) {
            for (Pattern pattern : this.plugin.getSettings().getDiscordFilters()) {
                if (!pattern.matcher(message.getContentDisplay()).find()) continue;
                if (this.plugin.isDebug()) {
                    logger.log(Level.INFO, "Skipping message " + message.getId() + " with content, \"" + message.getContentDisplay() + "\" as it matched the filter!");
                }
                return;
            }
        }
        StringBuilder messageBuilder = new StringBuilder(message.getContentDisplay());
        if (this.plugin.getPlugin().getSettings().isShowDiscordAttachments()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                messageBuilder.append(" ").append(attachment.getUrl());
            }
        }
        String string = StringUtil.abbreviate((String)messageBuilder.toString().replace(this.plugin.getSettings().isChatFilterNewlines() ? (char)'\n' : ' ', ' ').trim(), (int)this.plugin.getSettings().getChatDiscordMaxLength());
        String string2 = finalMessage = member == null || DiscordUtil.hasRoles(member, this.plugin.getPlugin().getSettings().getPermittedFormattingRoles()) ? FormatUtil.replaceFormat((String)string) : FormatUtil.stripFormat((String)string);
        if (finalMessage.trim().length() == 0) {
            if (this.plugin.isDebug()) {
                logger.log(Level.INFO, "Skipping finalized empty message " + message.getId());
            }
            return;
        }
        String formattedMessage = EmojiParser.parseToAliases(MessageUtil.formatMessage(this.plugin.getPlugin().getSettings().getDiscordToMcFormat(), event.getChannel().getName(), user.getName(), user.getDiscriminator(), user.getAsTag(), effectiveName, DiscordUtil.getRoleColorFormat(member), finalMessage, DiscordUtil.getRoleFormat(member)), EmojiParser.FitzpatrickAction.REMOVE);
        for (String string3 : keys) {
            if (!this.plugin.getSettings().getRelayToConsoleList().contains(string3)) continue;
            logger.info(formattedMessage);
            break;
        }
        ArrayList<IUser> viewers = new ArrayList<IUser>();
        block3: for (IUser essUser : this.plugin.getPlugin().getEss().getOnlineUsers()) {
            for (String group : keys) {
                boolean primaryOverride;
                String perm = "essentials.discord.receive." + group;
                boolean bl = primaryOverride = this.plugin.getSettings().isAlwaysReceivePrimary() && group.equalsIgnoreCase("primary");
                if (!primaryOverride && (!essUser.isPermissionSet(perm) || !essUser.isAuthorized(perm))) continue;
                viewers.add(essUser);
                continue block3;
            }
        }
        if (DiscordRelayEvent.getHandlerList().getRegisteredListeners().length != 0) {
            DiscordRelayEvent discordRelayEvent = new DiscordRelayEvent(new InteractionMemberImpl(member), new InteractionChannelImpl(event.getGuildChannel()), Collections.unmodifiableList(keys), event.getMessage().getContentRaw(), formattedMessage, viewers);
            Bukkit.getPluginManager().callEvent((Event)discordRelayEvent);
            if (discordRelayEvent.isCancelled()) {
                return;
            }
            formattedMessage = discordRelayEvent.getFormattedMessage();
        }
        for (IUser essUser : viewers) {
            essUser.sendMessage(formattedMessage);
        }
    }
}

