/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.interactions;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.api.v2.services.discord.InteractionRole;
import net.essentialsx.dep.net.dv8tion.jda.api.Permission;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Member;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Role;
import net.essentialsx.discord.util.DiscordUtil;

public class InteractionMemberImpl
implements InteractionMember {
    private final Member member;

    public InteractionMemberImpl(Member member) {
        this.member = member;
    }

    @Override
    public String getName() {
        return this.member.getUser().getName();
    }

    @Override
    public String getDiscriminator() {
        return this.member.getUser().getDiscriminator();
    }

    @Override
    public String getAsMention() {
        return this.member.getAsMention();
    }

    @Override
    public String getEffectiveName() {
        return this.member.getEffectiveName();
    }

    @Override
    public String getNickname() {
        return this.member.getNickname();
    }

    @Override
    public String getId() {
        return this.member.getId();
    }

    @Override
    public boolean isAdmin() {
        return this.member.hasPermission(Permission.ADMINISTRATOR);
    }

    @Override
    public boolean hasRoles(List<String> roleDefinitions) {
        return DiscordUtil.hasRoles(this.member, roleDefinitions);
    }

    @Override
    public boolean hasRole(InteractionRole role) {
        return this.hasRole(role.getId());
    }

    @Override
    public boolean hasRole(String roleId) {
        for (Role role : this.member.getRoles()) {
            if (!role.getId().equals(roleId)) continue;
            return true;
        }
        return false;
    }

    public Member getJdaObject() {
        return this.member;
    }

    @Override
    public CompletableFuture<Boolean> sendPrivateMessage(String content) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        CompletableFuture privateFuture = this.member.getUser().openPrivateChannel().submit();
        ((CompletableFuture)privateFuture.thenCompose(privateChannel -> privateChannel.sendMessage(content).submit())).whenComplete((m, error) -> {
            if (error != null) {
                future.complete(false);
                return;
            }
            future.complete(true);
        });
        return future;
    }
}

