/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.interactions;

import com.earth2me.essentials.utils.FormatUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.essentialsx.api.v2.services.discord.InteractionChannel;
import net.essentialsx.api.v2.services.discord.InteractionEvent;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.api.v2.services.discord.InteractionRole;
import net.essentialsx.dep.net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.essentialsx.dep.net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.essentialsx.discord.EssentialsDiscord;
import net.essentialsx.discord.interactions.InteractionChannelImpl;
import net.essentialsx.discord.interactions.InteractionMemberImpl;
import net.essentialsx.discord.interactions.InteractionRoleImpl;
import net.essentialsx.discord.util.DiscordUtil;

public class InteractionEventImpl
implements InteractionEvent {
    private static final Logger logger = EssentialsDiscord.getWrappedLogger();
    private final SlashCommandInteractionEvent event;
    private final InteractionMember member;
    private final List<String> replyBuffer = new ArrayList<String>();

    public InteractionEventImpl(SlashCommandInteractionEvent jdaEvent) {
        this.event = jdaEvent;
        this.member = new InteractionMemberImpl(jdaEvent.getMember());
    }

    @Override
    public void reply(String message) {
        message = FormatUtil.stripFormat((String)message).replace("\u00a7", "");
        this.replyBuffer.add(message);
        String reply = Joiner.on((char)'\n').join(this.replyBuffer);
        reply = reply.substring(0, Math.min(2000, reply.length()));
        this.event.getHook().editOriginal(((MessageEditBuilder)new MessageEditBuilder().setContent(reply).setAllowedMentions(DiscordUtil.NO_GROUP_MENTIONS)).build()).queue(null, error -> logger.log(Level.SEVERE, "Error while editing command interaction response", (Throwable)error));
    }

    @Override
    public InteractionMember getMember() {
        return this.member;
    }

    @Override
    public String getStringArgument(String key) {
        OptionMapping mapping = this.event.getOption(key);
        return mapping == null ? null : mapping.getAsString();
    }

    @Override
    public Long getIntegerArgument(String key) {
        OptionMapping mapping = this.event.getOption(key);
        return mapping == null ? null : Long.valueOf(mapping.getAsLong());
    }

    @Override
    public Boolean getBooleanArgument(String key) {
        OptionMapping mapping = this.event.getOption(key);
        return mapping == null ? null : Boolean.valueOf(mapping.getAsBoolean());
    }

    @Override
    public InteractionMember getUserArgument(String key) {
        OptionMapping mapping = this.event.getOption(key);
        return mapping == null ? null : new InteractionMemberImpl(mapping.getAsMember());
    }

    @Override
    public InteractionChannel getChannelArgument(String key) {
        OptionMapping mapping = this.event.getOption(key);
        return mapping == null ? null : new InteractionChannelImpl(mapping.getAsChannel().asGuildMessageChannel());
    }

    @Override
    public InteractionRole getRoleArgument(String key) {
        OptionMapping mapping = this.event.getOption(key);
        return mapping == null ? null : new InteractionRoleImpl(mapping.getAsRole());
    }

    @Override
    public String getChannelId() {
        return this.event.getChannel().getId();
    }
}

