/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.interactions;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.essentialsx.api.v2.services.discord.InteractionCommand;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.api.v2.services.discord.InteractionController;
import net.essentialsx.api.v2.services.discord.InteractionException;
import net.essentialsx.dep.net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.essentialsx.dep.net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.essentialsx.dep.net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.commands.Command;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.commands.OptionType;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.ErrorResponse;
import net.essentialsx.discord.EssentialsDiscord;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.interactions.InteractionEventImpl;
import net.essentialsx.discord.util.DiscordUtil;
import org.jetbrains.annotations.NotNull;

public class InteractionControllerImpl
extends ListenerAdapter
implements InteractionController {
    private static final Logger logger = EssentialsDiscord.getWrappedLogger();
    private final JDADiscordService jda;
    private final Map<String, InteractionCommand> commandMap = new ConcurrentHashMap<String, InteractionCommand>();
    private final Map<String, InteractionCommand> batchRegistrationQueue = new HashMap<String, InteractionCommand>();
    private boolean initialBatchRegistration = false;

    public InteractionControllerImpl(JDADiscordService jda) {
        this.jda = jda;
        jda.getJda().addEventListener(this);
    }

    @Override
    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        if (event.getGuild() == null || event.getMember() == null || !this.commandMap.containsKey(event.getName())) {
            return;
        }
        InteractionCommand command = this.commandMap.get(event.getName());
        if (command.isDisabled()) {
            event.reply(I18n.tl((String)"discordErrorCommandDisabled", (Object[])new Object[0])).setEphemeral(true).queue();
            return;
        }
        event.deferReply(command.isEphemeral()).queue(null, failure -> logger.log(Level.SEVERE, "Error while deferring Discord command", (Throwable)failure));
        InteractionEventImpl interactionEvent = new InteractionEventImpl(event);
        List<String> commandSnowflakes = this.jda.getSettings().getCommandSnowflakes(command.getName());
        if (commandSnowflakes != null && !DiscordUtil.hasRoles(event.getMember(), commandSnowflakes)) {
            interactionEvent.reply(I18n.tl((String)"noAccessCommand", (Object[])new Object[0]));
            return;
        }
        this.jda.getPlugin().getEss().scheduleSyncDelayedTask(() -> command.onCommand(interactionEvent));
    }

    @Override
    public InteractionCommand getCommand(String name) {
        return this.commandMap.get(name);
    }

    public void processBatchRegistration() {
        if (!this.initialBatchRegistration && !this.batchRegistrationQueue.isEmpty()) {
            this.initialBatchRegistration = true;
            ArrayList<SlashCommandData> list = new ArrayList<SlashCommandData>();
            for (InteractionCommand command : this.batchRegistrationQueue.values()) {
                String description = StringUtil.abbreviate((String)command.getDescription(), (int)100);
                SlashCommandData data = Commands.slash(command.getName(), description);
                if (command.getArguments() != null) {
                    for (InteractionCommandArgument argument : command.getArguments()) {
                        String argDescription = StringUtil.abbreviate((String)argument.getDescription(), (int)100);
                        data.addOption(OptionType.valueOf(argument.getType().name()), argument.getName(), argDescription, argument.isRequired());
                    }
                }
                list.add(data);
            }
            this.jda.getGuild().updateCommands().addCommands(list).queue(success -> {
                for (Command command : success) {
                    this.commandMap.put(command.getName(), this.batchRegistrationQueue.get(command.getName()));
                    this.batchRegistrationQueue.remove(command.getName());
                    if (!this.jda.isDebug()) continue;
                    logger.info("Registered guild command " + command.getName() + " with id " + command.getId());
                }
                if (!this.batchRegistrationQueue.isEmpty()) {
                    logger.warning(this.batchRegistrationQueue.size() + " Discord commands were lost during command registration!");
                    if (this.jda.isDebug()) {
                        logger.warning("Lost commands: " + this.batchRegistrationQueue.keySet());
                    }
                    this.batchRegistrationQueue.clear();
                }
            }, failure -> {
                if (failure instanceof ErrorResponseException && ((ErrorResponseException)failure).getErrorResponse() == ErrorResponse.MISSING_ACCESS) {
                    logger.severe(I18n.tl((String)"discordErrorCommand", (Object[])new Object[0]));
                    return;
                }
                logger.log(Level.SEVERE, "Error while registering command", (Throwable)failure);
            });
        }
    }

    @Override
    public void registerCommand(InteractionCommand command) throws InteractionException {
        if (command.isDisabled()) {
            throw new InteractionException("The given command has been disabled!");
        }
        if (this.commandMap.containsKey(command.getName())) {
            throw new InteractionException("A command with that name is already registered!");
        }
        if (!this.initialBatchRegistration) {
            if (this.jda.isDebug()) {
                logger.info("Marked guild command for batch registration: " + command.getName());
            }
            this.batchRegistrationQueue.put(command.getName(), command);
            return;
        }
        SlashCommandData data = Commands.slash(command.getName(), command.getDescription());
        if (command.getArguments() != null) {
            for (InteractionCommandArgument argument : command.getArguments()) {
                data.addOption(OptionType.valueOf(argument.getType().name()), argument.getName(), argument.getDescription(), argument.isRequired());
            }
        }
        this.jda.getGuild().upsertCommand(data).queue(success -> {
            this.commandMap.put(command.getName(), command);
            if (this.jda.isDebug()) {
                logger.info("Registered guild command " + success.getName() + " with id " + success.getId());
            }
        }, failure -> {
            if (failure instanceof ErrorResponseException && ((ErrorResponseException)failure).getErrorResponse() == ErrorResponse.MISSING_ACCESS) {
                logger.severe(I18n.tl((String)"discordErrorCommand", (Object[])new Object[0]));
                return;
            }
            logger.log(Level.SEVERE, "Error while registering command", (Throwable)failure);
        });
    }

    public void shutdown() {
        block2: {
            try {
                this.jda.getGuild().updateCommands().complete();
            }
            catch (Throwable e) {
                logger.severe("Error while deleting commands: " + e.getMessage());
                if (!this.jda.isDebug()) break block2;
                e.printStackTrace();
            }
        }
        this.commandMap.clear();
    }
}

