/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiParser;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.util.DiscordUtil;
import net.essentialsx.discord.util.MessageUtil;
import org.bukkit.Server;

public class Commanddiscordbroadcast
extends EssentialsCommand {
    public Commanddiscordbroadcast() {
        super("discordbroadcast");
    }

    protected void run(Server server, CommandSource sender, String commandLabel, String[] args2) throws Exception {
        JDADiscordService jda;
        TextChannel channel;
        if (args2.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        if (!sender.isAuthorized("essentials.discordbroadcast." + args2[0], (IEssentials)this.ess)) {
            throw new Exception(I18n.tl((String)"discordbroadcastPermission", (Object[])new Object[]{args2[0]}));
        }
        String message = Commanddiscordbroadcast.getFinalArg((String[])args2, (int)1);
        if (!sender.isAuthorized("essentials.discordbroadcast.markdown", (IEssentials)this.ess)) {
            message = MessageUtil.sanitizeDiscordMarkdown(message);
        }
        if ((channel = (jda = (JDADiscordService)this.module).getDefinedChannel(args2[0], false)) == null) {
            throw new Exception(I18n.tl((String)"discordbroadcastInvalidChannel", (Object[])new Object[]{args2[0]}));
        }
        if (!channel.canTalk()) {
            throw new Exception(I18n.tl((String)"discordNoSendPermission", (Object[])new Object[]{channel.getName()}));
        }
        ((MessageCreateAction)channel.sendMessage(jda.parseMessageEmotes(message)).setAllowedMentions(sender.isAuthorized("essentials.discordbroadcast.ping", (IEssentials)this.ess) ? null : DiscordUtil.NO_GROUP_MENTIONS)).queue();
        sender.sendMessage(I18n.tl((String)"discordbroadcastSent", (Object[])new Object[]{"#" + EmojiParser.parseToAliases(channel.getName())}));
    }

    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args2) {
        if (args2.length == 1) {
            JDADiscordService jda = (JDADiscordService)this.module;
            List<String> channels = jda.getSettings().getChannelNames();
            channels.removeIf(s -> !sender.isAuthorized("essentials.discordbroadcast." + s, (IEssentials)this.ess));
            return channels;
        }
        String curArg = args2[args2.length - 1];
        if (!(curArg.isEmpty() || curArg.charAt(0) != ':' || curArg.length() != 1 && curArg.charAt(curArg.length() - 1) == ':')) {
            JDADiscordService jda = (JDADiscordService)this.module;
            if (jda.getGuild().getEmojiCache().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> completions = new ArrayList<String>();
            for (RichCustomEmoji emote : jda.getGuild().getEmojiCache()) {
                completions.add(":" + emote.getName() + ":");
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

