/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.config.ConfigurateUtil;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.utils.FormatUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.clip.placeholderapi.PlaceholderAPI;
import net.essentialsx.api.v2.ChatType;
import net.essentialsx.dep.net.dv8tion.jda.api.OnlineStatus;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Activity;
import net.essentialsx.discord.EssentialsDiscord;
import org.apache.logging.log4j.Level;
import org.bukkit.entity.Player;

public class DiscordSettings
implements IConf {
    private final EssentialsConfiguration config;
    private final EssentialsDiscord plugin;
    private final Map<String, Long> nameToChannelIdMap = new HashMap<String, Long>();
    private final Map<Long, List<String>> channelIdToNamesMap = new HashMap<Long, List<String>>();
    private OnlineStatus status;
    private Activity statusActivity;
    private List<Pattern> discordFilter;
    private MessageFormat consoleFormat;
    private Level consoleLogLevel;
    private List<Pattern> consoleFilter;
    private MessageFormat discordToMcFormat;
    private MessageFormat tempMuteFormat;
    private MessageFormat tempMuteReasonFormat;
    private MessageFormat permMuteFormat;
    private MessageFormat permMuteReasonFormat;
    private MessageFormat unmuteFormat;
    private MessageFormat kickFormat;

    public DiscordSettings(EssentialsDiscord plugin) {
        this.plugin = plugin;
        this.config = new EssentialsConfiguration(new File(plugin.getDataFolder(), "config.yml"), "/config.yml", EssentialsDiscord.class);
        this.reloadConfig();
    }

    public String getBotToken() {
        return this.config.getString("token", "");
    }

    public long getGuildId() {
        return this.config.getLong("guild", 0L);
    }

    public String getDiscordUrl() {
        return this.config.getString("discord-url", "https://discord.gg/invite-code");
    }

    public long getPrimaryChannelId() {
        return this.config.getLong("channels.primary", 0L);
    }

    public long getChannelId(String key) {
        try {
            return Long.parseLong(key);
        }
        catch (NumberFormatException ignored) {
            return this.nameToChannelIdMap.getOrDefault(key, 0L);
        }
    }

    public List<String> getChannelNames() {
        return new ArrayList<String>(this.nameToChannelIdMap.keySet());
    }

    public List<String> getKeysFromChannelId(long channelId) {
        return this.channelIdToNamesMap.get(channelId);
    }

    public String getMessageChannel(String key) {
        return this.config.getString("message-types." + key, "none");
    }

    public boolean isShowDiscordAttachments() {
        return this.config.getBoolean("show-discord-attachments", true);
    }

    public List<String> getPermittedFormattingRoles() {
        return this.config.getList("permit-formatting-roles", String.class);
    }

    public OnlineStatus getStatus() {
        return this.status;
    }

    public Activity getStatusActivity() {
        return this.statusActivity;
    }

    public boolean isAlwaysReceivePrimary() {
        return this.config.getBoolean("always-receive-primary", false);
    }

    public boolean isUseEssentialsEvents() {
        return this.config.getBoolean("use-essentials-events", false);
    }

    public int getChatDiscordMaxLength() {
        return this.config.getInt("chat.discord-max-length", 2000);
    }

    public boolean isChatFilterNewlines() {
        return this.config.getBoolean("chat.filter-newlines", true);
    }

    public List<Pattern> getDiscordFilters() {
        return this.discordFilter;
    }

    public boolean isShowWebhookMessages() {
        return this.config.getBoolean("chat.show-webhook-messages", false);
    }

    public boolean isShowBotMessages() {
        return this.config.getBoolean("chat.show-bot-messages", false);
    }

    public boolean isShowAllChat() {
        return this.config.getBoolean("chat.show-all-chat", false);
    }

    public List<String> getRelayToConsoleList() {
        return this.config.getList("chat.relay-to-console", String.class);
    }

    public String getConsoleChannelDef() {
        return this.config.getString("console.channel", "none");
    }

    public MessageFormat getConsoleFormat() {
        return this.consoleFormat;
    }

    public String getConsoleWebhookName() {
        return this.config.getString("console.webhook-name", "EssentialsX Console Relay");
    }

    public boolean isConsoleCommandRelay() {
        return this.config.getBoolean("console.command-relay", false);
    }

    public boolean isConsoleBotCommandRelay() {
        return this.config.getBoolean("console.bot-command-relay", false);
    }

    public Level getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public List<Pattern> getConsoleFilters() {
        return this.consoleFilter;
    }

    public int getConsoleSkipDelay() {
        return this.config.getInt("console.skip-delay", 2);
    }

    public boolean isShowAvatar() {
        return this.config.getBoolean("show-avatar", false);
    }

    public boolean isShowName() {
        return this.config.getBoolean("show-name", false);
    }

    public boolean isShowDisplayName() {
        return this.config.getBoolean("show-displayname", false);
    }

    public String getAvatarURL() {
        return this.config.getString("avatar-url", "https://crafthead.net/helm/{uuid}");
    }

    public boolean isVanishFakeJoinLeave() {
        return this.config.getBoolean("vanish-fake-join-leave", true);
    }

    public boolean isVanishHideMessages() {
        return this.config.getBoolean("vanish-hide-messages", true);
    }

    public boolean isCommandEnabled(String command) {
        return this.config.getBoolean("commands." + command + ".enabled", true);
    }

    public boolean isCommandEphemeral(String command) {
        return this.config.getBoolean("commands." + command + ".hide-command", true);
    }

    public List<String> getCommandSnowflakes(String command) {
        if (this.config.isList("commands." + command + ".allowed-roles")) {
            return this.config.getList("commands." + command + ".allowed-roles", String.class);
        }
        return null;
    }

    public List<String> getCommandAdminSnowflakes(String command) {
        return this.config.getList("commands." + command + ".admin-roles", String.class);
    }

    public MessageFormat getDiscordToMcFormat() {
        return this.discordToMcFormat;
    }

    public MessageFormat getMcToDiscordFormat(Player player) {
        return this.getMcToDiscordFormat(player, ChatType.UNKNOWN);
    }

    public MessageFormat getMcToDiscordFormat(Player player, ChatType chatType) {
        String format = this.getFormatString(this.getMcToDiscordFormatKey(chatType));
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, this.getMcToDiscordDefaultFormat(chatType), false, "username", "displayname", "message", "world", "prefix", "suffix");
    }

    private String getMcToDiscordFormatKey(ChatType chatType) {
        switch (chatType) {
            case LOCAL: {
                return "mc-to-discord-local";
            }
            case QUESTION: {
                return "mc-to-discord-question";
            }
            case SHOUT: {
                return "mc-to-discord-shout";
            }
        }
        return "mc-to-discord";
    }

    private String getMcToDiscordDefaultFormat(ChatType chatType) {
        switch (chatType) {
            case LOCAL: {
                return "**[Local]** {displayname}: {message}";
            }
            case QUESTION: {
                return "**[Question]** {displayname}: {message}";
            }
            case SHOUT: {
                return "**[Shout]** {displayname}: {message}";
            }
        }
        return "{displayname}: {message}";
    }

    public String getLegacyNameFormat() {
        if (this.isShowDisplayName()) {
            return "{displayname}";
        }
        if (this.isShowName()) {
            return "{username}";
        }
        return null;
    }

    public MessageFormat getMcToDiscordNameFormat(Player player) {
        String format = this.getFormatString("mc-to-discord-name-format");
        if (format == null) {
            format = this.getLegacyNameFormat();
        }
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, "{botname}", false, "username", "displayname", "world", "prefix", "suffix", "botname");
    }

    public MessageFormat getTempMuteFormat() {
        return this.tempMuteFormat;
    }

    public MessageFormat getTempMuteReasonFormat() {
        return this.tempMuteReasonFormat;
    }

    public MessageFormat getPermMuteFormat() {
        return this.permMuteFormat;
    }

    public MessageFormat getPermMuteReasonFormat() {
        return this.permMuteReasonFormat;
    }

    public MessageFormat getUnmuteFormat() {
        return this.unmuteFormat;
    }

    public MessageFormat getJoinFormat(Player player) {
        String format = this.getFormatString("join");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":arrow_right: {displayname} has joined!", false, "username", "displayname", "joinmessage", "online", "unique");
    }

    public MessageFormat getFirstJoinFormat(Player player) {
        String format = this.getFormatString("first-join");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":arrow_right: :first_place: {displayname} has joined the server for the first time!", false, "username", "displayname", "joinmessage", "online", "unique");
    }

    public MessageFormat getQuitFormat(Player player) {
        String format = this.getFormatString("quit");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":arrow_left: {displayname} has left!", false, "username", "displayname", "quitmessage", "online", "unique");
    }

    public MessageFormat getDeathFormat(Player player) {
        String format = this.getFormatString("death");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":skull: {deathmessage}", false, "username", "displayname", "deathmessage");
    }

    public MessageFormat getAfkFormat(Player player) {
        String format = this.getFormatString("afk");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":person_walking: {displayname} is now AFK!", false, "username", "displayname");
    }

    public MessageFormat getUnAfkFormat(Player player) {
        String format = this.getFormatString("un-afk");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":keyboard: {displayname} is no longer AFK!", false, "username", "displayname");
    }

    public MessageFormat getAdvancementFormat(Player player) {
        String format = this.getFormatString("advancement");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":medal: {displayname} has completed the advancement **{advancement}**!", false, "username", "displayname", "advancement");
    }

    public MessageFormat getActionFormat(Player player) {
        String format = this.getFormatString("action");
        String filled = this.plugin.isPAPI() && format != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format;
        return this.generateMessageFormat(filled, ":person_biking: {displayname} *{action}*", false, "username", "displayname", "action");
    }

    public String getStartMessage() {
        return this.config.getString("messages.server-start", ":white_check_mark: The server has started!");
    }

    public String getStopMessage() {
        return this.config.getString("messages.server-stop", ":octagonal_sign: The server has stopped!");
    }

    public MessageFormat getKickFormat() {
        return this.kickFormat;
    }

    private String getFormatString(String node) {
        String pathPrefix = node.startsWith(".") ? "" : "messages.";
        return this.config.getString(pathPrefix + (pathPrefix.isEmpty() ? node.substring(1) : node), null);
    }

    private MessageFormat generateMessageFormat(String content, String defaultStr, boolean format, String ... arguments) {
        content = content == null ? defaultStr : content;
        content = format ? FormatUtil.replaceFormat((String)content) : FormatUtil.stripFormat((String)content);
        content = content.replace("'", "''");
        for (int i = 0; i < arguments.length; ++i) {
            content = content.replace("{" + arguments[i] + "}", "{" + i + "}");
            content = content.replace("{" + arguments[i].toUpperCase() + "}", "{" + i + "}");
        }
        content = content.replaceAll("\\{([^0-9]+)}", "'{$1}'");
        return new MessageFormat(content);
    }

    public void reloadConfig() {
        ArrayList<Pattern> filters;
        if (this.plugin.isInvalidStartup()) {
            this.plugin.getLogger().warning(I18n.tl((String)"discordReloadInvalid", (Object[])new Object[0]));
            return;
        }
        this.config.load();
        this.nameToChannelIdMap.clear();
        this.channelIdToNamesMap.clear();
        Map section = ConfigurateUtil.getRawMap((EssentialsConfiguration)this.config, (String)"channels");
        for (Map.Entry entry : section.entrySet()) {
            if (!(entry.getValue() instanceof Long)) continue;
            long value = (Long)entry.getValue();
            this.nameToChannelIdMap.put((String)entry.getKey(), value);
            this.channelIdToNamesMap.computeIfAbsent(value, o -> new ArrayList()).add((String)entry.getKey());
        }
        this.status = OnlineStatus.fromKey(this.config.getString("presence.status", "online"));
        if (this.status == OnlineStatus.UNKNOWN) {
            this.status = OnlineStatus.ONLINE;
        }
        String activity = this.config.getString("presence.activity", "default").trim().toUpperCase().replace("CUSTOM_STATUS", "DEFAULT");
        this.statusActivity = null;
        Activity.ActivityType activityType = null;
        try {
            if (!activity.equals("NONE")) {
                activityType = Activity.ActivityType.valueOf(activity);
            }
        }
        catch (IllegalArgumentException e) {
            activityType = Activity.ActivityType.PLAYING;
        }
        if (activityType != null) {
            this.statusActivity = Activity.of(activityType, this.config.getString("presence.message", "Minecraft"));
        }
        if (this.config.isList("chat.discord-filter")) {
            filters = new ArrayList<Pattern>();
            for (String chatFilterString : this.config.getList("chat.discord-filter", String.class)) {
                if (chatFilterString == null || chatFilterString.trim().isEmpty()) continue;
                try {
                    filters.add(Pattern.compile(chatFilterString));
                }
                catch (PatternSyntaxException e) {
                    this.plugin.getLogger().log(java.util.logging.Level.WARNING, "Invalid pattern for \"chat.discord-filter\": " + e.getMessage());
                }
            }
            this.discordFilter = Collections.unmodifiableList(filters);
        } else {
            try {
                String chatFilter = this.config.getString("chat.discord-filter", null);
                this.discordFilter = chatFilter != null && !chatFilter.trim().isEmpty() ? Collections.singletonList(Pattern.compile(chatFilter)) : Collections.emptyList();
            }
            catch (PatternSyntaxException e) {
                this.plugin.getLogger().log(java.util.logging.Level.WARNING, "Invalid pattern for \"chat.discord-filter\": " + e.getMessage());
                this.discordFilter = Collections.emptyList();
            }
        }
        this.consoleLogLevel = Level.toLevel((String)this.config.getString("console.log-level", null), (Level)Level.INFO);
        if (this.config.isList("console.console-filter")) {
            filters = new ArrayList();
            for (String filterString : this.config.getList("console.console-filter", String.class)) {
                if (filterString == null || filterString.trim().isEmpty()) continue;
                try {
                    filters.add(Pattern.compile(filterString));
                }
                catch (PatternSyntaxException e) {
                    this.plugin.getLogger().log(java.util.logging.Level.WARNING, "Invalid pattern for \"console.log-level\": " + e.getMessage());
                }
            }
            this.consoleFilter = Collections.unmodifiableList(filters);
        } else {
            try {
                String cFilter = this.config.getString("console.console-filter", null);
                this.consoleFilter = cFilter != null && !cFilter.trim().isEmpty() ? Collections.singletonList(Pattern.compile(cFilter)) : Collections.emptyList();
            }
            catch (PatternSyntaxException e) {
                this.plugin.getLogger().log(java.util.logging.Level.WARNING, "Invalid pattern for \"console.log-level\": " + e.getMessage());
                this.consoleFilter = Collections.emptyList();
            }
        }
        this.consoleFormat = this.generateMessageFormat(this.getFormatString(".console.format"), "[{timestamp} {level}] {message}", false, "timestamp", "level", "message");
        this.discordToMcFormat = this.generateMessageFormat(this.getFormatString("discord-to-mc"), "&6[#{channel}] &3{fullname}&7: &f{message}", true, "channel", "username", "discriminator", "fullname", "nickname", "color", "message", "role");
        this.unmuteFormat = this.generateMessageFormat(this.getFormatString("unmute"), "{displayname} unmuted.", false, "username", "displayname");
        this.tempMuteFormat = this.generateMessageFormat(this.getFormatString("temporary-mute"), "{controllerdisplayname} has muted player {displayname} for {time}.", false, "username", "displayname", "controllername", "controllerdisplayname", "time");
        this.permMuteFormat = this.generateMessageFormat(this.getFormatString("permanent-mute"), "{controllerdisplayname} permanently muted {displayname}.", false, "username", "displayname", "controllername", "controllerdisplayname");
        this.tempMuteReasonFormat = this.generateMessageFormat(this.getFormatString("temporary-mute-reason"), "{controllerdisplayname} has muted player {displayname} for {time}. Reason: {reason}.", false, "username", "displayname", "controllername", "controllerdisplayname", "time", "reason");
        this.permMuteReasonFormat = this.generateMessageFormat(this.getFormatString("permanent-mute-reason"), "{controllerdisplayname} has muted player {displayname}. Reason: {reason}.", false, "username", "displayname", "controllername", "controllerdisplayname", "reason");
        this.kickFormat = this.generateMessageFormat(this.getFormatString("kick"), "{displayname} was kicked with reason: {reason}", false, "username", "displayname", "reason");
        this.plugin.onReload();
    }
}

