/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.internal.interactions;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.essentialsx.dep.net.dv8tion.jda.api.JDA;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Message;
import net.essentialsx.dep.net.dv8tion.jda.api.exceptions.InteractionExpiredException;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.InteractionHook;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.RestAction;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.Route;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.essentialsx.dep.net.dv8tion.jda.api.utils.MiscUtil;
import net.essentialsx.dep.net.dv8tion.jda.api.utils.data.DataObject;
import net.essentialsx.dep.net.dv8tion.jda.internal.JDAImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.entities.AbstractWebhookClient;
import net.essentialsx.dep.net.dv8tion.jda.internal.entities.ReceivedMessage;
import net.essentialsx.dep.net.dv8tion.jda.internal.interactions.DeferrableInteractionImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.interactions.InteractionImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.requests.restaction.TriggerRestAction;
import net.essentialsx.dep.net.dv8tion.jda.internal.requests.restaction.WebhookMessageCreateActionImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.requests.restaction.WebhookMessageEditActionImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.utils.Checks;
import net.essentialsx.dep.net.dv8tion.jda.internal.utils.JDALogger;

public class InteractionHookImpl
extends AbstractWebhookClient<Message>
implements InteractionHook {
    public static final String TIMEOUT_MESSAGE = "Timed out waiting for interaction acknowledgement";
    private final DeferrableInteractionImpl interaction;
    private final List<TriggerRestAction<?>> readyCallbacks = new LinkedList();
    private final Future<?> timeoutHandle;
    private final ReentrantLock mutex = new ReentrantLock();
    private Exception exception;
    private boolean isReady;
    private boolean ephemeral;

    public InteractionHookImpl(@Nonnull DeferrableInteractionImpl interaction, @Nonnull JDA api) {
        super(api.getSelfUser().getApplicationIdLong(), interaction.getToken(), api);
        this.interaction = interaction;
        this.timeoutHandle = api.getGatewayPool().schedule(() -> this.fail(new TimeoutException(TIMEOUT_MESSAGE)), 10L, TimeUnit.SECONDS);
    }

    public boolean ack() {
        return this.interaction.ack();
    }

    public boolean isAck() {
        return this.interaction.isAcknowledged();
    }

    public void ready() {
        MiscUtil.locked(this.mutex, () -> {
            this.timeoutHandle.cancel(false);
            this.isReady = true;
            this.readyCallbacks.forEach(TriggerRestAction::run);
        });
    }

    public void fail(Exception exception) {
        MiscUtil.locked(this.mutex, () -> {
            if (!this.isReady && this.exception == null) {
                this.exception = exception;
                if (!this.readyCallbacks.isEmpty()) {
                    if (exception instanceof TimeoutException) {
                        JDALogger.getLog(InteractionHook.class).warn("Up to {} Interaction Followup Messages Timed out! Did you forget to acknowledge the interaction?", (Object)this.readyCallbacks.size());
                    }
                    this.readyCallbacks.forEach(callback -> callback.fail(exception));
                }
            }
        });
    }

    private <T extends TriggerRestAction<R>, R> T onReady(T runnable2) {
        return (T)MiscUtil.locked(this.mutex, () -> {
            if (this.isReady) {
                runnable2.run();
            } else if (this.exception != null) {
                runnable2.fail(this.exception);
            } else {
                this.readyCallbacks.add(runnable2);
            }
            return runnable2;
        });
    }

    @Override
    @Nonnull
    public InteractionImpl getInteraction() {
        return this.interaction;
    }

    @Override
    @Nonnull
    public InteractionHook setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
        return this;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nonnull
    public RestAction<Message> retrieveOriginal() {
        JDAImpl jda = (JDAImpl)this.getJDA();
        Route.CompiledRoute route = Route.Interactions.GET_ORIGINAL.compile(jda.getSelfUser().getApplicationId(), this.interaction.getToken());
        TriggerRestAction<Message> action = new TriggerRestAction<Message>((JDA)jda, route, (response, request) -> this.createMessage(jda, response.getObject()));
        action.setCheck(this::checkExpired);
        return this.onReady(action);
    }

    @Override
    @Nonnull
    public WebhookMessageCreateActionImpl<Message> sendRequest() {
        Route.CompiledRoute route = Route.Interactions.CREATE_FOLLOWUP.compile(this.getJDA().getSelfUser().getApplicationId(), this.interaction.getToken());
        route = route.withQueryParams("wait", "true");
        Function<DataObject, Message> transform = json -> this.createMessage((JDAImpl)this.api, (DataObject)json);
        WebhookMessageCreateAction action = new WebhookMessageCreateActionImpl<Message>(this.getJDA(), route, transform).setEphemeral(this.ephemeral);
        ((WebhookMessageCreateActionImpl)action).setCheck(this::checkExpired);
        return (WebhookMessageCreateActionImpl)this.onReady(action);
    }

    @Override
    @Nonnull
    public WebhookMessageEditActionImpl<Message> editRequest(String messageId) {
        if (!"@original".equals(messageId)) {
            Checks.isSnowflake(messageId);
        }
        Route.CompiledRoute route = Route.Interactions.EDIT_FOLLOWUP.compile(this.getJDA().getSelfUser().getApplicationId(), this.interaction.getToken(), messageId);
        route = route.withQueryParams("wait", "true");
        Function<DataObject, Message> transform = json -> this.createMessage((JDAImpl)this.api, (DataObject)json);
        WebhookMessageEditActionImpl<Message> action = new WebhookMessageEditActionImpl<Message>(this.getJDA(), route, transform);
        action.setCheck(this::checkExpired);
        return this.onReady(action);
    }

    @Override
    @Nonnull
    public RestAction<Void> deleteMessageById(@Nonnull String messageId) {
        if (!"@original".equals(messageId)) {
            Checks.isSnowflake(messageId);
        }
        Route.CompiledRoute route = Route.Interactions.DELETE_FOLLOWUP.compile(this.getJDA().getSelfUser().getApplicationId(), this.interaction.getToken(), messageId);
        TriggerRestAction action = new TriggerRestAction(this.getJDA(), route);
        action.setCheck(this::checkExpired);
        return this.onReady(action);
    }

    private ReceivedMessage createMessage(JDAImpl jda, DataObject json) {
        return jda.getEntityBuilder().createMessageWithChannel(json, this.getInteraction().getMessageChannel(), false);
    }

    private boolean checkExpired() {
        if (this.isExpired()) {
            throw new InteractionExpiredException();
        }
        return true;
    }
}

