/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.api.interactions.components.selections;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.ChannelType;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.components.Component;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.essentialsx.dep.net.dv8tion.jda.internal.interactions.component.EntitySelectMenuImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.utils.Checks;
import net.essentialsx.dep.net.dv8tion.jda.internal.utils.Helpers;

public interface EntitySelectMenu
extends SelectMenu {
    @Override
    @Nonnull
    default public EntitySelectMenu asDisabled() {
        return (EntitySelectMenu)SelectMenu.super.asDisabled();
    }

    @Override
    @Nonnull
    default public EntitySelectMenu asEnabled() {
        return (EntitySelectMenu)SelectMenu.super.asEnabled();
    }

    @Override
    @Nonnull
    default public EntitySelectMenu withDisabled(boolean disabled) {
        return ((Builder)this.createCopy().setDisabled(disabled)).build();
    }

    @Nonnull
    public EnumSet<SelectTarget> getEntityTypes();

    @Nonnull
    public EnumSet<ChannelType> getChannelTypes();

    @Nonnull
    @CheckReturnValue
    default public Builder createCopy() {
        Builder builder = EntitySelectMenu.create(this.getId(), this.getEntityTypes());
        EnumSet<ChannelType> channelTypes = this.getChannelTypes();
        if (!channelTypes.isEmpty()) {
            builder.setChannelTypes(channelTypes);
        }
        builder.setRequiredRange(this.getMinValues(), this.getMaxValues());
        builder.setPlaceholder(this.getPlaceholder());
        builder.setDisabled(this.isDisabled());
        return builder;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder create(@Nonnull String customId, @Nonnull Collection<SelectTarget> types) {
        return new Builder(customId).setEntityTypes(types);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder create(@Nonnull String customId, @Nonnull SelectTarget type, SelectTarget ... types) {
        Checks.notNull((Object)type, "Type");
        Checks.noneNull((Object[])types, "Types");
        return EntitySelectMenu.create(customId, EnumSet.of(type, types));
    }

    public static class Builder
    extends SelectMenu.Builder<EntitySelectMenu, Builder> {
        protected Component.Type componentType;
        protected EnumSet<ChannelType> channelTypes = EnumSet.noneOf(ChannelType.class);

        protected Builder(@Nonnull String customId) {
            super(customId);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nonnull
        public Builder setEntityTypes(@Nonnull Collection<SelectTarget> types) {
            Checks.notEmpty(types, "Types");
            Checks.noneNull(types, "Types");
            EnumSet<SelectTarget> set = Helpers.copyEnumSet(SelectTarget.class, types);
            if (set.size() == 1) {
                if (set.contains((Object)SelectTarget.CHANNEL)) {
                    this.componentType = Component.Type.CHANNEL_SELECT;
                    return this;
                } else if (set.contains((Object)SelectTarget.ROLE)) {
                    this.componentType = Component.Type.ROLE_SELECT;
                    return this;
                } else {
                    if (!set.contains((Object)SelectTarget.USER)) return this;
                    this.componentType = Component.Type.USER_SELECT;
                }
                return this;
            } else {
                if (set.size() != 2) throw new IllegalArgumentException("The provided combination of select targets is not supported. Provided: " + set);
                if (!set.contains((Object)SelectTarget.USER) || !set.contains((Object)SelectTarget.ROLE)) throw new IllegalArgumentException("The provided combination of select targets is not supported. Provided: " + set);
                this.componentType = Component.Type.MENTIONABLE_SELECT;
            }
            return this;
        }

        @Nonnull
        public Builder setEntityTypes(@Nonnull SelectTarget type, SelectTarget ... types) {
            Checks.notNull((Object)type, "Type");
            Checks.noneNull((Object[])types, "Types");
            return this.setEntityTypes(EnumSet.of(type, types));
        }

        @Nonnull
        public Builder setChannelTypes(@Nonnull Collection<ChannelType> types) {
            Checks.noneNull(types, "Types");
            for (ChannelType type : types) {
                Checks.check(type.isGuild(), "Only guild channel types are allowed! Provided: %s", (Object)type);
            }
            this.channelTypes = Helpers.copyEnumSet(ChannelType.class, types);
            return this;
        }

        @Nonnull
        public Builder setChannelTypes(ChannelType ... types) {
            return this.setChannelTypes(Arrays.asList(types));
        }

        @Override
        @Nonnull
        public EntitySelectMenu build() {
            Checks.check(this.minValues <= this.maxValues, "Min values cannot be greater than max values!");
            EnumSet<ChannelType> channelTypes = this.componentType == Component.Type.CHANNEL_SELECT ? this.channelTypes : EnumSet.noneOf(ChannelType.class);
            return new EntitySelectMenuImpl(this.customId, this.placeholder, this.minValues, this.maxValues, this.disabled, this.componentType, channelTypes);
        }
    }

    public static enum SelectTarget {
        USER,
        ROLE,
        CHANNEL;

    }
}

