/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.com.vdurmont.emoji;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiCategory;
import net.essentialsx.dep.com.vdurmont.emoji.Fitzpatrick;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Emoji {
    protected final String description;
    protected final boolean supportsFitzpatrick;
    protected final boolean hasVariation;
    protected final List<String> aliases;
    protected final List<String> tags;
    protected final EmojiCategory category;
    protected final String unicode;
    protected final String trimmedUnicode;
    protected final String htmlDec;
    protected final String htmlHex;

    protected Emoji(String description, boolean supportsFitzpatrick, EmojiCategory category, List<String> aliases, List<String> tags, byte ... bytes) {
        int codePoint;
        this.description = description;
        this.supportsFitzpatrick = supportsFitzpatrick;
        this.category = category;
        this.aliases = Collections.unmodifiableList(aliases);
        this.tags = Collections.unmodifiableList(tags);
        int count = 0;
        this.unicode = new String(bytes, StandardCharsets.UTF_8);
        int stringLength = this.getUnicode().length();
        String[] pointCodes = new String[stringLength];
        String[] pointCodesHex = new String[stringLength];
        for (int offset = 0; offset < stringLength; offset += Character.charCount(codePoint)) {
            codePoint = this.getUnicode().codePointAt(offset);
            pointCodes[count] = String.format(Locale.ROOT, "&#%d;", codePoint);
            pointCodesHex[count++] = String.format(Locale.ROOT, "&#x%x;", codePoint);
        }
        this.htmlDec = String.join((CharSequence)"", Arrays.copyOf(pointCodes, count));
        this.htmlHex = String.join((CharSequence)"", Arrays.copyOf(pointCodesHex, count));
        this.hasVariation = this.unicode.contains("\ufe0f");
        this.trimmedUnicode = this.hasVariation ? this.unicode.replace("\ufe0f", "") : this.unicode;
    }

    protected Emoji setDescription(String description) {
        return new Emoji(description, this.supportsFitzpatrick, this.category, this.aliases, this.tags, this.unicode.getBytes(StandardCharsets.UTF_8));
    }

    protected Emoji setFitzpatrick(boolean supportsFitzpatrick) {
        return new Emoji(this.description, supportsFitzpatrick, this.category, this.aliases, this.tags, this.unicode.getBytes(StandardCharsets.UTF_8));
    }

    protected Emoji setCategory(EmojiCategory category) {
        return new Emoji(this.description, this.supportsFitzpatrick, category, this.aliases, this.tags, this.unicode.getBytes(StandardCharsets.UTF_8));
    }

    protected Emoji setAliases(List<String> aliases) {
        return new Emoji(this.description, this.supportsFitzpatrick, this.category, aliases, this.tags, this.unicode.getBytes(StandardCharsets.UTF_8));
    }

    protected Emoji setTags(List<String> tags) {
        return new Emoji(this.description, this.supportsFitzpatrick, this.category, this.aliases, tags, this.unicode.getBytes(StandardCharsets.UTF_8));
    }

    protected Emoji setBytes(byte ... bytes) {
        return new Emoji(this.description, this.supportsFitzpatrick, this.category, this.aliases, this.tags, bytes);
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public boolean supportsFitzpatrick() {
        return this.supportsFitzpatrick;
    }

    public boolean supportsVariation() {
        return this.hasVariation;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public String getUnicode() {
        return this.unicode;
    }

    @NotNull
    public String getTrimmedUnicode() {
        return this.trimmedUnicode;
    }

    @NotNull
    public EmojiCategory getCategory() {
        return this.category;
    }

    @NotNull
    public String getUnicode(@Nullable Fitzpatrick fitzpatrick) {
        if (!this.supportsFitzpatrick()) {
            throw new IllegalStateException("Cannot get the unicode with a fitzpatrick modifier, the emoji doesn't support fitzpatrick.");
        }
        if (fitzpatrick == null) {
            return this.getUnicode();
        }
        return this.getUnicode() + fitzpatrick.unicode;
    }

    @NotNull
    public String getTrimmedUnicode(@Nullable Fitzpatrick fitzpatrick) {
        if (!this.supportsFitzpatrick()) {
            throw new IllegalStateException("Cannot get the unicode with a fitzpatrick modifier, the emoji doesn't support fitzpatrick.");
        }
        if (fitzpatrick == null) {
            return this.getTrimmedUnicode();
        }
        return this.getTrimmedUnicode() + fitzpatrick.unicode;
    }

    @NotNull
    public String getHtmlDecimal() {
        return this.htmlDec;
    }

    @NotNull
    public String getHtmlHexadecimal() {
        return this.htmlHex;
    }

    public boolean equals(Object other) {
        return other instanceof Emoji && ((Emoji)other).getUnicode().equals(this.getUnicode());
    }

    public int hashCode() {
        return this.unicode.hashCode();
    }

    @NotNull
    public String toString() {
        return "Emoji{description='" + this.description + '\'' + ", supportsFitzpatrick=" + this.supportsFitzpatrick + ", aliases=" + this.aliases + ", tags=" + this.tags + ", category='" + this.category.getDisplayName() + '\'' + ", unicode='" + this.unicode + '\'' + ", htmlDec='" + this.htmlDec + '\'' + ", htmlHex='" + this.htmlHex + '\'' + '}';
    }
}

