/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.api.v2.services.discord;

public final class MessageType {
    private final String key;
    private final boolean player;

    public MessageType(String key) {
        this(key, false);
    }

    private MessageType(String key, boolean player) {
        if (!key.matches("^[a-z0-9-]*$")) {
            throw new IllegalArgumentException("Key must match \"^[a-z0-9-]*$\"");
        }
        this.key = key;
        this.player = player;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isPlayer() {
        return this.player;
    }

    public String toString() {
        return this.key;
    }

    public static final class DefaultTypes {
        public static final MessageType JOIN = new MessageType("join", true);
        public static final MessageType FIRST_JOIN = new MessageType("first-join", true);
        public static final MessageType LEAVE = new MessageType("leave", true);
        public static final MessageType CHAT = new MessageType("chat", true);
        public static final MessageType DEATH = new MessageType("death", true);
        public static final MessageType AFK = new MessageType("afk", true);
        public static final MessageType ADVANCEMENT = new MessageType("advancement", true);
        public static final MessageType ACTION = new MessageType("action", true);
        public static final MessageType SERVER_START = new MessageType("server-start", false);
        public static final MessageType SERVER_STOP = new MessageType("server-stop", false);
        public static final MessageType KICK = new MessageType("kick", false);
        public static final MessageType MUTE = new MessageType("mute", false);
        public static final MessageType LOCAL = new MessageType("local", true);
        public static final MessageType QUESTION = new MessageType("question", true);
        public static final MessageType SHOUT = new MessageType("shout", true);
        private static final MessageType[] VALUES = new MessageType[]{JOIN, FIRST_JOIN, LEAVE, CHAT, DEATH, AFK, ADVANCEMENT, ACTION, SERVER_START, SERVER_STOP, KICK, MUTE, LOCAL, QUESTION, SHOUT};

        public static MessageType[] values() {
            return VALUES;
        }
    }
}

