/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.floodgate.SpigotPlugin;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class SpigotVersionSpecificMethods {
    private static final Method GET_SPIGOT = ReflectionUtils.getMethod(Player.class, "spigot", new Class[0]);
    private static final Method OLD_GET_LOCALE = ReflectionUtils.getMethod(Player.Spigot.class, "getLocale", new Class[0]);
    private static final boolean NEW_VISIBILITY = null != ReflectionUtils.getMethod(Player.class, "hidePlayer", Plugin.class, Player.class);
    private static final Method NEW_PROPERTY_VALUE = ReflectionUtils.getMethod(Property.class, "value", new Class[0]);
    private static final Method NEW_PROPERTY_SIGNATURE = ReflectionUtils.getMethod(Property.class, "signature", new Class[0]);
    private final SpigotPlugin plugin;

    public SpigotVersionSpecificMethods(SpigotPlugin plugin) {
        this.plugin = plugin;
    }

    public String getLocale(Player player) {
        if (OLD_GET_LOCALE == null) {
            return player.getLocale();
        }
        Object spigot = ReflectionUtils.invoke(player, GET_SPIGOT, new Object[0]);
        return (String)ReflectionUtils.castedInvoke(spigot, OLD_GET_LOCALE, new Object[0]);
    }

    public void hideAndShowPlayer(Player on, Player target) {
        if (ClassNames.IS_FOLIA) {
            on.getScheduler().execute((Plugin)this.plugin, () -> this.hideAndShowPlayer0(on, target), null, 0L);
            return;
        }
        this.hideAndShowPlayer0(on, target);
    }

    public SkinApplyEvent.SkinData currentSkin(PropertyMap properties) {
        for (Property property : properties.get((Object)"textures")) {
            String signature;
            String value;
            if (NEW_PROPERTY_VALUE != null) {
                value = (String)ReflectionUtils.castedInvoke(property, NEW_PROPERTY_VALUE, new Object[0]);
                signature = (String)ReflectionUtils.castedInvoke(property, NEW_PROPERTY_SIGNATURE, new Object[0]);
            } else {
                value = property.getValue();
                signature = property.getSignature();
            }
            if (value.isEmpty()) continue;
            return new SkinDataImpl(value, signature);
        }
        return null;
    }

    public void schedule(Runnable runnable, long delay) {
        if (ClassNames.IS_FOLIA) {
            this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, $ -> runnable.run(), delay * 50L, TimeUnit.MILLISECONDS);
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, runnable, delay);
    }

    private void hideAndShowPlayer0(Player source, Player target) {
        if (NEW_VISIBILITY) {
            source.hidePlayer((Plugin)this.plugin, target);
            source.showPlayer((Plugin)this.plugin, target);
            return;
        }
        source.hidePlayer(target);
        source.showPlayer(target);
    }

    public void maybeSchedule(Runnable runnable) {
        if (ClassNames.IS_FOLIA) {
            runnable.run();
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, runnable);
    }
}

