/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.platform.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.platform.util.PlayerType;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.player.audience.ProfileAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.Utils;

public abstract class CommandUtil {
    protected final LanguageManager manager;
    protected final FloodgateApi api;

    public abstract @NonNull UserAudience getUserAudience(@NonNull Object var1);

    public @Nullable ProfileAudience getProfileAudience(@NonNull Object source, boolean allowOffline) {
        Objects.requireNonNull(source);
        if (source instanceof UUID) {
            return allowOffline ? new ProfileAudience((UUID)source, null) : null;
        }
        if (source instanceof String) {
            return allowOffline ? new ProfileAudience(null, (String)source) : null;
        }
        return new ProfileAudience(this.getUuidFromSource(source), this.getUsernameFromSource(source));
    }

    protected abstract String getUsernameFromSource(@NonNull Object var1);

    protected abstract UUID getUuidFromSource(@NonNull Object var1);

    protected abstract Collection<?> getOnlinePlayers();

    public @NonNull Collection<String> getOnlineUsernames(@NonNull PlayerType limitTo) {
        Collection<?> players = this.getOnlinePlayers();
        ArrayList<String> usernames = new ArrayList<String>();
        switch (limitTo) {
            case ALL_PLAYERS: {
                for (Object player : players) {
                    usernames.add(this.getUsernameFromSource(player));
                }
                break;
            }
            case ONLY_JAVA: {
                for (Object player : players) {
                    if (this.api.isFloodgatePlayer(this.getUuidFromSource(player))) continue;
                    usernames.add(this.getUsernameFromSource(player));
                }
                break;
            }
            case ONLY_BEDROCK: {
                for (Object player : players) {
                    if (!this.api.isFloodgatePlayer(this.getUuidFromSource(player))) continue;
                    usernames.add(this.getUsernameFromSource(player));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PlayerType");
            }
        }
        return usernames;
    }

    public abstract Object getPlayerByUuid(@NonNull UUID var1);

    public Object getPlayerByUuid(@NonNull UUID uuid, PlayerType limitTo) {
        return this.applyPlayerTypeFilter(this.getPlayerByUuid(uuid), limitTo, uuid);
    }

    public abstract Object getPlayerByUsername(@NonNull String var1);

    public Object getPlayerByUsername(@NonNull String username, PlayerType filter) {
        return this.applyPlayerTypeFilter(this.getPlayerByUsername(username), filter, username);
    }

    protected Object applyPlayerTypeFilter(Object player, PlayerType filter, Object fallback) {
        if (filter == PlayerType.ALL_PLAYERS || player instanceof String || player instanceof UUID) {
            return player;
        }
        return filter == PlayerType.ONLY_BEDROCK == this.api.isFloodgateId(this.getUuidFromSource(player)) ? player : fallback;
    }

    public abstract boolean hasPermission(Object var1, String var2);

    public Collection<Object> getOnlinePlayersWithPermission(String permission) {
        ArrayList<Object> players = new ArrayList<Object>();
        for (Object player : this.getOnlinePlayers()) {
            if (!this.hasPermission(player, permission)) continue;
            players.add(player);
        }
        return players;
    }

    public abstract void sendMessage(Object var1, String var2);

    public abstract void kickPlayer(Object var1, String var2);

    public String translateMessage(String locale, TranslatableMessage message, Object ... args) {
        return message.translateMessage(this.manager, locale, args);
    }

    public boolean whitelistPlayer(String xuid, String username) {
        UUID uuid = Utils.getJavaUuid(xuid);
        return this.whitelistPlayer(uuid, username);
    }

    public boolean whitelistPlayer(UUID uuid, String username) {
        return false;
    }

    public boolean removePlayerFromWhitelist(String xuid, String username) {
        UUID uuid = Utils.getJavaUuid(xuid);
        return this.removePlayerFromWhitelist(uuid, username);
    }

    public boolean removePlayerFromWhitelist(UUID uuid, String username) {
        return false;
    }

    protected CommandUtil(LanguageManager manager, FloodgateApi api) {
        this.manager = manager;
        this.api = api;
    }
}

