/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.chat.processing;

import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.essentialsx.api.v2.ChatType;
import org.bukkit.entity.Player;

public class ChatProcessingCache {
    private final Map<Player, ProcessedChat> chats = Collections.synchronizedMap(new HashMap());

    public ProcessedChat getProcessedChat(Player player) {
        return this.chats.get(player);
    }

    public void setProcessedChat(Player player, ProcessedChat chat) {
        this.chats.put(player, chat);
    }

    public void clearProcessedChat(Player player) {
        this.chats.remove(player);
    }

    public static class ProcessedChat
    extends Chat {
        private final Trade charge;

        public ProcessedChat(User user, ChatType type, String originalMessage) {
            super(user, type, originalMessage);
            this.charge = new Trade(this.getLongType(), user.getEssentials());
        }

        public void setRadius(long radius) {
            this.radius = radius;
        }

        public Trade getCharge() {
            return this.charge;
        }
    }

    public static abstract class Chat {
        private final User user;
        private final ChatType type;
        private final String originalMessage;
        protected long radius;

        protected Chat(User user, ChatType type, String originalMessage) {
            this.user = user;
            this.type = type;
            this.originalMessage = originalMessage;
        }

        public User getUser() {
            return this.user;
        }

        public ChatType getType() {
            return this.type;
        }

        public String getOriginalMessage() {
            return this.originalMessage;
        }

        public long getRadius() {
            return this.radius;
        }

        public final String getLongType() {
            return this.type == ChatType.UNKNOWN ? "chat" : "chat-" + this.type.key();
        }
    }
}

