/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.chat.processing;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.chat.EssentialsChat;
import com.earth2me.essentials.chat.processing.ChatProcessingCache;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import net.ess3.api.IUser;
import net.ess3.api.events.LocalChatSpyEvent;
import net.essentialsx.api.v2.ChatType;
import net.essentialsx.api.v2.events.chat.GlobalChatEvent;
import net.essentialsx.api.v2.events.chat.LocalChatEvent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.scoreboard.Team;

public abstract class AbstractChatHandler {
    protected final Essentials ess;
    protected final EssentialsChat essChat;
    protected final Server server;
    protected final ChatProcessingCache cache;

    protected AbstractChatHandler(Essentials ess, EssentialsChat essChat) {
        this.ess = ess;
        this.essChat = essChat;
        this.server = ess.getServer();
        this.cache = new ChatProcessingCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChatFormat(AsyncPlayerChatEvent event) {
        if (this.isAborted(event)) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (user == null) {
            event.setCancelled(true);
            return;
        }
        user.setDisplayNick();
        ChatProcessingCache.ProcessedChat chat = this.cache.getProcessedChat(event.getPlayer());
        if (chat == null) {
            chat = new ChatProcessingCache.ProcessedChat(user, this.getChatType(user, event.getMessage()), event.getMessage());
            this.cache.setProcessedChat(event.getPlayer(), chat);
        }
        long configRadius = this.ess.getSettings().getChatRadius();
        chat.setRadius(Math.max(configRadius, 0L));
        event.setMessage(FormatUtil.formatMessage((IUser)user, (String)"essentials.chat", (String)event.getMessage()));
        if (ChatColor.stripColor((String)event.getMessage()).length() == 0) {
            event.setCancelled(true);
            return;
        }
        String group = user.getGroup();
        String world = user.getWorld().getName();
        String username = user.getName();
        String nickname = user.getFormattedNickname();
        Player player = user.getBase();
        String prefix = FormatUtil.replaceFormat((String)this.ess.getPermissionsHandler().getPrefix(player));
        String suffix = FormatUtil.replaceFormat((String)this.ess.getPermissionsHandler().getSuffix(player));
        Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
        String format = this.ess.getSettings().getChatFormat(group);
        format = format.replace("{0}", group);
        format = format.replace("{1}", this.ess.getSettings().getWorldAlias(world));
        format = format.replace("{2}", world.substring(0, 1).toUpperCase(Locale.ENGLISH));
        format = format.replace("{3}", team == null ? "" : team.getPrefix());
        format = format.replace("{4}", team == null ? "" : team.getSuffix());
        format = format.replace("{5}", team == null ? "" : team.getDisplayName());
        format = format.replace("{6}", prefix);
        format = format.replace("{7}", suffix);
        format = format.replace("{8}", username);
        format = format.replace("{9}", nickname == null ? username : nickname);
        if (chat.getRadius() > 0L && event.getMessage().length() > 0) {
            if (event.getMessage().length() > 1 && (chat.getType() == ChatType.SHOUT && event.getMessage().charAt(0) == this.ess.getSettings().getChatShout() || chat.getType() == ChatType.QUESTION && event.getMessage().charAt(0) == this.ess.getSettings().getChatQuestion())) {
                event.setMessage(event.getMessage().substring(1));
            }
            format = chat.getType() == ChatType.UNKNOWN ? I18n.tl((String)"chatTypeLocal", (Object[])new Object[0]).concat(format) : I18n.tl((String)(chat.getType().key() + "Format"), (Object[])new Object[]{format});
        }
        String string = format;
        synchronized (string) {
            event.setFormat(format);
        }
    }

    protected void handleChatRecipients(AsyncPlayerChatEvent event) {
        if (this.isAborted(event)) {
            return;
        }
        ChatProcessingCache.ProcessedChat chat = this.cache.getProcessedChat(event.getPlayer());
        if (chat.getRadius() < 1L) {
            return;
        }
        long radiusSquared = chat.getRadius() * chat.getRadius();
        User user = chat.getUser();
        if (event.getMessage().length() > 0) {
            if (chat.getType() == ChatType.UNKNOWN) {
                if (!user.isAuthorized("essentials.chat.local")) {
                    user.sendMessage(I18n.tl((String)"notAllowedToLocal", (Object[])new Object[0]));
                    event.setCancelled(true);
                    return;
                }
                event.getRecipients().removeIf(player -> !this.ess.getUser(player).isAuthorized("essentials.chat.receive.local"));
            } else {
                String permission = "essentials.chat." + chat.getType().key();
                if (user.isAuthorized(permission)) {
                    event.getRecipients().removeIf(player -> !this.ess.getUser(player).isAuthorized("essentials.chat.receive." + chat.getType().key()));
                    this.callChatEvent(event, chat.getType(), null);
                } else {
                    String chatType = chat.getType().name();
                    user.sendMessage(I18n.tl((String)("notAllowedTo" + chatType.charAt(0) + chatType.substring(1).toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
                    event.setCancelled(true);
                }
                return;
            }
        }
        Location loc = user.getLocation();
        World world = loc.getWorld();
        Set outList = event.getRecipients();
        HashSet<Player> spyList = new HashSet<Player>();
        try {
            outList.add(event.getPlayer());
        }
        catch (UnsupportedOperationException ex) {
            if (this.ess.getSettings().isDebug()) {
                this.essChat.getLogger().log(Level.INFO, "Plugin triggered custom chat event, local chat handling aborted.", ex);
            }
            return;
        }
        Iterator it = outList.iterator();
        while (it.hasNext()) {
            Player onlinePlayer = (Player)it.next();
            User onlineUser = this.ess.getUser(onlinePlayer);
            if (onlineUser.equals((Object)user)) continue;
            boolean abort = false;
            Location playerLoc = onlineUser.getLocation();
            if (playerLoc.getWorld() != world) {
                abort = true;
            } else {
                double delta = playerLoc.distanceSquared(loc);
                if (delta > (double)radiusSquared) {
                    abort = true;
                }
            }
            if (!abort) continue;
            if (onlineUser.isAuthorized("essentials.chat.spy")) {
                spyList.add(onlinePlayer);
            }
            it.remove();
        }
        this.callChatEvent(event, ChatType.LOCAL, chat.getRadius());
        if (event.isCancelled()) {
            return;
        }
        if (outList.size() < 2) {
            user.sendMessage(I18n.tl((String)"localNoOne", (Object[])new Object[0]));
        }
        String localPrefix = I18n.tl((String)"chatTypeLocal", (Object[])new Object[0]);
        String baseFormat = event.getFormat();
        if (event.getFormat().startsWith(localPrefix)) {
            baseFormat = baseFormat.substring(localPrefix.length());
        }
        LocalChatSpyEvent spyEvent = new LocalChatSpyEvent(event.isAsynchronous(), event.getPlayer(), baseFormat, event.getMessage(), spyList);
        this.server.getPluginManager().callEvent((Event)spyEvent);
        if (!spyEvent.isCancelled()) {
            for (Player onlinePlayer : spyEvent.getRecipients()) {
                onlinePlayer.sendMessage(String.format(spyEvent.getFormat(), user.getDisplayName(), spyEvent.getMessage()));
            }
        }
    }

    protected void callChatEvent(AsyncPlayerChatEvent event, ChatType chatType, Long radius) {
        Object chatEvent = chatType == ChatType.LOCAL ? new LocalChatEvent(event.isAsynchronous(), event.getPlayer(), event.getFormat(), event.getMessage(), event.getRecipients(), radius.longValue()) : new GlobalChatEvent(event.isAsynchronous(), chatType, event.getPlayer(), event.getFormat(), event.getMessage(), event.getRecipients());
        this.server.getPluginManager().callEvent((Event)chatEvent);
        event.setFormat(chatEvent.getFormat());
        event.setMessage(chatEvent.getMessage());
        event.setCancelled(chatEvent.isCancelled());
    }

    protected void handleChatPostFormat(AsyncPlayerChatEvent event) {
        if (this.isAborted(event)) {
            this.cache.clearProcessedChat(event.getPlayer());
        }
    }

    protected void handleChatSubmit(AsyncPlayerChatEvent event) {
        if (this.isAborted(event)) {
            return;
        }
        this.charge(event, this.cache.getProcessedChat(event.getPlayer()));
        this.cache.clearProcessedChat(event.getPlayer());
    }

    boolean isAborted(AsyncPlayerChatEvent event) {
        return event.isCancelled();
    }

    ChatType getChatType(User user, String message) {
        boolean singleChar;
        if (message.length() == 0) {
            return ChatType.UNKNOWN;
        }
        char shoutPrefix = this.ess.getSettings().getChatShout();
        char questionPrefix = this.ess.getSettings().getChatQuestion();
        char prefix = message.charAt(0);
        boolean bl = singleChar = message.length() == 1;
        if (singleChar) {
            if (user.isToggleShout()) {
                return ChatType.SHOUT;
            }
            return ChatType.UNKNOWN;
        }
        if (prefix == questionPrefix && this.ess.getSettings().isChatQuestionEnabled()) {
            return ChatType.QUESTION;
        }
        if (prefix == shoutPrefix || user.isToggleShout()) {
            return ChatType.SHOUT;
        }
        return ChatType.UNKNOWN;
    }

    private void charge(User user, Trade charge) throws ChargeException {
        charge.charge((IUser)user);
    }

    boolean charge(AsyncPlayerChatEvent event, ChatProcessingCache.ProcessedChat chat) {
        try {
            this.charge(chat.getUser(), chat.getCharge());
        }
        catch (ChargeException e) {
            this.ess.showError(chat.getUser().getSource(), (Throwable)e, "\\ chat " + chat.getLongType());
            event.setCancelled(true);
            return false;
        }
        return true;
    }

    protected static interface ChatListener
    extends Listener {
        public void onPlayerChat(AsyncPlayerChatEvent var1);
    }
}

