/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.chat;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.EssentialsLogger;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.chat.processing.ChatHandler;
import com.earth2me.essentials.metrics.MetricsWrapper;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsChat
extends JavaPlugin {
    private transient IEssentials ess;
    private transient MetricsWrapper metrics = null;

    public void onEnable() {
        EssentialsLogger.updatePluginLogger((Plugin)this);
        PluginManager pluginManager = this.getServer().getPluginManager();
        this.ess = (IEssentials)pluginManager.getPlugin("Essentials");
        if (!this.getDescription().getVersion().equals(this.ess.getDescription().getVersion())) {
            this.getLogger().log(Level.WARNING, I18n.tl((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        if (!this.ess.isEnabled()) {
            this.setEnabled(false);
            return;
        }
        ChatHandler legacyHandler = new ChatHandler((Essentials)this.ess, this);
        legacyHandler.registerListeners();
        if (this.metrics == null) {
            this.metrics = new MetricsWrapper((JavaPlugin)this, 3814, false);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        this.metrics.markCommand(command.getName(), true);
        return this.ess.onCommandEssentials(sender, command, commandLabel, args, EssentialsChat.class.getClassLoader(), "com.earth2me.essentials.chat.Command", "essentials.", null);
    }
}

