/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TicksPerSecondCommand
extends Command {
    private boolean hasShownMemoryWarning;
    private static final Component WARN_MSG = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Warning: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"Memory usage on modern garbage collectors is not a stable value and it is perfectly normal to see it reach max. Please do not pay it much attention.", (TextColor)NamedTextColor.GOLD))).build();

    public TicksPerSecondCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("bukkit.command.tps");
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        double[] tps = Bukkit.getTPS();
        Component[] tpsAvg = new Component[tps.length];
        for (int i2 = 0; i2 < tps.length; ++i2) {
            tpsAvg[i2] = TicksPerSecondCommand.format(tps[i2]);
        }
        TextComponent.Builder builder = Component.text();
        builder.append((Component)Component.text((String)"TPS from last 1m, 5m, 15m: ", (TextColor)NamedTextColor.GOLD));
        builder.append(Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), (ComponentLike[])tpsAvg));
        sender.sendMessage(builder.asComponent());
        if (args.length > 0 && args[0].equals("mem") && sender.hasPermission("bukkit.command.tpsmemory")) {
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Current Memory Usage: ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "/" + Runtime.getRuntime().totalMemory() / 0x100000L + " mb (Max: " + Runtime.getRuntime().maxMemory() / 0x100000L + " mb)"), (TextColor)NamedTextColor.GREEN)));
            if (!this.hasShownMemoryWarning) {
                sender.sendMessage(WARN_MSG);
                this.hasShownMemoryWarning = true;
            }
        }
        return true;
    }

    private static Component format(double tps) {
        NamedTextColor color = tps > 18.0 ? NamedTextColor.GREEN : (tps > 16.0 ? NamedTextColor.YELLOW : NamedTextColor.RED);
        String amount = Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0) + (tps > 21.0 ? "*" : "");
        return Component.text((String)amount, (TextColor)color);
    }
}

