/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;

public final class CraftLocation {
    private CraftLocation() {
    }

    public static Location toBukkit(Vec3D vec3D) {
        return CraftLocation.toBukkit(vec3D, null);
    }

    public static Location toBukkit(Vec3D vec3D, World world) {
        return CraftLocation.toBukkit(vec3D, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3D vec3D, World world, float yaw, float pitch) {
        return new Location(world, vec3D.a(), vec3D.b(), vec3D.c(), yaw, pitch);
    }

    public static Location toBukkit(BlockPosition blockPosition) {
        return CraftLocation.toBukkit(blockPosition, (World)null);
    }

    public static Location toBukkit(BlockPosition blockPosition, net.minecraft.world.level.World world) {
        return CraftLocation.toBukkit(blockPosition, (World)world.getWorld(), 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPosition blockPosition, World world) {
        return CraftLocation.toBukkit(blockPosition, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPosition blockPosition, World world, float yaw, float pitch) {
        return new Location(world, (double)blockPosition.u(), (double)blockPosition.v(), (double)blockPosition.w(), yaw, pitch);
    }

    public static BlockPosition toBlockPosition(Location location) {
        return new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static GlobalPos toGlobalPos(Location location) {
        return GlobalPos.a(((CraftWorld)location.getWorld()).getHandle().ai(), CraftLocation.toBlockPosition(location));
    }

    public static Location fromGlobalPos(GlobalPos globalPos) {
        BlockPosition pos = globalPos.b();
        return new Location((World)MinecraftServer.getServer().a(globalPos.a()).getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
    }

    public static Vec3D toVec3D(Location location) {
        return new Vec3D(location.getX(), location.getY(), location.getZ());
    }
}

