/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.SystemUtils;
import org.bukkit.map.MapPalette;

public class CraftMapColorCache
implements MapPalette.MapColorCache {
    private static final String MD5_CACHE_HASH = "E88EDD068D12D39934B40E8B6B124C83";
    private static final File CACHE_FILE = new File("map-color-cache.dat");
    private byte[] cache;
    private final Logger logger;
    private boolean cached = false;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public CraftMapColorCache(Logger logger) {
        this.logger = logger;
    }

    public static void main(String[] args) {
        CraftMapColorCache craftMapColorCache = new CraftMapColorCache(Logger.getGlobal());
        craftMapColorCache.buildCache();
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(craftMapColorCache.cache);
            System.out.println("MD5_CACHE_HASH: " + CraftMapColorCache.bytesToString(hash));
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
    }

    public static String bytesToString(byte[] bytes) {
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder builder = new StringBuilder();
        for (byte value : bytes) {
            int first = (value & 0xF0) >> 4;
            int second = value & 0xF;
            builder.append(chars[first]);
            builder.append(chars[second]);
        }
        return builder.toString();
    }

    public CompletableFuture<Void> initCache() {
        byte[] fileContent;
        Preconditions.checkState((!this.cached && !this.running.getAndSet(true) ? 1 : 0) != 0, (Object)"Cache is already build or is currently being build");
        this.cache = new byte[0x1000000];
        if (CACHE_FILE.exists()) {
            byte[] hash;
            try (InflaterInputStream inputStream = new InflaterInputStream(new FileInputStream(CACHE_FILE));){
                fileContent = inputStream.readAllBytes();
            }
            catch (IOException e2) {
                this.logger.warning("Error while reading map color cache");
                e2.printStackTrace();
                return CompletableFuture.completedFuture(null);
            }
            try {
                hash = MessageDigest.getInstance("MD5").digest(fileContent);
            }
            catch (NoSuchAlgorithmException e3) {
                this.logger.warning("Error while hashing map color cache");
                e3.printStackTrace();
                return CompletableFuture.completedFuture(null);
            }
            if (!MD5_CACHE_HASH.equals(CraftMapColorCache.bytesToString(hash))) {
                this.logger.info("Map color cache hash invalid, rebuilding cache in the background");
                return this.buildAndSaveCache();
            }
        } else {
            this.logger.info("Map color cache not found, building it in the background");
            return this.buildAndSaveCache();
        }
        System.arraycopy(fileContent, 0, this.cache, 0, fileContent.length);
        this.cached = true;
        return CompletableFuture.completedFuture(null);
    }

    private void buildCache() {
        for (int r2 = 0; r2 < 256; ++r2) {
            for (int g2 = 0; g2 < 256; ++g2) {
                for (int b2 = 0; b2 < 256; ++b2) {
                    Color color = new Color(r2, g2, b2);
                    this.cache[this.toInt((Color)color)] = MapPalette.matchColor((Color)color);
                }
            }
        }
    }

    private CompletableFuture<Void> buildAndSaveCache() {
        return CompletableFuture.runAsync(() -> {
            this.buildCache();
            if (!CACHE_FILE.exists()) {
                try {
                    if (!CACHE_FILE.createNewFile()) {
                        this.cached = true;
                        return;
                    }
                }
                catch (IOException e2) {
                    this.logger.warning("Error while building map color cache");
                    e2.printStackTrace();
                    this.cached = true;
                    return;
                }
            }
            try (DeflaterOutputStream outputStream = new DeflaterOutputStream(new FileOutputStream(CACHE_FILE));){
                ((OutputStream)outputStream).write(this.cache);
            }
            catch (IOException e3) {
                this.logger.warning("Error while building map color cache");
                e3.printStackTrace();
                this.cached = true;
                return;
            }
            this.cached = true;
            this.logger.info("Map color cache build successfully");
        }, SystemUtils.h());
    }

    private int toInt(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }

    public boolean isCached() {
        return this.cached || !this.running.get() && this.initCache().isDone();
    }

    public byte matchColor(Color color) {
        Preconditions.checkState((boolean)this.isCached(), (Object)"Cache not build jet");
        return this.cache[this.toInt(color)];
    }
}

