/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.inventory.components;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.CraftSound;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R3.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R3.inventory.components.CraftHolderUtil;
import org.bukkit.craftbukkit.v1_21_R3.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.components.EquippableComponent;

@SerializableAs(value="Equippable")
public final class CraftEquippableComponent
implements EquippableComponent {
    private Equippable handle;

    public CraftEquippableComponent(Equippable handle) {
        this.handle = handle;
    }

    public CraftEquippableComponent(CraftEquippableComponent craft) {
        this.handle = craft.handle;
    }

    public CraftEquippableComponent(Map<String, Object> map) {
        EnumItemSlot slot = CraftEquipmentSlot.getNMS(EquipmentSlot.valueOf((String)SerializableMeta.getString(map, "slot", false)));
        Sound equipSound = null;
        String snd = SerializableMeta.getString(map, "equip-sound", true);
        if (snd != null) {
            equipSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)snd));
        }
        String model = SerializableMeta.getString(map, "model", true);
        String cameraOverlay = SerializableMeta.getString(map, "camera-overlay", true);
        HolderSet<EntityTypes<?>> allowedEntities = null;
        Object allowed = SerializableMeta.getObject(Object.class, map, "allowed-entities", true);
        if (allowed != null) {
            allowedEntities = CraftHolderUtil.parse(allowed, Registries.z, BuiltInRegistries.f);
        }
        Boolean dispensable = SerializableMeta.getObject(Boolean.class, map, "dispensable", true);
        Boolean swappable = SerializableMeta.getObject(Boolean.class, map, "swappable", true);
        Boolean damageOnHurt = SerializableMeta.getObject(Boolean.class, map, "damage-on-hurt", true);
        this.handle = new Equippable(slot, equipSound != null ? CraftSound.bukkitToMinecraftHolder(equipSound) : SoundEffects.as, Optional.ofNullable(model).map(MinecraftKey::a).map(k2 -> ResourceKey.a(EquipmentAssets.a, k2)), Optional.ofNullable(cameraOverlay).map(MinecraftKey::a), Optional.ofNullable(allowedEntities), dispensable != null ? dispensable : true, swappable != null ? swappable : true, damageOnHurt != null ? damageOnHurt : true);
    }

    public Map<String, Object> serialize() {
        Optional<HolderSet<EntityTypes<?>>> allowed;
        NamespacedKey cameraOverlay;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("slot", this.getSlot().name());
        result.put("equip-sound", this.getEquipSound().getKey().toString());
        NamespacedKey model = this.getModel();
        if (model != null) {
            result.put("model", model.toString());
        }
        if ((cameraOverlay = this.getCameraOverlay()) != null) {
            result.put("camera-overlay", cameraOverlay.toString());
        }
        if ((allowed = this.handle.e()).isPresent()) {
            CraftHolderUtil.serialize(result, "allowed-entities", allowed.get());
        }
        result.put("dispensable", this.isDispensable());
        result.put("swappable", this.isSwappable());
        result.put("damage-on-hurt", this.isDamageOnHurt());
        return result;
    }

    public Equippable getHandle() {
        return this.handle;
    }

    public EquipmentSlot getSlot() {
        return CraftEquipmentSlot.getSlot(this.handle.a());
    }

    public void setSlot(EquipmentSlot slot) {
        this.handle = new Equippable(CraftEquipmentSlot.getNMS(slot), this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public Sound getEquipSound() {
        return CraftSound.minecraftToBukkit(this.handle.b().a());
    }

    public void setEquipSound(Sound sound) {
        this.handle = new Equippable(this.handle.a(), sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : SoundEffects.as, this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public NamespacedKey getModel() {
        return this.handle.c().map(a2 -> CraftNamespacedKey.fromMinecraft(a2.a())).orElse(null);
    }

    public void setModel(NamespacedKey key) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft).map(k2 -> ResourceKey.a(EquipmentAssets.a, k2)), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public NamespacedKey getCameraOverlay() {
        return this.handle.d().map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setCameraOverlay(NamespacedKey key) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public Collection<EntityType> getAllowedEntities() {
        return this.handle.e().map(HolderSet::a).map(stream -> stream.map(Holder::a).map(CraftEntityType::minecraftToBukkit).collect(Collectors.toList())).orElse(null);
    }

    public void setAllowedEntities(EntityType entities) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), entities != null ? Optional.of(HolderSet.a(CraftEntityType.bukkitToMinecraftHolder(entities))) : Optional.empty(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public void setAllowedEntities(Collection<EntityType> entities) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), entities != null ? Optional.of(HolderSet.a(entities.stream().map(CraftEntityType::bukkitToMinecraftHolder).collect(Collectors.toList()))) : Optional.empty(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public void setAllowedEntities(Tag<EntityType> tag) {
        Preconditions.checkArgument((tag == null || tag instanceof CraftEntityTag ? 1 : 0) != 0, (Object)"tag must be an entity tag");
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), tag != null ? Optional.of(((CraftEntityTag)tag).getHandle()) : Optional.empty(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public boolean isDispensable() {
        return this.handle.f();
    }

    public void setDispensable(boolean dispensable) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), dispensable, this.handle.g(), this.handle.h());
    }

    public boolean isSwappable() {
        return this.handle.g();
    }

    public void setSwappable(boolean swappable) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), swappable, this.handle.h());
    }

    public boolean isDamageOnHurt() {
        return this.handle.h();
    }

    public void setDamageOnHurt(boolean damage) {
        this.handle = new Equippable(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), damage);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEquippableComponent other = (CraftEquippableComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftEquippableComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

