/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R3.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionEffectType;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaSuspiciousStew
extends CraftMetaItem
implements SuspiciousStewMeta {
    static final CraftMetaItem.ItemMetaKeyType<SuspiciousStewEffects> EFFECTS = new CraftMetaItem.ItemMetaKeyType<SuspiciousStewEffects>(DataComponents.R, "effects");
    private List<SuspiciousEffectEntry> customEffects;

    CraftMetaSuspiciousStew(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSuspiciousStew)) {
            return;
        }
        CraftMetaSuspiciousStew stewMeta = (CraftMetaSuspiciousStew)meta;
        if (stewMeta.hasCustomEffects()) {
            this.customEffects = new ArrayList<SuspiciousEffectEntry>(stewMeta.customEffects);
        }
    }

    CraftMetaSuspiciousStew(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaSuspiciousStew.getOrEmpty(tag, EFFECTS).ifPresent(suspiciousStewEffects -> {
            List<SuspiciousStewEffects.a> list = suspiciousStewEffects.a();
            int length = list.size();
            this.customEffects = new ArrayList<SuspiciousEffectEntry>(length);
            for (int i2 = 0; i2 < length; ++i2) {
                SuspiciousStewEffects.a effect = list.get(i2);
                PotionEffectType type = CraftPotionEffectType.minecraftHolderToBukkit(effect.b());
                if (type == null) continue;
                int duration = effect.c();
                this.customEffects.add(SuspiciousEffectEntry.create((PotionEffectType)type, (int)duration));
            }
        });
    }

    CraftMetaSuspiciousStew(Map<String, Object> map) {
        super(map);
        Iterable rawEffectList = SerializableMeta.getObject(Iterable.class, map, CraftMetaSuspiciousStew.EFFECTS.BUKKIT, true);
        if (rawEffectList == null) {
            return;
        }
        for (Object obj : rawEffectList) {
            Preconditions.checkArgument((boolean)(obj instanceof PotionEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
            this.addCustomEffect((PotionEffect)obj, true);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.customEffects != null) {
            ArrayList<SuspiciousStewEffects.a> effectList = new ArrayList<SuspiciousStewEffects.a>();
            for (SuspiciousEffectEntry effect : this.customEffects) {
                effectList.add(new SuspiciousStewEffects.a(CraftPotionEffectType.bukkitToMinecraftHolder(effect.effect()), effect.duration()));
            }
            tag.put(EFFECTS, new SuspiciousStewEffects(effectList));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isStewEmpty();
    }

    boolean isStewEmpty() {
        return !this.hasCustomEffects();
    }

    @Override
    public CraftMetaSuspiciousStew clone() {
        CraftMetaSuspiciousStew clone = (CraftMetaSuspiciousStew)super.clone();
        if (this.customEffects != null) {
            clone.customEffects = new ArrayList<SuspiciousEffectEntry>(this.customEffects);
        }
        return clone;
    }

    public boolean hasCustomEffects() {
        return this.customEffects != null;
    }

    public List<PotionEffect> getCustomEffects() {
        if (this.hasCustomEffects()) {
            return this.customEffects.stream().map(suspiciousEffectEntry -> suspiciousEffectEntry.effect().createEffect(suspiciousEffectEntry.duration(), 0)).toList();
        }
        return ImmutableList.of();
    }

    public boolean addCustomEffect(PotionEffect effect, boolean overwrite) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Potion effect cannot be null");
        return this.addCustomEffect(SuspiciousEffectEntry.create((PotionEffectType)effect.getType(), (int)effect.getDuration()), overwrite);
    }

    public boolean addCustomEffect(SuspiciousEffectEntry suspiciousEffectEntry, boolean overwrite) {
        List<SuspiciousEffectEntry> matchingEffects;
        Preconditions.checkArgument((suspiciousEffectEntry != null ? 1 : 0) != 0, (Object)"Suspicious effect entry cannot be null");
        if (this.hasCustomEffects() && !(matchingEffects = this.customEffects.stream().filter(entry -> entry.effect() == suspiciousEffectEntry.effect()).toList()).isEmpty()) {
            if (overwrite) {
                boolean foundMatchingDuration = false;
                boolean mutated = false;
                for (SuspiciousEffectEntry matchingEffect : matchingEffects) {
                    if (matchingEffect.duration() != suspiciousEffectEntry.duration()) {
                        this.customEffects.remove(suspiciousEffectEntry);
                        mutated = true;
                        continue;
                    }
                    foundMatchingDuration = true;
                }
                if (foundMatchingDuration && !mutated) {
                    return false;
                }
                if (!foundMatchingDuration) {
                    this.customEffects.add(suspiciousEffectEntry);
                }
                return true;
            }
            return false;
        }
        if (this.customEffects == null) {
            this.customEffects = new ArrayList<SuspiciousEffectEntry>();
        }
        this.customEffects.add(suspiciousEffectEntry);
        return true;
    }

    public boolean removeCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        if (!this.hasCustomEffects()) {
            return false;
        }
        boolean changed = false;
        Iterator<SuspiciousEffectEntry> iterator = this.customEffects.iterator();
        while (iterator.hasNext()) {
            SuspiciousEffectEntry effect = iterator.next();
            if (!type.equals(effect.effect())) continue;
            iterator.remove();
            changed = true;
        }
        if (this.customEffects.isEmpty()) {
            this.customEffects = null;
        }
        return changed;
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        return this.indexOfEffect(type) != -1;
    }

    private int indexOfEffect(PotionEffectType type) {
        if (!this.hasCustomEffects()) {
            return -1;
        }
        for (int i2 = 0; i2 < this.customEffects.size(); ++i2) {
            if (!this.customEffects.get(i2).effect().equals(type)) continue;
            return i2;
        }
        return -1;
    }

    public boolean clearCustomEffects() {
        boolean changed = this.hasCustomEffects();
        this.customEffects = null;
        return changed;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasCustomEffects()) {
            hash = 73 * hash + this.customEffects.hashCode();
        }
        return original != hash ? CraftMetaSuspiciousStew.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSuspiciousStew) {
            CraftMetaSuspiciousStew that = (CraftMetaSuspiciousStew)meta;
            return this.hasCustomEffects() ? that.hasCustomEffects() && this.customEffects.equals(that.customEffects) : !that.hasCustomEffects();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSuspiciousStew || this.isStewEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasCustomEffects()) {
            builder.put((Object)CraftMetaSuspiciousStew.EFFECTS.BUKKIT, (Object)ImmutableList.copyOf((Collection)Lists.transform(this.customEffects, s2 -> new PotionEffect(s2.effect(), s2.duration(), 0))));
        }
        return builder;
    }
}

