/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R3.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R3.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R3.inventory.trim.CraftTrimPattern;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaArmor
extends CraftMetaItem
implements ArmorMeta {
    static final CraftMetaItem.ItemMetaKeyType<net.minecraft.world.item.equipment.trim.ArmorTrim> TRIM = new CraftMetaItem.ItemMetaKeyType<net.minecraft.world.item.equipment.trim.ArmorTrim>(DataComponents.U, "trim");
    static final CraftMetaItem.ItemMetaKey TRIM_MATERIAL = new CraftMetaItem.ItemMetaKey("material");
    static final CraftMetaItem.ItemMetaKey TRIM_PATTERN = new CraftMetaItem.ItemMetaKey("pattern");
    private ArmorTrim trim;

    CraftMetaArmor(CraftMetaItem meta) {
        super(meta);
        if (meta instanceof CraftMetaArmor) {
            CraftMetaArmor armorMeta = (CraftMetaArmor)meta;
            this.trim = armorMeta.trim;
        }
    }

    CraftMetaArmor(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaArmor.getOrEmpty(tag, TRIM).ifPresent(trimCompound -> {
            TrimMaterial trimMaterial = CraftTrimMaterial.minecraftHolderToBukkit(trimCompound.a());
            TrimPattern trimPattern = CraftTrimPattern.minecraftHolderToBukkit(trimCompound.b());
            this.trim = new ArmorTrim(trimMaterial, trimPattern);
            if (!trimCompound.c()) {
                this.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
            }
        });
    }

    CraftMetaArmor(Map<String, Object> map) {
        super(map);
        Map trimData = SerializableMeta.getObject(Map.class, map, CraftMetaArmor.TRIM.BUKKIT, true);
        if (trimData != null) {
            Object materialKeyString = SerializableMeta.getObject(Object.class, trimData, CraftMetaArmor.TRIM_MATERIAL.BUKKIT, true);
            Object patternKeyString = SerializableMeta.getObject(Object.class, trimData, CraftMetaArmor.TRIM_PATTERN.BUKKIT, true);
            if (materialKeyString != null && patternKeyString != null) {
                TrimMaterial trimMaterial = CraftTrimMaterial.objectToBukkit(materialKeyString);
                TrimPattern trimPattern = CraftTrimPattern.objectToBukkit(patternKeyString);
                if (trimMaterial != null && trimPattern != null) {
                    this.trim = new ArmorTrim(trimMaterial, trimPattern);
                }
            }
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemTag) {
        super.applyToItem(itemTag);
        if (this.hasTrim()) {
            itemTag.put(TRIM, new net.minecraft.world.item.equipment.trim.ArmorTrim(CraftTrimMaterial.bukkitToMinecraftHolder(this.trim.getMaterial()), CraftTrimPattern.bukkitToMinecraftHolder(this.trim.getPattern()), !this.hasItemFlag(ItemFlag.HIDE_ARMOR_TRIM)));
        }
    }

    @Override
    boolean equalsCommon(CraftMetaItem that) {
        if (!super.equalsCommon(that)) {
            return false;
        }
        if (that instanceof CraftMetaArmor) {
            CraftMetaArmor armorMeta = (CraftMetaArmor)that;
            return Objects.equals(this.trim, armorMeta.trim);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaArmor || this.isArmorEmpty());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isArmorEmpty();
    }

    private boolean isArmorEmpty() {
        return !this.hasTrim();
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasTrim()) {
            hash = 61 * hash + this.trim.hashCode();
        }
        return original != hash ? CraftMetaArmor.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaArmor clone() {
        CraftMetaArmor meta = (CraftMetaArmor)super.clone();
        meta.trim = this.trim;
        return meta;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasTrim()) {
            HashMap<String, Object> trimData = new HashMap<String, Object>();
            trimData.put(CraftMetaArmor.TRIM_MATERIAL.BUKKIT, CraftTrimMaterial.bukkitToObject(this.trim.getMaterial()));
            trimData.put(CraftMetaArmor.TRIM_PATTERN.BUKKIT, CraftTrimPattern.bukkitToObject(this.trim.getPattern()));
            builder.put((Object)CraftMetaArmor.TRIM.BUKKIT, trimData);
        }
        return builder;
    }

    public boolean hasTrim() {
        return this.trim != null;
    }

    public void setTrim(ArmorTrim trim) {
        this.trim = trim;
    }

    public ArmorTrim getTrim() {
        return this.trim;
    }
}

