/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class CraftMerchantRecipe
extends org.bukkit.inventory.MerchantRecipe {
    private final MerchantRecipe handle;

    public CraftMerchantRecipe(MerchantRecipe merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.e), 0);
        this.handle = merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.c.d()));
        merchantRecipe.d.ifPresent(costB -> this.addIngredient(CraftItemStack.asBukkitCopy(costB.d())));
    }

    @Deprecated
    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0, false);
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, boolean ignoreDiscounts) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0, ignoreDiscounts);
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, int demand, int specialPrice) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, demand, specialPrice, false);
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, int demand, int specialPrice, boolean ignoreDiscounts) {
        super(result, uses, maxUses, experienceReward, experience, priceMultiplier, demand, specialPrice, ignoreDiscounts);
        this.handle = new MerchantRecipe(new ItemCost(Items.a), Optional.empty(), CraftItemStack.asNMSCopy(result), uses, maxUses, experience, priceMultiplier, demand, ignoreDiscounts, this);
        this.setSpecialPrice(specialPrice);
        this.setExperienceReward(experienceReward);
    }

    public int getSpecialPrice() {
        return this.handle.o();
    }

    public void setSpecialPrice(int specialPrice) {
        this.handle.i = specialPrice;
    }

    public int getDemand() {
        return this.handle.j;
    }

    public void setDemand(int demand) {
        this.handle.j = demand;
    }

    public int getUses() {
        return this.handle.f;
    }

    public void setUses(int uses) {
        this.handle.f = uses;
    }

    public int getMaxUses() {
        return this.handle.g;
    }

    public void setMaxUses(int maxUses) {
        this.handle.g = maxUses;
    }

    public boolean hasExperienceReward() {
        return this.handle.h;
    }

    public void setExperienceReward(boolean flag) {
        this.handle.h = flag;
    }

    public int getVillagerExperience() {
        return this.handle.l;
    }

    public void setVillagerExperience(int villagerExperience) {
        this.handle.l = villagerExperience;
    }

    public float getPriceMultiplier() {
        return this.handle.k;
    }

    public void setPriceMultiplier(float priceMultiplier) {
        this.handle.k = priceMultiplier;
    }

    public boolean shouldIgnoreDiscounts() {
        return this.handle.ignoreDiscounts;
    }

    public void setIgnoreDiscounts(boolean ignoreDiscounts) {
        this.handle.ignoreDiscounts = ignoreDiscounts;
    }

    public MerchantRecipe toMinecraft() {
        List ingredients = this.getIngredients();
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"No offered ingredients");
        net.minecraft.world.item.ItemStack baseCostA = CraftItemStack.asNMSCopy((ItemStack)ingredients.get(0));
        DataComponentPredicate baseCostAPredicate = DataComponentPredicate.a(PatchedDataComponentMap.a(DataComponentMap.a, baseCostA.d()));
        this.handle.c = new ItemCost(baseCostA.i(), baseCostA.M(), baseCostAPredicate, baseCostA);
        if (ingredients.size() > 1) {
            net.minecraft.world.item.ItemStack costB = CraftItemStack.asNMSCopy((ItemStack)ingredients.get(1));
            DataComponentPredicate costBPredicate = DataComponentPredicate.a(PatchedDataComponentMap.a(DataComponentMap.a, costB.d()));
            this.handle.d = Optional.of(new ItemCost(costB.i(), costB.M(), costBPredicate, costB));
        } else {
            this.handle.d = Optional.empty();
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(org.bukkit.inventory.MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier(), recipe.getDemand(), recipe.getSpecialPrice(), recipe.shouldIgnoreDiscounts());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

