/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.inventory;

import com.google.common.base.Suppliers;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.inventory.Containers;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.v1_21_R3.util.Handleable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;

public class CraftMenuType<V extends InventoryView, B extends InventoryViewBuilder<V>>
implements MenuType.Typed<V, B>,
Handleable<Containers<?>>,
PaperFeatureDependent {
    private final NamespacedKey key;
    private final Containers<?> handle;
    private final Supplier<CraftMenus.MenuTypeData<V, B>> typeData;

    public CraftMenuType(NamespacedKey key, Containers<?> handle) {
        this.key = key;
        this.handle = handle;
        this.typeData = Suppliers.memoize(() -> CraftMenus.getMenuTypeData(this));
    }

    @Override
    public Containers<?> getHandle() {
        return this.handle;
    }

    public V create(HumanEntity player, String title) {
        return (V)this.builder().title(title != null ? LegacyComponentSerializer.legacySection().deserialize(title) : null).build(player);
    }

    public V create(HumanEntity player, Component title) {
        return (V)this.builder().title(title).build(player);
    }

    public B builder() {
        return (B)((InventoryViewBuilder)this.typeData.get().viewBuilder().get());
    }

    public MenuType.Typed<InventoryView, InventoryViewBuilder<InventoryView>> typed() {
        return this.typed(InventoryView.class);
    }

    public <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuType.Typed<V, B> typed(Class<V> clazz) {
        if (clazz.isAssignableFrom(this.typeData.get().viewClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type InventoryView " + this.key.toString() + " to InventoryView type " + clazz.getSimpleName());
    }

    public Class<? extends InventoryView> getInventoryViewClass() {
        return this.typeData.get().viewClass();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public static Containers<?> bukkitToMinecraft(MenuType bukkit) {
        return (Containers)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static MenuType minecraftToBukkit(Containers<?> minecraft) {
        return (MenuType)CraftRegistry.minecraftToBukkit(minecraft, Registries.V);
    }

    public static MenuType minecraftHolderToBukkit(Holder<Containers<?>> minecraft) {
        return CraftMenuType.minecraftToBukkit(minecraft.a());
    }
}

