/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.event;

import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.entity.EntityZapEvent;
import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import com.destroystokyo.paper.event.entity.WitchReadyPotionEvent;
import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.block.BellRingEvent;
import io.papermc.paper.event.block.BlockFailedDispenseEvent;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import io.papermc.paper.util.TransformingRandomAccessList;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Raid;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.CraftExplosionResult;
import org.bukkit.craftbukkit.v1_21_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R3.CraftRaid;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftSound;
import org.bukkit.craftbukkit.v1_21_R3.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Witch;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BellResonateEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.BatToggleSleepEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.entity.StriderTemperatureChangeEvent;
import org.bukkit.event.entity.TrialSpawnerSpawnEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerBucketFishEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRecipeBookSettingsChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class CraftEventFactory {
    public static BlockPosition sourceBlockOverride = null;
    private static final Function<org.bukkit.inventory.ItemStack, Entity.DefaultDrop> FROM_FUNCTION = stack -> {
        if (stack == null) {
            return null;
        }
        return new Entity.DefaultDrop(CraftItemType.bukkitToMinecraft(stack.getType()), (org.bukkit.inventory.ItemStack)stack, null);
    };
    private static final com.google.common.base.Function<? super Double, Double> ZERO = Functions.constant((Object)-0.0);

    private static boolean canBuild(WorldServer world, Player player, int x2, int z2) {
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.ai() != net.minecraft.world.level.World.i) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().k().c()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        BlockPosition chunkcoordinates = world.Z();
        int distanceFromSpawn = Math.max(Math.abs(x2 - chunkcoordinates.u()), Math.abs(z2 - chunkcoordinates.w()));
        return distanceFromSpawn > spawnSize;
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callPlayerSignOpenEvent(EntityHuman player, TileEntitySign tileEntitySign, boolean front, PlayerSignOpenEvent.Cause cause) {
        CraftBlock block = CraftBlock.at(tileEntitySign.i(), tileEntitySign.aA_());
        Sign sign = (Sign)CraftBlockStates.getBlockState(block);
        Side side = front ? Side.FRONT : Side.BACK;
        return CraftEventFactory.callPlayerSignOpenEvent((Player)player.getBukkitEntity(), sign, side, cause);
    }

    public static boolean callPlayerSignOpenEvent(Player player, Sign sign, Side side, PlayerSignOpenEvent.Cause cause) {
        PlayerSignOpenEvent event = new PlayerSignOpenEvent(player, sign, side, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Either<EntityHuman.EnumBedResult, Unit> callPlayerBedEnterEvent(EntityHuman player, BlockPosition bed, Either<EntityHuman.EnumBedResult, Unit> nmsBedResult) {
        PlayerBedEnterEvent.BedEnterResult bedEnterResult = (PlayerBedEnterEvent.BedEnterResult)nmsBedResult.mapBoth(new com.google.common.base.Function<EntityHuman.EnumBedResult, PlayerBedEnterEvent.BedEnterResult>(){

            public PlayerBedEnterEvent.BedEnterResult apply(EntityHuman.EnumBedResult t2) {
                switch (t2) {
                    case a: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE;
                    }
                    case b: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW;
                    }
                    case c: {
                        return PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY;
                    }
                    case f: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_SAFE;
                    }
                    case d: {
                        return PlayerBedEnterEvent.BedEnterResult.OBSTRUCTED;
                    }
                }
                return PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
            }
        }, t2 -> PlayerBedEnterEvent.BedEnterResult.OK).map(Function.identity(), Function.identity());
        PlayerBedEnterEvent event = new PlayerBedEnterEvent((Player)player.getBukkitEntity(), (Block)CraftBlock.at(player.dV(), bed), bedEnterResult);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        Event.Result result = event.useBed();
        if (result == Event.Result.ALLOW) {
            return Either.right(Unit.a);
        }
        if (result == Event.Result.DENY) {
            return Either.left(EntityHuman.EnumBedResult.e);
        }
        return nmsBedResult;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(EntityHuman entityHuman, EntityAnimal entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)entityAnimal.getBukkitEntity(), (HumanEntity)(entityHuman != null ? entityHuman.getBukkitEntity() : null), loveTicks);
        Bukkit.getPluginManager().callEvent((Event)entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static PlayerHarvestBlockEvent callPlayerHarvestBlockEvent(net.minecraft.world.level.World world, BlockPosition blockposition, EntityHuman who, EnumHand enumhand, List<ItemStack> itemsToHarvest) {
        ArrayList bukkitItemsToHarvest = new ArrayList(itemsToHarvest.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Player player = (Player)who.getBukkitEntity();
        PlayerHarvestBlockEvent playerHarvestBlockEvent = new PlayerHarvestBlockEvent(player, (Block)CraftBlock.at(world, blockposition), CraftEquipmentSlot.getHand(enumhand), bukkitItemsToHarvest);
        Bukkit.getPluginManager().callEvent((Event)playerHarvestBlockEvent);
        return playerHarvestBlockEvent;
    }

    public static PlayerBucketEntityEvent callPlayerFishBucketEvent(EntityLiving fish, EntityHuman entityHuman, ItemStack originalBucket, ItemStack entityBucket, EnumHand enumhand) {
        Player player = (Player)entityHuman.getBukkitEntity();
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        Object event = fish instanceof EntityFish ? new PlayerBucketFishEvent(player, (Fish)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), hand) : new PlayerBucketEntityEvent(player, (Entity)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), hand);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TradeSelectEvent callTradeSelectEvent(EntityPlayer player, int newIndex, ContainerMerchant merchant) {
        TradeSelectEvent tradeSelectEvent = new TradeSelectEvent((MerchantView)merchant.getBukkitView(), newIndex);
        Bukkit.getPluginManager().callEvent((Event)tradeSelectEvent);
        return tradeSelectEvent;
    }

    public static boolean handleBellRingEvent(net.minecraft.world.level.World world, BlockPosition position, EnumDirection direction, net.minecraft.world.entity.Entity entity) {
        CraftBlock block = CraftBlock.at(world, position);
        BlockFace bukkitDirection = CraftBlock.notchToBlockFace(direction);
        BellRingEvent event = new BellRingEvent((Block)block, bukkitDirection, (Entity)(entity != null ? entity.getBukkitEntity() : null));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Stream<EntityLiving> handleBellResonateEvent(net.minecraft.world.level.World world, BlockPosition position, List<LivingEntity> bukkitEntities) {
        CraftBlock block = CraftBlock.at(world, position);
        BellResonateEvent event = new BellResonateEvent((Block)block, bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getResonatedEntities().stream().map(bukkitEntity -> ((CraftLivingEntity)bukkitEntity).getHandle());
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(WorldServer world, EntityHuman who, EnumHand hand, List<BlockState> blockStates, int clickedX, int clickedY, int clickedZ) {
        EquipmentSlot equipmentSlot;
        org.bukkit.inventory.ItemStack item;
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getCraftServer();
        Player player = (Player)who.getBukkitEntity();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        boolean canBuild = true;
        for (int i2 = 0; i2 < blockStates.size(); ++i2) {
            if (CraftEventFactory.canBuild(world, player, blockStates.get(i2).getX(), blockStates.get(i2).getZ())) continue;
            canBuild = false;
            break;
        }
        if (hand == EnumHand.a) {
            item = player.getInventory().getItemInMainHand();
            equipmentSlot = EquipmentSlot.HAND;
        } else {
            item = player.getInventory().getItemInOffHand();
            equipmentSlot = EquipmentSlot.OFF_HAND;
        }
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, blockClicked, item, player, canBuild, equipmentSlot);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(WorldServer world, EntityHuman who, EnumHand hand, BlockState replacedBlockState, int clickedX, int clickedY, int clickedZ) {
        EquipmentSlot equipmentSlot;
        org.bukkit.inventory.ItemStack item;
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getCraftServer();
        Player player = (Player)who.getBukkitEntity();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(world, player, placedBlock.getX(), placedBlock.getZ());
        if (hand == EnumHand.a) {
            item = player.getInventory().getItemInMainHand();
            equipmentSlot = EquipmentSlot.HAND;
        } else {
            item = player.getInventory().getItemInOffHand();
            equipmentSlot = EquipmentSlot.OFF_HAND;
        }
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, item, player, canBuild, equipmentSlot);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleBlockDropItemEvent(Block block, BlockState state, EntityPlayer player, List<EntityItem> items) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (EntityItem item : items) {
            list.add((Item)item.getBukkitEntity());
        }
        BlockDropItemEvent event = new BlockDropItemEvent(block, state, (Player)player.getBukkitEntity(), list);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            for (Item bukkit : list) {
                if (bukkit.isValid()) continue;
                EntityItem item = ((CraftItem)bukkit).getHandle();
                item.dV().b(item);
            }
        } else {
            for (Item bukkit : list) {
                if (!bukkit.isValid()) continue;
                bukkit.remove();
            }
        }
    }

    public static EntityPlaceEvent callEntityPlaceEvent(ItemActionContext itemactioncontext, net.minecraft.world.entity.Entity entity) {
        return CraftEventFactory.callEntityPlaceEvent(itemactioncontext.q(), itemactioncontext.a(), itemactioncontext.k(), itemactioncontext.o(), entity, itemactioncontext.p());
    }

    public static EntityPlaceEvent callEntityPlaceEvent(net.minecraft.world.level.World world, BlockPosition clickPosition, EnumDirection clickedFace, EntityHuman human, net.minecraft.world.entity.Entity entity, EnumHand enumhand) {
        Player who = human == null ? null : (Player)human.getBukkitEntity();
        CraftBlock blockClicked = CraftBlock.at(world, clickPosition);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent((Entity)entity.getBukkitEntity(), who, (Block)blockClicked, blockFace, CraftEquipmentSlot.getHand(enumhand));
        entity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(WorldServer world, EntityHuman who, BlockPosition changed, BlockPosition clicked, EnumDirection clickedFace, ItemStack itemInHand, EnumHand enumhand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, who, changed, clicked, clickedFace, itemInHand, Items.rf, enumhand);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(WorldServer world, EntityHuman who, BlockPosition changed, BlockPosition clicked, EnumDirection clickedFace, ItemStack itemInHand, net.minecraft.world.item.Item bucket, EnumHand enumhand) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, who, clicked, changed, clickedFace, itemInHand, bucket, enumhand);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, WorldServer world, EntityHuman who, BlockPosition changed, BlockPosition clicked, EnumDirection clickedFace, ItemStack itemstack, net.minecraft.world.item.Item item, EnumHand enumhand) {
        PlayerBucketFillEvent event;
        Player player = (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = CraftItemType.minecraftToBukkit(itemstack.h());
        CraftServer craftServer = (CraftServer)player.getServer();
        CraftBlock block = CraftBlock.at(world, changed);
        CraftBlock blockClicked = CraftBlock.at(world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, (Block)block, (Block)blockClicked, blockFace, bucket, (org.bukkit.inventory.ItemStack)itemInHand, hand);
            event.setCancelled(!CraftEventFactory.canBuild(world, player, changed.u(), changed.w()));
        } else {
            event = new PlayerBucketEmptyEvent(player, (Block)block, (Block)blockClicked, blockFace, bucket, (org.bukkit.inventory.ItemStack)itemInHand, hand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(world, player, changed.u(), changed.w()));
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman who, Action action, ItemStack itemstack, EnumHand hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", who, action, itemstack));
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, null, EnumDirection.d, itemstack, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman who, Action action, BlockPosition position, EnumDirection direction, ItemStack itemstack, EnumHand hand) {
        return CraftEventFactory.callPlayerInteractEvent(who, action, position, direction, itemstack, false, hand, null);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman who, Action action, BlockPosition position, EnumDirection direction, ItemStack itemstack, boolean cancelledBlock, EnumHand hand, Vec3D targetPos) {
        return CraftEventFactory.callPlayerInteractEvent(who, action, position, direction, itemstack, cancelledBlock, false, hand, targetPos);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman who, Action action, BlockPosition position, EnumDirection direction, ItemStack itemstack, boolean cancelledBlock, boolean cancelledItem, EnumHand hand, Vec3D targetPos) {
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        Vector clickedPos = null;
        if (position != null && targetPos != null) {
            clickedPos = CraftVector.toBukkit(targetPos.d(Vec3D.a(position)));
        }
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = null;
        if (position != null) {
            blockClicked = craftWorld.getBlockAt(position.u(), position.v(), position.w());
        } else {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        BlockFace blockFace = CraftBlock.notchToBlockFace(direction);
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, (org.bukkit.inventory.ItemStack)itemInHand, blockClicked, blockFace, hand == null ? null : (hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND), clickedPos);
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        if (cancelledItem) {
            event.setUseItemInHand(Event.Result.DENY);
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTransformEvent callEntityTransformEvent(EntityLiving original, EntityLiving coverted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(coverted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(EntityLiving original, List<EntityLiving> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (EntityLiving entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        EntityTransformEvent event = new EntityTransformEvent((Entity)original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(EntityLiving who, ItemStack bow, ItemStack consumableItem, net.minecraft.world.entity.Entity entityArrow, EnumHand hand, float force, boolean consumeItem) {
        EquipmentSlot handSlot;
        LivingEntity shooter = (LivingEntity)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        EquipmentSlot equipmentSlot = handSlot = hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        if (itemInHand != null && (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0)) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, (org.bukkit.inventory.ItemStack)itemInHand, (org.bukkit.inventory.ItemStack)itemConsumable, (Entity)arrow, handSlot, force, consumeItem);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(EntityVillager vilager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((Villager)vilager.getBukkitEntity(), future, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(EntityPlayer who, BlockPosition pos, EnumDirection direction, ItemStack itemstack, boolean instaBreak) {
        CraftPlayer player = who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftBlock blockClicked = CraftBlock.at(who.dV(), pos);
        BlockDamageEvent event = new BlockDamageEvent((Player)player, (Block)blockClicked, CraftBlock.notchToBlockFace(direction), (org.bukkit.inventory.ItemStack)itemInHand, instaBreak);
        player.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageAbortEvent callBlockDamageAbortEvent(EntityPlayer who, BlockPosition pos, ItemStack itemstack) {
        CraftPlayer player = who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftBlock blockClicked = CraftBlock.at(who.dV(), pos);
        BlockDamageAbortEvent event = new BlockDamageAbortEvent((Player)player, (Block)blockClicked, (org.bukkit.inventory.ItemStack)itemInHand);
        player.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean doEntityAddEventCalling(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entity == null) {
            return false;
        }
        ItemSpawnEvent event = null;
        if (entity instanceof EntityLiving && !(entity instanceof EntityPlayer)) {
            boolean isMonster;
            boolean isAnimal = entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal || entity instanceof EntityGolem;
            boolean bl = isMonster = entity instanceof EntityMonster || entity instanceof EntityGhast || entity instanceof EntitySlime;
            if (spawnReason != CreatureSpawnEvent.SpawnReason.CUSTOM && (isAnimal && !world.getWorld().getAllowAnimals() || isMonster && !world.getWorld().getAllowMonsters())) {
                entity.discard(null);
                return false;
            }
            event = CraftEventFactory.callCreatureSpawnEvent((EntityLiving)entity, spawnReason);
        } else if (entity instanceof EntityItem) {
            event = CraftEventFactory.callItemSpawnEvent((EntityItem)entity);
        } else if (entity.getBukkitEntity() instanceof Projectile) {
            event = CraftEventFactory.callProjectileLaunchEvent(entity);
        } else if (entity.getBukkitEntity() instanceof Vehicle) {
            event = CraftEventFactory.callVehicleCreateEvent(entity);
        } else if (entity.getBukkitEntity() instanceof LightningStrike) {
            LightningStrikeEvent.Cause cause = LightningStrikeEvent.Cause.UNKNOWN;
            switch (spawnReason) {
                case COMMAND: {
                    cause = LightningStrikeEvent.Cause.COMMAND;
                    break;
                }
                case CUSTOM: {
                    cause = LightningStrikeEvent.Cause.CUSTOM;
                    break;
                }
                case SPAWNER: {
                    cause = LightningStrikeEvent.Cause.SPAWNER;
                }
            }
            if (cause == LightningStrikeEvent.Cause.UNKNOWN && spawnReason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
                return true;
            }
            event = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entity.getBukkitEntity(), cause);
        } else if (!(entity instanceof EntityPlayer)) {
            event = CraftEventFactory.callEntitySpawnEvent(entity);
        }
        if (event != null && (event.isCancelled() || entity.dQ())) {
            net.minecraft.world.entity.Entity vehicle = entity.dk();
            if (vehicle != null) {
                vehicle.discard(null);
            }
            for (net.minecraft.world.entity.Entity passenger : entity.dc()) {
                passenger.discard(null);
            }
            entity.discard(null);
            return false;
        }
        if (entity instanceof EntityExperienceOrb) {
            EntityExperienceOrb xp = (EntityExperienceOrb)entity;
            double radius = world.spigotConfig.expMerge;
            event = CraftEventFactory.callEntitySpawnEvent(entity);
            if (radius > 0.0 && !event.isCancelled() && !entity.dQ()) {
                boolean mergeUnconditionally;
                long maxValue = world.paperConfig().entities.behavior.experienceMergeMaxValue;
                boolean bl = mergeUnconditionally = maxValue <= 0L;
                if (mergeUnconditionally || (long)xp.h < maxValue) {
                    List<net.minecraft.world.entity.Entity> entities = world.a_(entity, entity.cR().c(radius, radius, radius));
                    for (net.minecraft.world.entity.Entity e2 : entities) {
                        long newTotal;
                        EntityExperienceOrb loopItem;
                        if (!(e2 instanceof EntityExperienceOrb) || (loopItem = (EntityExperienceOrb)e2).dQ() || xp.i != loopItem.i || !mergeUnconditionally && (long)loopItem.h >= maxValue || !new ExperienceOrbMergeEvent((ExperienceOrb)entity.getBukkitEntity(), (ExperienceOrb)loopItem.getBukkitEntity()).callEvent() || (int)(newTotal = (long)xp.h + (long)loopItem.h) < 0) continue;
                        if (!mergeUnconditionally && newTotal > maxValue) {
                            loopItem.h = (int)(newTotal - maxValue);
                            xp.h = (int)maxValue;
                            continue;
                        }
                        xp.h += loopItem.h;
                        loopItem.discard(null);
                    }
                }
            }
        }
        return true;
    }

    public static EntitySpawnEvent callEntitySpawnEvent(net.minecraft.world.entity.Entity entity) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        EntitySpawnEvent event = new EntitySpawnEvent((Entity)bukkitEntity);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(EntityLiving entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)entityliving.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(EntityInsentient entity, EntityHuman tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        EntityTameEvent event = new EntityTameEvent((LivingEntity)bukkitEntity, (AnimalTamer)bukkitTamer);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(EntityItem entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(EntityItem entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callItemMergeEvent(EntityItem merging, EntityItem mergingWith) {
        Item entityMerging = (Item)merging.getBukkitEntity();
        Item entityMergingWith = (Item)mergingWith.getBukkitEntity();
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PotionSplashEvent callPotionSplashEvent(EntityPotion potion, @javax.annotation.Nullable MovingObjectPosition position, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)position;
            hitBlock = CraftBlock.at(potion.dV(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)position).a().getBukkitEntity();
        }
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, affectedEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LingeringPotionSplashEvent callLingeringPotionSplashEvent(EntityPotion potion, @javax.annotation.Nullable MovingObjectPosition position, EntityAreaEffectCloud cloud) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        AreaEffectCloud effectCloud = (AreaEffectCloud)cloud.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)position;
            hitBlock = CraftBlock.at(potion.dV(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)position).a().getBukkitEntity();
        }
        LingeringPotionSplashEvent event = new LingeringPotionSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, effectCloud);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static WaterBottleSplashEvent callWaterBottleSplashEvent(EntityPotion potion, @javax.annotation.Nullable MovingObjectPosition hitResult, Map<LivingEntity, Double> affectedEntities, Set<LivingEntity> rehydrate, Set<LivingEntity> extinguish) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        CraftEntity hitEntity = null;
        if (hitResult != null) {
            if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
                MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)hitResult;
                hitBlock = CraftBlock.at(potion.dV(), blockHitResult.b());
                hitFace = CraftBlock.notchToBlockFace(blockHitResult.c());
            } else if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
                hitEntity = ((MovingObjectPositionEntity)hitResult).a().getBukkitEntity();
            }
        }
        WaterBottleSplashEvent event = new WaterBottleSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, affectedEntities, rehydrate, extinguish);
        event.callEvent();
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(GeneratorAccess world, BlockPosition pos, IBlockData newBlock) {
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent((Block)state.getBlock(), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleMoistureChangeEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData newBlock, int flag) {
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos, flag);
        state.setData(newBlock);
        MoistureChangeEvent event = new MoistureChangeEvent((Block)state.getBlock(), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBlockSpreadEvent(net.minecraft.world.level.World world, BlockPosition source, BlockPosition target, IBlockData block) {
        return CraftEventFactory.handleBlockSpreadEvent(world, source, target, block, 2);
    }

    public static boolean handleBlockSpreadEvent(GeneratorAccess world, BlockPosition source, BlockPosition target, IBlockData block, int flag) {
        if (!(world instanceof net.minecraft.world.level.World)) {
            world.a(target, block, flag);
            return true;
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent((Block)state.getBlock(), (Block)CraftBlock.at(world, sourceBlockOverride != null ? sourceBlockOverride : source), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static EntityDeathEvent callEntityDeathEvent(EntityLiving victim, net.minecraft.world.damagesource.DamageSource damageSource) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, new ArrayList<Entity.DefaultDrop>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(EntityLiving victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, drops, Runnables.doNothing());
    }

    public static EntityDeathEvent callEntityDeathEvent(EntityLiving victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops, Runnable lootCheck) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        CraftWorld world = (CraftWorld)entity.getWorld();
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)entity, (DamageSource)bukkitDamageSource, (List)new TransformingRandomAccessList(drops, Entity.DefaultDrop::stack, FROM_FUNCTION), victim.getExpReward(world.getHandle(), damageSource.d()));
        CraftEventFactory.populateFields(victim, event);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        CraftEventFactory.playDeathSound(victim, event);
        victim.expToDrop = event.getDroppedExp();
        lootCheck.run();
        for (Entity.DefaultDrop drop : drops) {
            org.bukkit.inventory.ItemStack stack;
            if (drop == null || (stack = drop.stack()) == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            drop.runConsumer(s2 -> world.dropItem(entity.getLocation(), (org.bukkit.inventory.ItemStack)s2));
            if (!(stack instanceof CraftItemStack)) continue;
            stack.setAmount(0);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(EntityPlayer victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops, Component deathMessage, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        PlayerDeathEvent event = new PlayerDeathEvent((Player)entity, (DamageSource)bukkitDamageSource, (List)new TransformingRandomAccessList(drops, Entity.DefaultDrop::stack, FROM_FUNCTION), victim.getExpReward(victim.y(), damageSource.d()), 0, deathMessage);
        event.setKeepInventory(keepInventory);
        event.setKeepLevel(victim.keepLevel);
        CraftEventFactory.populateFields(victim, (EntityDeathEvent)event);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        CraftEventFactory.playDeathSound(victim, (EntityDeathEvent)event);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        for (Entity.DefaultDrop drop : drops) {
            org.bukkit.inventory.ItemStack stack;
            if (drop == null || (stack = drop.stack()) == null || stack.getType() == Material.AIR) continue;
            drop.runConsumer(s2 -> victim.drop(CraftItemStack.unwrap(s2), true, false, false));
        }
        return event;
    }

    private static void populateFields(EntityLiving victim, EntityDeathEvent event) {
        event.setReviveHealth(event.getEntity().getAttribute(Attribute.MAX_HEALTH).getValue());
        event.setShouldPlayDeathSound(!victim.silentDeath && !victim.bb());
        SoundEffect soundEffect = victim.o_();
        event.setDeathSound(soundEffect != null ? CraftSound.minecraftToBukkit(soundEffect) : null);
        event.setDeathSoundCategory(SoundCategory.valueOf((String)victim.dm().name()));
        event.setDeathSoundVolume(victim.fg());
        event.setDeathSoundPitch(victim.fh());
    }

    private static void playDeathSound(EntityLiving victim, EntityDeathEvent event) {
        if (event.shouldPlayDeathSound() && event.getDeathSound() != null && event.getDeathSoundCategory() != null) {
            EntityHuman source = victim instanceof EntityHuman ? (EntityHuman)victim : null;
            double x2 = event.getEntity().getLocation().getX();
            double y2 = event.getEntity().getLocation().getY();
            double z2 = event.getEntity().getLocation().getZ();
            SoundEffect soundEffect = CraftSound.bukkitToMinecraft(event.getDeathSound());
            net.minecraft.sounds.SoundCategory soundCategory = net.minecraft.sounds.SoundCategory.valueOf(event.getDeathSoundCategory().name());
            victim.dV().a(source, x2, y2, z2, soundEffect, soundCategory, event.getDeathSoundVolume(), event.getDeathSoundPitch());
        }
    }

    public static ServerListPingEvent callServerListPingEvent(SocketAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent("", ((InetSocketAddress)address).getAddress(), Bukkit.getServer().motd(), numPlayers, maxPlayers);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        net.minecraft.world.entity.Entity damager;
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(source);
        net.minecraft.world.entity.Entity entity2 = damager = source.eventEntityDamager() != null ? source.eventEntityDamager() : source.c();
        if (source.a(DamageTypeTags.l)) {
            if (damager == null) {
                return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
            }
            EntityDamageEvent.DamageCause damageCause = damager.getBukkitEntity() instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
            return CraftEventFactory.callEntityDamageEvent(damager, entity, damageCause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
        }
        if (damager != null || source.c() != null) {
            EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            if (source.knownCause() != null) {
                cause = source.knownCause();
            } else if (damager instanceof IProjectile) {
                if (damager.getBukkitEntity() instanceof ThrownPotion) {
                    cause = EntityDamageEvent.DamageCause.MAGIC;
                } else if (damager.getBukkitEntity() instanceof Projectile) {
                    cause = EntityDamageEvent.DamageCause.PROJECTILE;
                }
            } else if (source.a(DamageTypes.P)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            } else if (source.a(DamageTypes.S)) {
                cause = EntityDamageEvent.DamageCause.SONIC_BOOM;
            } else if (source.a(DamageTypes.z) || source.a(DamageTypes.x) || source.a(DamageTypes.y)) {
                cause = EntityDamageEvent.DamageCause.FALLING_BLOCK;
            } else if (source.a(DamageTypes.c)) {
                cause = EntityDamageEvent.DamageCause.LIGHTNING;
            } else if (source.a(DamageTypes.l)) {
                cause = EntityDamageEvent.DamageCause.FALL;
            } else if (source.a(DamageTypes.s)) {
                cause = EntityDamageEvent.DamageCause.DRAGON_BREATH;
            } else if (source.a(DamageTypes.q)) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
        }
        if (source.a(DamageTypes.o)) {
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.VOID, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.a(DamageTypes.e)) {
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.LAVA, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.eventBlockDamager() != null) {
            EntityDamageEvent.DamageCause cause = source.knownCause() != null ? source.knownCause() : (source.a(DamageTypes.k) || source.a(DamageTypes.u) || source.a(DamageTypes.w) || source.a(DamageTypes.z) || source.a(DamageTypes.y) ? EntityDamageEvent.DamageCause.CONTACT : (source.a(DamageTypes.f) ? EntityDamageEvent.DamageCause.HOT_FLOOR : (source.a(DamageTypes.q) ? EntityDamageEvent.DamageCause.MAGIC : (source.a(DamageTypes.a) ? EntityDamageEvent.DamageCause.FIRE : (source.a(DamageTypes.b) ? EntityDamageEvent.DamageCause.CAMPFIRE : EntityDamageEvent.DamageCause.CUSTOM)))));
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        EntityDamageEvent.DamageCause cause = source.knownCause() != null ? source.knownCause() : (source.a(DamageTypes.a) ? EntityDamageEvent.DamageCause.FIRE : (source.a(DamageTypes.j) ? EntityDamageEvent.DamageCause.STARVATION : (source.a(DamageTypes.r) ? EntityDamageEvent.DamageCause.WITHER : (source.a(DamageTypes.g) ? EntityDamageEvent.DamageCause.SUFFOCATION : (source.a(DamageTypes.i) ? EntityDamageEvent.DamageCause.DROWNING : (source.a(DamageTypes.d) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.a(DamageTypes.q) ? EntityDamageEvent.DamageCause.MAGIC : (source.a(DamageTypes.l) ? EntityDamageEvent.DamageCause.FALL : (source.a(DamageTypes.n) ? EntityDamageEvent.DamageCause.FLY_INTO_WALL : (source.a(DamageTypes.h) ? EntityDamageEvent.DamageCause.CRAMMING : (source.a(DamageTypes.t) ? EntityDamageEvent.DamageCause.DRYOUT : (source.a(DamageTypes.v) ? EntityDamageEvent.DamageCause.FREEZE : (source.a(DamageTypes.V) ? EntityDamageEvent.DamageCause.KILL : (source.a(DamageTypes.U) ? EntityDamageEvent.DamageCause.WORLD_BORDER : EntityDamageEvent.DamageCause.CUSTOM))))))))))))));
        return CraftEventFactory.callEntityDamageEvent((net.minecraft.world.entity.Entity)null, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
    }

    private static EntityDamageEvent callEntityDamageEvent(net.minecraft.world.entity.Entity damager, net.minecraft.world.entity.Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled, boolean critical) {
        Object event = damager != null ? new EntityDamageByEntityEvent((Entity)damager.getBukkitEntity(), (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions, critical) : new EntityDamageEvent((Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent(event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(Block damager, BlockState damagerState, net.minecraft.world.entity.Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(damager, damagerState, (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent((EntityDamageEvent)event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(EntityDamageEvent event, net.minecraft.world.entity.Entity damagee, boolean cancelled) {
        event.setCancelled(cancelled);
        CraftEventFactory.callEvent(event);
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        } else {
            damagee.lastDamageCancelled = true;
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.world.entity.Entity damagee, net.minecraft.world.damagesource.DamageSource source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption) {
        return CraftEventFactory.handleLivingEntityDamageEvent(damagee, source, rawDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption, null);
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.world.entity.Entity damagee, net.minecraft.world.damagesource.DamageSource source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption, BiConsumer<Map<EntityDamageEvent.DamageModifier, Double>, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>> callback) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source.a(DamageTypeTags.o)) {
            modifiers.put(EntityDamageEvent.DamageModifier.FREEZING, freezingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.FREEZING, freezing);
        }
        if (source.a(DamageTypeTags.a)) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof EntityHuman) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        if (callback != null) {
            callback.accept(modifiers, modifierFunctions);
        }
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, true);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelOnZeroDamage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, cancelOnZeroDamage, false);
    }

    public static EntityDamageEvent callNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelled) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions, cancelled);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelOnZeroDamage, boolean cancelled) {
        EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(entity, source, damage, cancelled);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || cancelOnZeroDamage && event.getDamage() == 0.0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(EntityHuman entity, int expAmount) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpCooldownChangeEvent callPlayerXpCooldownEvent(EntityHuman entity, int newCooldown, PlayerExpCooldownChangeEvent.ChangeReason changeReason) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpCooldownChangeEvent event = new PlayerExpCooldownChangeEvent(player, newCooldown, changeReason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(EntityHuman entity, EntityExperienceOrb orb, ItemStack nmsMendedItem, EnumItemSlot slot, int repairAmount, int consumedExperience) {
        Player player = (Player)entity.getBukkitEntity();
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, (org.bukkit.inventory.ItemStack)bukkitStack, CraftEquipmentSlot.getSlot(slot), (ExperienceOrb)orb.getBukkitEntity(), repairAmount, consumedExperience);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(EntityHuman entity, EntityExperienceOrb entityOrb) {
        Player player = (Player)entity.getBukkitEntity();
        ExperienceOrb source = (ExperienceOrb)entityOrb.getBukkitEntity();
        int expAmount = source.getExperience();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, (Entity)source, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockGrowEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData block) {
        return CraftEventFactory.handleBlockGrowEvent(world, pos, block, 3);
    }

    public static boolean handleBlockGrowEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData newData, int flag) {
        Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static FluidLevelChangeEvent callFluidLevelChangeEvent(net.minecraft.world.level.World world, BlockPosition block, IBlockData newData) {
        FluidLevelChangeEvent event = new FluidLevelChangeEvent((Block)CraftBlock.at(world, block), (BlockData)CraftBlockData.fromData(newData));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(EntityHuman entity, int level) {
        return CraftEventFactory.callFoodLevelChangeEvent(entity, level, null);
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(EntityHuman entity, int level, ItemStack item) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)entity.getBukkitEntity(), level, item == null ? null : CraftItemStack.asBukkitCopy(item));
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(net.minecraft.world.entity.Entity pig, net.minecraft.world.entity.Entity lightning, net.minecraft.world.entity.Entity pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)pig.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (PigZombie)pigzombie.getBukkitEntity());
        pig.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callHorseJumpEvent(net.minecraft.world.entity.Entity horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)horse.getBukkitEntity(), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityZapEvent callEntityZapEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity lightning, net.minecraft.world.entity.Entity changedEntity) {
        EntityZapEvent event = new EntityZapEvent((Entity)entity.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (Entity)changedEntity.getBukkitEntity());
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callEntityChangeBlockEvent(net.minecraft.world.entity.Entity entity, BlockPosition position, IBlockData newBlock) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, position, newBlock, false);
    }

    public static boolean callEntityChangeBlockEvent(net.minecraft.world.entity.Entity entity, BlockPosition position, IBlockData newBlock, boolean cancelled) {
        Block block = entity.dV().getWorld().getBlockAt(position.u(), position.v(), position.w());
        EntityChangeBlockEvent event = new EntityChangeBlockEvent((Entity)entity.getBukkitEntity(), block, (BlockData)CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static CreeperPowerEvent callCreeperPowerEvent(net.minecraft.world.entity.Entity creeper, net.minecraft.world.entity.Entity lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)creeper.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent((Entity)entity.getBukkitEntity(), (Entity)(target == null ? null : target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(net.minecraft.world.entity.Entity entity, EntityLiving target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (LivingEntity)target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(net.minecraft.world.entity.Entity entity, BlockPosition pos, IBlockData newState) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at(entity.dV(), pos);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)entity1, (Block)block, (BlockData)newState.createCraftBlockData());
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static Container callInventoryOpenEvent(EntityPlayer player, Container container) {
        return (Container)CraftEventFactory.callInventoryOpenEventWithTitle(player, container).getSecond();
    }

    public static Pair<@Nullable Component, @Nullable Container> callInventoryOpenEventWithTitle(EntityPlayer player, Container container) {
        return CraftEventFactory.callInventoryOpenEventWithTitle(player, container, false);
    }

    @Deprecated
    @DoNotUse
    public static Container callInventoryOpenEvent(EntityPlayer player, Container container, boolean cancelled) {
        return (Container)CraftEventFactory.callInventoryOpenEventWithTitle(player, container, cancelled).getSecond();
    }

    public static Pair<@Nullable Component, @Nullable Container> callInventoryOpenEventWithTitle(EntityPlayer player, Container container, boolean cancelled) {
        container.startOpen();
        if (player.cd != player.cc) {
            player.f.handleContainerClose(new PacketPlayInCloseWindow(player.cd.l), InventoryCloseEvent.Reason.OPEN_NEW);
        }
        CraftServer server = player.dV().getCraftServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.cd.transferTo(container, craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        event.setCancelled(cancelled);
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            container.transferTo(player.cd, craftPlayer);
            return Pair.of(null, null);
        }
        return Pair.of((Object)event.titleOverride(), (Object)container);
    }

    public static ItemStack callPreCraftEvent(InventoryCrafting matrix, IInventory resultInventory, ItemStack result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent((CraftingInventory)inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent((Event)event);
        org.bukkit.inventory.ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static CrafterCraftEvent callCrafterCraftEvent(BlockPosition pos, net.minecraft.world.level.World world, InventoryCrafting inventoryCrafting, ItemStack result, RecipeHolder<RecipeCrafting> holder) {
        CraftBlock block = CraftBlock.at(world, pos);
        CraftItemStack itemStack = CraftItemStack.asCraftMirror(result);
        CraftingRecipe craftingRecipe = (CraftingRecipe)holder.toBukkitRecipe();
        CrafterCraftEvent crafterCraftEvent = new CrafterCraftEvent((Block)block, craftingRecipe, (org.bukkit.inventory.ItemStack)itemStack);
        Bukkit.getPluginManager().callEvent((Event)crafterCraftEvent);
        return crafterCraftEvent;
    }

    @Deprecated
    public static ProjectileCollideEvent callProjectileCollideEvent(net.minecraft.world.entity.Entity entity, MovingObjectPositionEntity position) {
        Projectile projectile = (Projectile)entity.getBukkitEntity();
        CraftEntity collided = position.a().getBukkitEntity();
        ProjectileCollideEvent event = new ProjectileCollideEvent(projectile, (Entity)collided);
        if (projectile.getShooter() instanceof Player && collided instanceof Player && !((Player)projectile.getShooter()).canSee((Player)collided)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(net.minecraft.world.entity.Entity entity) {
        Projectile bukkitEntity = (Projectile)entity.getBukkitEntity();
        ProjectileLaunchEvent event = new ProjectileLaunchEvent((Entity)bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(net.minecraft.world.entity.Entity entity, MovingObjectPosition position) {
        if (position.d() == MovingObjectPosition.EnumMovingObjectType.a) {
            return null;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)position;
            hitBlock = CraftBlock.at(entity.dV(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)position).a().getBukkitEntity();
        }
        boolean cancelled = false;
        if (hitEntity != null && position instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)position;
            cancelled = CraftEventFactory.callProjectileCollideEvent(entity, entityHitResult).isCancelled();
        }
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)entity.getBukkitEntity(), (Entity)hitEntity, (Block)hitBlock, hitFace);
        event.setCancelled(cancelled);
        entity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(net.minecraft.world.entity.Entity entity, MovingObjectPosition position, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)entity.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)position;
            hitBlock = CraftBlock.at(entity.dV(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)position).a().getBukkitEntity();
        }
        ExpBottleEvent event = new ExpBottleEvent(bottle, (Entity)hitEntity, (Block)hitBlock, hitFace, exp);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(net.minecraft.world.level.World world, BlockPosition pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), oldCurrent, newCurrent);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(net.minecraft.world.level.World world, BlockPosition pos, BlockPropertyInstrument instrument, int note) {
        NotePlayEvent event = new NotePlayEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), Instrument.getByType((byte)((byte)instrument.ordinal())), new Note(note));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerItemBreakEvent(EntityPlayer human, ItemStack brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)human.getBukkitEntity(), (org.bukkit.inventory.ItemStack)item);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition block, BlockPosition source) {
        CraftWorld bukkitWorld = world.getWorld();
        Block igniter = bukkitWorld.getBlockAt(source.u(), source.v(), source.w());
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(block.u(), block.v(), block.w()), switch (igniter.getType()) {
            case Material.LAVA -> BlockIgniteEvent.IgniteCause.LAVA;
            case Material.DISPENSER -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            default -> BlockIgniteEvent.IgniteCause.SPREAD;
        }, igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition pos, net.minecraft.world.entity.Entity igniter) {
        net.minecraft.world.entity.Entity shooter;
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        BlockIgniteEvent.IgniteCause cause = switch (bukkitIgniter.getType()) {
            case EntityType.END_CRYSTAL -> BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
            case EntityType.LIGHTNING_BOLT -> BlockIgniteEvent.IgniteCause.LIGHTNING;
            case EntityType.SMALL_FIREBALL, EntityType.FIREBALL -> BlockIgniteEvent.IgniteCause.FIREBALL;
            case EntityType.ARROW -> BlockIgniteEvent.IgniteCause.ARROW;
            default -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
        };
        if (igniter instanceof IProjectile && (shooter = ((IProjectile)igniter).p()) != null) {
            bukkitIgniter = shooter.getBukkitEntity();
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(pos.u(), pos.v(), pos.w()), cause, (Entity)bukkitIgniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition blockposition, Explosion explosion) {
        CraftEntity igniter = explosion.d() == null ? null : explosion.d().getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, blockposition), BlockIgniteEvent.IgniteCause.EXPLOSION, (Entity)igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition pos, BlockIgniteEvent.IgniteCause cause, net.minecraft.world.entity.Entity igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), cause, (Entity)igniter.getBukkitEntity());
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    @Deprecated
    public static void handleInventoryCloseEvent(EntityHuman human) {
        CraftEventFactory.handleInventoryCloseEvent(human, InventoryCloseEvent.Reason.UNKNOWN);
    }

    public static void handleInventoryCloseEvent(EntityHuman human, InventoryCloseEvent.Reason reason) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.cd.getBukkitView(), reason);
        human.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        human.cd.transferTo(human.cc, human.getBukkitEntity());
    }

    public static ItemStack handleEditBookEvent(EntityPlayer player, int itemInHandIndex, ItemStack itemInHand, ItemStack newBookItem) {
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent((Player)player.getBukkitEntity(), itemInHandIndex >= 0 && itemInHandIndex <= 8 ? itemInHandIndex : -1, (BookMeta)CraftItemStack.getItemMeta(itemInHand), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.h() == Items.uY);
        player.dV().getCraftServer().getPluginManager().callEvent((Event)editBookEvent);
        if (itemInHand != null && itemInHand.h() == Items.uX) {
            if (!editBookEvent.isCancelled()) {
                if (editBookEvent.isSigning()) {
                    itemInHand.setItem(Items.uY);
                }
                BookMeta meta = editBookEvent.getNewBookMeta();
                CraftItemStack.setItemMeta(itemInHand, (ItemMeta)meta);
            } else {
                player.getBukkitEntity().updateInventory();
            }
        }
        return itemInHand;
    }

    public static void callRecipeBookSettingsEvent(EntityPlayer player, RecipeBookType type, boolean open, boolean filter) {
        PlayerRecipeBookSettingsChangeEvent.RecipeBookType bukkitType = PlayerRecipeBookSettingsChangeEvent.RecipeBookType.values()[type.ordinal()];
        Bukkit.getPluginManager().callEvent((Event)new PlayerRecipeBookSettingsChangeEvent((Player)player.getBukkitEntity(), bukkitType, open, filter));
    }

    public static PlayerUnleashEntityEvent callPlayerUnleashEntityEvent(net.minecraft.world.entity.Entity entity, EntityHuman player, EnumHand enumhand, boolean dropLeash) {
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(enumhand), dropLeash);
        entity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity leashHolder, EntityHuman player, EnumHand enumhand) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent((Entity)entity.getBukkitEntity(), (Entity)leashHolder.getBukkitEntity(), (Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(enumhand));
        entity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerRiptideEvent(EntityHuman player, ItemStack tridentItemStack, float velocityX, float velocityY, float velocityZ) {
        PlayerRiptideEvent event = new PlayerRiptideEvent((Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(tridentItemStack), new Vector(velocityX, velocityY, velocityZ));
        player.dV().getCraftServer().getPluginManager().callEvent((Event)event);
    }

    public static BlockShearEntityEvent callBlockShearEntityEvent(net.minecraft.world.entity.Entity animal, Block dispenser, CraftItemStack is, List<ItemStack> drops) {
        BlockShearEntityEvent bse = new BlockShearEntityEvent(dispenser, (Entity)animal.getBukkitEntity(), (org.bukkit.inventory.ItemStack)is, Lists.transform(drops, CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)bse);
        return bse;
    }

    public static PlayerShearEntityEvent handlePlayerShearEntityEvent(EntityHuman player, net.minecraft.world.entity.Entity sheared, ItemStack shears, EnumHand hand, List<ItemStack> drops) {
        if (!(player instanceof EntityPlayer)) {
            return null;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((Player)player.getBukkitEntity(), (Entity)sheared.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(shears), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND, Lists.transform(drops, CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static Cancellable handleStatisticsIncrease(EntityHuman entityHuman, net.minecraft.stats.Statistic<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        CraftPlayer player = ((EntityPlayer)entityHuman).getBukkitEntity();
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            System.err.println("Unhandled statistic: " + String.valueOf(statistic));
            return null;
        }
        switch (stat) {
            case FALL_ONE_CM: 
            case BOAT_ONE_CM: 
            case CLIMB_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case FLY_ONE_CM: 
            case HORSE_ONE_CM: 
            case MINECART_ONE_CM: 
            case PIG_ONE_CM: 
            case PLAY_ONE_MINUTE: 
            case SWIM_ONE_CM: 
            case WALK_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SNEAK_TIME: 
            case TOTAL_WORLD_TIME: 
            case TIME_SINCE_REST: 
            case AVIATE_ONE_CM: 
            case STRIDER_ONE_CM: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, material);
        }
        entityHuman.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return (Cancellable)event;
    }

    public static FireworkExplodeEvent callFireworkExplodeEvent(EntityFireworks firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)firework.getBukkitEntity());
        firework.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PrepareAnvilEvent callPrepareAnvilEvent(AnvilView view, ItemStack item) {
        view.getTopInventory().setItem(2, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static PrepareGrindstoneEvent callPrepareGrindstoneEvent(InventoryView view, ItemStack item) {
        view.getTopInventory().setItem(2, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static PrepareSmithingEvent callPrepareSmithingEvent(InventoryView view, ItemStack item) {
        view.getTopInventory().setItem(3, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static void callPrepareResultEvent(Container container, int resultSlot) {
        Object event;
        CraftItemStack result;
        InventoryView view = container.getBukkitView();
        org.bukkit.inventory.ItemStack origItem = view.getTopInventory().getItem(resultSlot);
        CraftItemStack craftItemStack = result = origItem != null ? CraftItemStack.asCraftCopy(origItem) : null;
        if (view.getTopInventory() instanceof AnvilInventory && view instanceof AnvilView) {
            AnvilView anvilView = (AnvilView)view;
            event = new PrepareAnvilEvent(anvilView, (org.bukkit.inventory.ItemStack)result);
        } else {
            event = view.getTopInventory() instanceof GrindstoneInventory ? new PrepareGrindstoneEvent(view, (org.bukkit.inventory.ItemStack)result) : (view.getTopInventory() instanceof SmithingInventory ? new PrepareSmithingEvent(view, (org.bukkit.inventory.ItemStack)result) : new PrepareResultEvent(view, (org.bukkit.inventory.ItemStack)result));
        }
        event.callEvent();
        event.getInventory().setItem(resultSlot, event.getResult());
        container.d();
    }

    public static SpawnerSpawnEvent callSpawnerSpawnEvent(net.minecraft.world.entity.Entity spawnee, BlockPosition pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.dV(), pos).getState();
        if (!(state instanceof CreatureSpawner)) {
            state = null;
        }
        SpawnerSpawnEvent event = new SpawnerSpawnEvent((Entity)entity, (CreatureSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TrialSpawnerSpawnEvent callTrialSpawnerSpawnEvent(net.minecraft.world.entity.Entity spawnee, BlockPosition pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.dV(), pos).getState();
        if (!(state instanceof TrialSpawner)) {
            state = null;
        }
        TrialSpawnerSpawnEvent event = new TrialSpawnerSpawnEvent((Entity)entity, (TrialSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDispenseLootEvent callBlockDispenseLootEvent(WorldServer worldServer, BlockPosition blockPosition, EntityHuman player, List<ItemStack> rewardLoot) {
        List craftItemStacks = rewardLoot.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        BlockDispenseLootEvent event = new BlockDispenseLootEvent(player == null ? null : (Player)player.getBukkitEntity(), (Block)CraftBlock.at(worldServer, blockPosition), craftItemStacks);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VaultDisplayItemEvent callVaultDisplayItemEvent(WorldServer worldServer, BlockPosition blockPosition, ItemStack displayitemStack) {
        VaultDisplayItemEvent event = new VaultDisplayItemEvent((Block)CraftBlock.at(worldServer, blockPosition), CraftItemStack.asBukkitCopy(displayitemStack));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleGlideEvent callToggleGlideEvent(EntityLiving entity, boolean gliding) {
        EntityToggleGlideEvent event = new EntityToggleGlideEvent((LivingEntity)entity.getBukkitEntity(), gliding);
        entity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleSwimEvent callToggleSwimEvent(EntityLiving entity, boolean swimming) {
        EntityToggleSwimEvent event = new EntityToggleSwimEvent((LivingEntity)entity.getBukkitEntity(), swimming);
        entity.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static AreaEffectCloudApplyEvent callAreaEffectCloudApplyEvent(EntityAreaEffectCloud cloud, List<LivingEntity> entities) {
        AreaEffectCloudApplyEvent event = new AreaEffectCloudApplyEvent((AreaEffectCloud)cloud.getBukkitEntity(), entities);
        cloud.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VehicleCreateEvent callVehicleCreateEvent(net.minecraft.world.entity.Entity entity) {
        Vehicle bukkitEntity = (Vehicle)entity.getBukkitEntity();
        VehicleCreateEvent event = new VehicleCreateEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreedEvent callEntityBreedEvent(EntityLiving child, EntityLiving mother, EntityLiving father, EntityLiving breeder, ItemStack bredWith, int experience) {
        LivingEntity breederEntity = breeder == null ? null : (LivingEntity)breeder.getBukkitEntity();
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((LivingEntity)child.getBukkitEntity(), (LivingEntity)mother.getBukkitEntity(), (LivingEntity)father.getBukkitEntity(), breederEntity, (org.bukkit.inventory.ItemStack)bredWithStack, experience);
        event.callEvent();
        return event;
    }

    public static BlockPhysicsEvent callBlockPhysicsEvent(GeneratorAccess world, BlockPosition blockposition) {
        CraftBlock block = CraftBlock.at(world, blockposition);
        BlockPhysicsEvent event = new BlockPhysicsEvent((Block)block, block.getBlockData());
        if (world instanceof net.minecraft.world.level.World) {
            ((net.minecraft.world.level.World)world).p().server.getPluginManager().callEvent((Event)event);
        }
        return event;
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData block) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @javax.annotation.Nullable MobEffect oldEffect, @javax.annotation.Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @javax.annotation.Nullable MobEffect oldEffect, @javax.annotation.Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @javax.annotation.Nullable MobEffect oldEffect, @javax.annotation.Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause, boolean willOverride) {
        EntityPotionEffectEvent.Action action = EntityPotionEffectEvent.Action.CHANGED;
        if (oldEffect == null) {
            action = EntityPotionEffectEvent.Action.ADDED;
        } else if (newEffect == null) {
            action = EntityPotionEffectEvent.Action.REMOVED;
        }
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, willOverride);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @javax.annotation.Nullable MobEffect oldEffect, @javax.annotation.Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action, boolean willOverride) {
        PotionEffect bukkitOldEffect = oldEffect == null ? null : CraftPotionUtil.toBukkit(oldEffect);
        PotionEffect bukkitNewEffect = newEffect == null ? null : CraftPotionUtil.toBukkit(newEffect);
        Preconditions.checkState((bukkitOldEffect != null || bukkitNewEffect != null ? 1 : 0) != 0, (Object)"Old and new potion effect are both null");
        EntityPotionEffectEvent event = new EntityPotionEffectEvent((LivingEntity)entity.getBukkitEntity(), bukkitOldEffect, bukkitNewEffect, cause, action, willOverride);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData block, @javax.annotation.Nullable net.minecraft.world.entity.Entity entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3, entity);
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData block, int flag) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, flag, null);
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData block, int flag, @javax.annotation.Nullable net.minecraft.world.entity.Entity entity) {
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent((Block)blockState.getBlock(), (BlockState)blockState) : new EntityBlockFormEvent((Entity)entity.getBukkitEntity(), (Block)blockState.getBlock(), (BlockState)blockState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBatToggleSleepEvent(net.minecraft.world.entity.Entity bat, boolean awake) {
        BatToggleSleepEvent event = new BatToggleSleepEvent((Bat)bat.getBukkitEntity(), awake);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handlePlayerRecipeListUpdateEvent(EntityHuman who, MinecraftKey recipe) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((Player)who.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipe));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(net.minecraft.world.entity.Entity who, EntityItem item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((LivingEntity)who.getBukkitEntity(), (Item)item.getBukkitEntity(), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LightningStrikeEvent callLightningStrikeEvent(LightningStrike entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent event = new LightningStrikeEvent(entity.getWorld(), entity, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callRaidTriggerEvent(net.minecraft.world.entity.raid.Raid raid, EntityPlayer player) {
        RaidTriggerEvent event = new RaidTriggerEvent((Raid)new CraftRaid(raid), (World)raid.i().getWorld(), (Player)player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void callRaidFinishEvent(net.minecraft.world.entity.raid.Raid raid, List<Player> players) {
        RaidFinishEvent event = new RaidFinishEvent((Raid)new CraftRaid(raid), (World)raid.i().getWorld(), players);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidStopEvent(net.minecraft.world.entity.raid.Raid raid, RaidStopEvent.Reason reason) {
        RaidStopEvent event = new RaidStopEvent((Raid)new CraftRaid(raid), (World)raid.i().getWorld(), reason);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidSpawnWaveEvent(net.minecraft.world.entity.raid.Raid raid, EntityRaider leader, Set<EntityRaider> raiders) {
        Raider bukkitLeader = (Raider)leader.getBukkitEntity();
        ArrayList<Raider> bukkitRaiders = new ArrayList<Raider>(raiders.size());
        for (EntityRaider raider : raiders) {
            bukkitRaiders.add((Raider)raider.getBukkitEntity());
        }
        RaidSpawnWaveEvent event = new RaidSpawnWaveEvent((Raid)new CraftRaid(raid), (World)raid.i().getWorld(), bukkitLeader, bukkitRaiders);
        event.callEvent();
    }

    public static LootGenerateEvent callLootGenerateEvent(IInventory inventory, net.minecraft.world.level.storage.loot.LootTable lootTable, LootTableInfo lootInfo, List<ItemStack> loot, boolean plugin) {
        CraftWorld world = lootInfo.d().getWorld();
        net.minecraft.world.entity.Entity entity = lootInfo.c(LootContextParameters.a);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        LootGenerateEvent event = new LootGenerateEvent((World)world, (Entity)(entity != null ? entity.getBukkitEntity() : null), inventory.getOwner(), (LootTable)lootTable.craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callStriderTemperatureChangeEvent(EntityStrider strider, boolean shivering) {
        StriderTemperatureChangeEvent event = new StriderTemperatureChangeEvent((Strider)strider.getBukkitEntity(), shivering);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handleEntitySpellCastEvent(EntityIllagerWizard caster, EntityIllagerWizard.Spell spell) {
        EntitySpellCastEvent event = new EntitySpellCastEvent((Spellcaster)caster.getBukkitEntity(), CraftSpellcaster.toBukkitSpell(spell));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static ArrowBodyCountChangeEvent callArrowBodyCountChangeEvent(EntityLiving entity, int oldAmount, int newAmount, boolean isReset) {
        LivingEntity bukkitEntity = (LivingEntity)entity.getBukkitEntity();
        ArrowBodyCountChangeEvent event = new ArrowBodyCountChangeEvent(bukkitEntity, oldAmount, newAmount, isReset);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityExhaustionEvent callPlayerExhaustionEvent(EntityHuman humanEntity, EntityExhaustionEvent.ExhaustionReason exhaustionReason, float exhaustion) {
        EntityExhaustionEvent event = new EntityExhaustionEvent((HumanEntity)humanEntity.getBukkitEntity(), exhaustionReason, exhaustion);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PiglinBarterEvent callPiglinBarterEvent(EntityPiglin piglin, List<ItemStack> outcome, ItemStack input) {
        PiglinBarterEvent event = new PiglinBarterEvent((Piglin)piglin.getBukkitEntity(), CraftItemStack.asBukkitCopy(input), outcome.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callEntitiesLoadEvent(net.minecraft.world.level.World world, ChunkCoordIntPair coords, List<net.minecraft.world.entity.Entity> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesLoadEvent event = new EntitiesLoadEvent((Chunk)new CraftChunk((WorldServer)world, coords.h, coords.i), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callEntitiesUnloadEvent(net.minecraft.world.level.World world, ChunkCoordIntPair coords, List<net.minecraft.world.entity.Entity> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesUnloadEvent event = new EntitiesUnloadEvent((Chunk)new CraftChunk((WorldServer)world, coords.h, coords.i), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static boolean callTNTPrimeEvent(net.minecraft.world.level.World world, BlockPosition pos, TNTPrimeEvent.PrimeCause cause, net.minecraft.world.entity.Entity causingEntity, BlockPosition causePosition) {
        CraftEntity bukkitEntity = causingEntity == null ? null : causingEntity.getBukkitEntity();
        CraftBlock bukkitBlock = causePosition == null ? null : CraftBlock.at(world, causePosition);
        TNTPrimeEvent event = new TNTPrimeEvent((Block)CraftBlock.at(world, pos), cause, (Entity)bukkitEntity, (Block)bukkitBlock);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerRecipeBookClickEvent callRecipeBookClickEvent(EntityPlayer player, Recipe recipe, boolean shiftClick) {
        PlayerRecipeBookClickEvent event = new PlayerRecipeBookClickEvent((Player)player.getBukkitEntity(), recipe, shiftClick);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTeleportEvent callEntityTeleportEvent(net.minecraft.world.entity.Entity nmsEntity, double x2, double y2, double z2) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        Location to = new Location(entity.getWorld(), x2, y2, z2, nmsEntity.dL(), nmsEntity.dN());
        return CraftEventFactory.callEntityTeleportEvent(nmsEntity, to);
    }

    public static EntityTeleportEvent callEntityTeleportEvent(net.minecraft.world.entity.Entity nmsEntity, Location to) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity, entity.getLocation(), to);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callEntityInteractEvent(net.minecraft.world.entity.Entity nmsEntity, Block block) {
        EntityInteractEvent event = new EntityInteractEvent((Entity)nmsEntity.getBukkitEntity(), block);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityExplodeEvent callEntityExplodeEvent(net.minecraft.world.entity.Entity entity, List<Block> blocks, float yield, Explosion.Effect effect) {
        EntityExplodeEvent event = new EntityExplodeEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), blocks, yield, CraftExplosionResult.toBukkit(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockExplodeEvent callBlockExplodeEvent(Block block, BlockState state, List<Block> blocks, float yield, Explosion.Effect effect) {
        BlockExplodeEvent event = new BlockExplodeEvent(block, state, blocks, yield, CraftExplosionResult.toBukkit(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(Explosive explosive) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent(explosive);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(net.minecraft.world.entity.Entity nmsEntity, float size, boolean fire) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent((Entity)nmsEntity.getBukkitEntity(), size, fire);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static io.papermc.paper.event.entity.EntityKnockbackEvent callEntityKnockbackEvent(CraftLivingEntity entity, net.minecraft.world.entity.Entity pusher, net.minecraft.world.entity.Entity attacker, EntityKnockbackEvent.Cause cause, double force, Vec3D knockback) {
        Vector apiKnockback = CraftVector.toBukkit(knockback);
        Vector currentVelocity = entity.getVelocity();
        Vector legacyFinalKnockback = currentVelocity.clone().add(apiKnockback);
        EntityKnockbackEvent.KnockbackCause legacyCause = EntityKnockbackEvent.KnockbackCause.valueOf((String)cause.name());
        Object legacyEvent = pusher != null ? new org.bukkit.event.entity.EntityKnockbackByEntityEvent((LivingEntity)entity, (Entity)pusher.getBukkitEntity(), legacyCause, force, apiKnockback, legacyFinalKnockback) : new EntityKnockbackEvent((LivingEntity)entity, legacyCause, force, apiKnockback, legacyFinalKnockback);
        legacyEvent.callEvent();
        apiKnockback = legacyEvent.getFinalKnockback().subtract(currentVelocity);
        Object event = attacker != null ? new EntityKnockbackByEntityEvent((LivingEntity)entity, (Entity)attacker.getBukkitEntity(), cause, (float)force, apiKnockback) : new io.papermc.paper.event.entity.EntityKnockbackEvent((Entity)entity, cause, apiKnockback);
        event.setCancelled(legacyEvent.isCancelled());
        event.callEvent();
        return event;
    }

    public static void callEntityRemoveEvent(net.minecraft.world.entity.Entity entity, EntityRemoveEvent.Cause cause) {
        if (entity instanceof EntityPlayer) {
            return;
        }
        if (cause == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityRemoveEvent((Entity)entity.getBukkitEntity(), cause));
    }

    public static void callPlayerUseUnknownEntityEvent(EntityHuman player, PacketPlayInUseEntity packet, EnumHand hand, @javax.annotation.Nullable Vec3D vector) {
        new PlayerUseUnknownEntityEvent((Player)player.getBukkitEntity(), packet.getEntityId(), packet.isAttack(), CraftEquipmentSlot.getHand(hand), vector != null ? CraftVector.toBukkit(vector) : null).callEvent();
    }

    public static ItemStack handleWitchReadyPotionEvent(EntityWitch witch, @javax.annotation.Nullable ItemStack potion) {
        WitchReadyPotionEvent event = new WitchReadyPotionEvent((Witch)witch.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(potion));
        if (!event.callEvent() || event.getPotion() == null) {
            return ItemStack.j;
        }
        return CraftItemStack.asNMSCopy(event.getPotion());
    }

    public static boolean handleBlockFailedDispenseEvent(WorldServer serverLevel, BlockPosition pos) {
        CraftBlock block = CraftBlock.at(serverLevel, pos);
        BlockFailedDispenseEvent event = new BlockFailedDispenseEvent((Block)block);
        return event.callEvent();
    }

    public static boolean handleBlockPreDispenseEvent(WorldServer serverLevel, BlockPosition pos, ItemStack itemStack, int slot) {
        CraftBlock block = CraftBlock.at(serverLevel, pos);
        BlockPreDispenseEvent event = new BlockPreDispenseEvent((Block)block, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemStack), slot);
        return event.callEvent();
    }

    @javax.annotation.Nullable
    public static ItemStack handleBlockDispenseEvent(SourceBlock pointer, BlockPosition to, ItemStack itemStack, IDispenseBehavior instance) {
        ItemStack eventStack;
        IDispenseBehavior itemBehavior;
        CraftBlock bukkitBlock = CraftBlock.at(pointer.b(), pointer.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemStack.c(1));
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (org.bukkit.inventory.ItemStack)craftItem.clone(), CraftVector.toBukkit(to));
        if (!BlockDispenser.eventFired && !event.callEvent()) {
            return itemStack;
        }
        if (!event.getItem().equals((Object)craftItem) && (itemBehavior = BlockDispenser.getDispenseBehavior(pointer, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != IDispenseBehavior.b && itemBehavior != instance) {
            itemBehavior.dispense(pointer, eventStack);
            return itemStack;
        }
        return null;
    }

    public static EntityFertilizeEggEvent callEntityFertilizeEggEvent(EntityAnimal breeding, EntityAnimal other) {
        EntityPlayer serverPlayer = breeding.gB();
        if (serverPlayer == null) {
            serverPlayer = other.gB();
        }
        int experience = breeding.dY().a(7) + 1;
        EntityFertilizeEggEvent event = new EntityFertilizeEggEvent((LivingEntity)breeding.getBukkitEntity(), (LivingEntity)other.getBukkitEntity(), (Player)(serverPlayer == null ? null : serverPlayer.getBukkitEntity()), breeding.breedItem == null ? null : CraftItemStack.asCraftMirror(breeding.breedItem).clone(), experience);
        if (!event.callEvent()) {
            breeding.gD();
            other.gD();
        }
        return event;
    }
}

