/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPig;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftAnimals;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, EntityPig entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().j();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().ca.a(saddled);
    }

    public int getBoostTicks() {
        return this.getHandle().ca.f ? this.getHandle().ca.e() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().ca.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().ca.f ? this.getHandle().ca.g : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().ca.f) {
            return;
        }
        int max = this.getHandle().ca.e();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %s (inclusive)", (int)max);
        this.getHandle().ca.g = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    @Override
    public EntityPig getHandle() {
        return (EntityPig)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }
}

