/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.papermc.paper.entity.PaperShearable;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftCow
implements MushroomCow,
PaperShearable {
    public CraftMushroomCow(CraftServer server, EntityMushroomCow entity) {
        super(server, entity);
    }

    public boolean hasEffectsForNextStew() {
        SuspiciousStewEffects stewEffects = this.getHandle().cc;
        return stewEffects != null && !stewEffects.a().isEmpty();
    }

    public List<PotionEffect> getEffectsForNextStew() {
        SuspiciousStewEffects stewEffects = this.getHandle().cc;
        if (stewEffects != null) {
            return stewEffects.a().stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.a())).toList();
        }
        return ImmutableList.of();
    }

    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        return this.addEffectToNextStew(SuspiciousEffectEntry.create((PotionEffectType)potionEffect.getType(), (int)potionEffect.getDuration()), overwrite);
    }

    public boolean addEffectToNextStew(SuspiciousEffectEntry suspiciousEffectEntry, boolean overwrite) {
        Preconditions.checkArgument((suspiciousEffectEntry != null ? 1 : 0) != 0, (Object)"SuspiciousEffectEntry cannot be null");
        Holder<MobEffectList> minecraftPotionEffect = CraftPotionEffectType.bukkitToMinecraftHolder(suspiciousEffectEntry.effect());
        if (!overwrite && this.hasEffectForNextStew(suspiciousEffectEntry.effect())) {
            return false;
        }
        SuspiciousStewEffects stewEffects = this.getHandle().cc;
        if (stewEffects == null) {
            stewEffects = SuspiciousStewEffects.a;
        }
        SuspiciousStewEffects.a recordSuspiciousEffect = new SuspiciousStewEffects.a(minecraftPotionEffect, suspiciousEffectEntry.duration());
        this.removeEffectFromNextStew(suspiciousEffectEntry.effect());
        this.getHandle().cc = stewEffects.a(recordSuspiciousEffect);
        return true;
    }

    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectForNextStew(potionEffectType)) {
            return false;
        }
        SuspiciousStewEffects stewEffects = this.getHandle().cc;
        if (stewEffects == null) {
            return false;
        }
        Holder<MobEffectList> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        this.getHandle().cc = new SuspiciousStewEffects(stewEffects.a().stream().filter(effect -> !effect.b().equals(minecraftPotionEffectType)).toList());
        return true;
    }

    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        SuspiciousStewEffects stewEffects = this.getHandle().cc;
        if (stewEffects == null) {
            return false;
        }
        Holder<MobEffectList> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        return stewEffects.a().stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.b().equals(minecraftPotionEffectType));
    }

    public void clearEffectsForNextStew() {
        this.getHandle().cc = null;
    }

    @Override
    public EntityMushroomCow getHandle() {
        return (EntityMushroomCow)this.entity;
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().t().ordinal()];
    }

    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().a(EntityMushroomCow.Type.values()[variant.ordinal()]);
    }

    public List<SuspiciousEffectEntry> getStewEffects() {
        if (this.getHandle().cc == null) {
            return List.of();
        }
        ArrayList<SuspiciousEffectEntry> effectEntries = new ArrayList<SuspiciousEffectEntry>(this.getHandle().cc.a().size());
        for (SuspiciousStewEffects.a effect : this.getHandle().cc.a()) {
            effectEntries.add(SuspiciousEffectEntry.create((PotionEffectType)CraftPotionEffectType.minecraftHolderToBukkit(effect.b()), (int)effect.c()));
        }
        return Collections.unmodifiableList(effectEntries);
    }

    public void setStewEffects(List<SuspiciousEffectEntry> effects) {
        if (effects.isEmpty()) {
            this.getHandle().cc = null;
            return;
        }
        ArrayList<SuspiciousStewEffects.a> nmsPairs = new ArrayList<SuspiciousStewEffects.a>(effects.size());
        for (SuspiciousEffectEntry effect : effects) {
            nmsPairs.add(new SuspiciousStewEffects.a(CraftPotionEffectType.bukkitToMinecraftHolder(effect.effect()), effect.duration()));
        }
        this.getHandle().cc = new SuspiciousStewEffects(nmsPairs);
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

