/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryLlama;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;
import org.jetbrains.annotations.NotNull;

public class CraftLlama
extends CraftChestedHorse
implements Llama,
CraftRangedEntity<EntityLlama> {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, entity);
    }

    @Override
    public EntityLlama getHandle() {
        return (EntityLlama)super.getHandle();
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().gF().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().a(EntityLlama.Variant.a(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().ct, this.getHandle().hd());
    }

    public int getStrength() {
        return this.getHandle().gw();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrengthPublic(strength);
        this.getHandle().gR();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    public String toString() {
        return "CraftLlama";
    }

    public boolean inCaravan() {
        return this.getHandle().he();
    }

    public void joinCaravan(@NotNull Llama llama) {
        this.getHandle().a(((CraftLlama)llama).getHandle());
    }

    public void leaveCaravan() {
        this.getHandle().gH();
    }

    public boolean hasCaravanTail() {
        return this.getHandle().gI();
    }

    public Llama getCaravanHead() {
        return this.getHandle().hf() == null ? null : (Llama)this.getHandle().hf().getBukkitEntity();
    }

    public Llama getCaravanTail() {
        return this.getHandle().cf == null ? null : (Llama)this.getHandle().cf.getBukkitEntity();
    }
}

