/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R3.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class CraftEntityType {
    private static final Map<EntityType, ResourceKey<EntityTypes<?>>> KEY_CACHE = Collections.synchronizedMap(new EnumMap(EntityType.class));

    public static EntityType minecraftToBukkit(EntityTypes<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry<EntityTypes<?>> registry = CraftRegistry.getMinecraftRegistry(Registries.z);
        EntityType bukkit = (EntityType)Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static EntityTypes<?> bukkitToMinecraft(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return CraftRegistry.getMinecraftRegistry(Registries.z).f(KEY_CACHE.computeIfAbsent(bukkit, type -> ResourceKey.a(Registries.z, CraftNamespacedKey.toMinecraft(type.getKey())))).orElseThrow();
    }

    public static Holder<EntityTypes<?>> bukkitToMinecraftHolder(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry<EntityTypes<?>> registry = CraftRegistry.getMinecraftRegistry(Registries.z);
        Holder<EntityTypes<?>> holder = registry.e(CraftEntityType.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static EntityType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEntityTypeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (EntityType)CraftRegistry.get(RegistryKey.ENTITY_TYPE, key, ApiVersion.CURRENT);
    }
}

