/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.entity;

import ca.spottedleaf.concurrentutil.util.Priority;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.FoliaEntityScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftSound;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected net.minecraft.world.entity.Entity entity;
    private final EntityType entityType;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    protected Pointers adventure$pointers;
    public final io.papermc.paper.threadedregions.EntityScheduler taskScheduler = new io.papermc.paper.threadedregions.EntityScheduler(this);
    private final FoliaEntityScheduler apiScheduler = new FoliaEntityScheduler(this);
    private final Entity.Spigot spigot = new Entity.Spigot(this){

        public void sendMessage(BaseComponent component) {
        }

        public void sendMessage(BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public final EntityScheduler getScheduler() {
        return this.apiScheduler;
    }

    public CraftEntity(CraftServer server, net.minecraft.world.entity.Entity entity) {
        this.server = server;
        this.entity = entity;
        this.entityType = CraftEntityType.minecraftToBukkit(entity.aq());
    }

    public static <T extends net.minecraft.world.entity.Entity> CraftEntity getEntity(CraftServer server, T entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Unknown entity");
        if (entity instanceof EntityHuman && !(entity instanceof EntityPlayer)) {
            return new CraftHumanEntity(server, (EntityHuman)entity);
        }
        if (entity instanceof EntityComplexPart) {
            EntityComplexPart complexPart = (EntityComplexPart)entity;
            if (complexPart.a instanceof EntityEnderDragon) {
                return new CraftEnderDragonPart(server, complexPart);
            }
            return new CraftComplexPart(server, complexPart);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(CraftEntityType.minecraftToBukkit(entity.aq()));
        if (entityTypeData != null) {
            return (CraftEntity)entityTypeData.convertFunction().apply(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + String.valueOf(entity == null ? null : entity.getClass())));
    }

    public Location getLocation() {
        return CraftLocation.toBukkit(this.entity.dt(), this.getWorld(), this.entity.getBukkitYaw(), this.entity.dN());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.dA());
            loc.setY(this.entity.dC());
            loc.setZ(this.entity.dG());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.dN());
        }
        return loc;
    }

    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.dy());
    }

    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        if (!(this instanceof Projectile) && !(this instanceof Minecart) && CraftEntity.isUnsafeVelocity(velocity)) {
            CraftServer.excessiveVelEx = new Exception("Excessive velocity set detected: tried to set velocity of entity " + this.entity.cI() + " id #" + this.getEntityId() + " to (" + velocity.getX() + "," + velocity.getY() + "," + velocity.getZ() + ").");
        }
        this.entity.i(CraftVector.toNMS(velocity));
        this.entity.T = true;
    }

    private static boolean isUnsafeVelocity(Vector vel) {
        double x2 = vel.getX();
        double y2 = vel.getY();
        double z2 = vel.getZ();
        return x2 > 4.0 || x2 < -4.0 || y2 > 4.0 || y2 < -4.0 || z2 > 4.0 || z2 < -4.0;
    }

    public double getHeight() {
        return this.getHandle().dr();
    }

    public double getWidth() {
        return this.getHandle().dq();
    }

    public BoundingBox getBoundingBox() {
        AxisAlignedBB bb = this.getHandle().cR();
        return new BoundingBox(bb.a, bb.b, bb.c, bb.d, bb.e, bb.f);
    }

    public boolean isOnGround() {
        net.minecraft.world.entity.Entity entity = this.entity;
        if (entity instanceof EntityArrow) {
            EntityArrow abstractArrow = (EntityArrow)entity;
            return abstractArrow.l();
        }
        return this.entity.aJ();
    }

    public boolean isInWater() {
        return this.entity.bj();
    }

    public World getWorld() {
        return this.entity.dV().getWorld();
    }

    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite((float)pitch, (String)"pitch not finite");
        NumberConversions.checkFinite((float)yaw, (String)"yaw not finite");
        yaw = Location.normalizeYaw((float)yaw);
        pitch = Location.normalizePitch((float)pitch);
        this.entity.v(yaw);
        this.entity.w(pitch);
        this.entity.N = yaw;
        this.entity.O = pitch;
        this.entity.q(yaw);
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(location, cause, new TeleportFlag[0]);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        location.checkFinite();
        HashSet<TeleportFlag> flagSet = new HashSet<TeleportFlag>(List.of(flags));
        boolean dismount = !flagSet.contains(TeleportFlag.EntityState.RETAIN_VEHICLE);
        boolean retainPassengers = flagSet.contains(TeleportFlag.EntityState.RETAIN_PASSENGERS);
        if (flagSet.contains(TeleportFlag.EntityState.RETAIN_PASSENGERS) && this.entity.ca() && location.getWorld() != this.getWorld()) {
            return false;
        }
        if (!dismount && this.entity.bZ() && location.getWorld() != this.getWorld()) {
            return false;
        }
        if (!retainPassengers && this.entity.ca() || this.entity.dQ()) {
            return false;
        }
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)this, this.getLocation(), location);
        if (!event.callEvent() || event.getTo() == null) {
            return false;
        }
        location = event.getTo();
        if (dismount) {
            this.entity.ae();
        }
        if (location.getWorld() != null && !location.getWorld().equals((Object)this.getWorld())) {
            Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
            this.entity.b(new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.c, location.getPitch(), location.getYaw(), Set.of(), TeleportTransition.a, PlayerTeleportEvent.TeleportCause.PLUGIN));
            return true;
        }
        this.entity.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.q(location.getYaw());
        if (retainPassengers && this.entity.ca()) {
            this.entity.H();
        }
        return true;
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public void lookAt(double x2, double y2, double z2, LookAnchor entityAnchor) {
        this.getHandle().a(CraftEntity.toNmsAnchor(entityAnchor), new Vec3D(x2, y2, z2));
    }

    public static ArgumentAnchor.Anchor toNmsAnchor(LookAnchor nmsAnchor) {
        return switch (nmsAnchor) {
            default -> throw new MatchException(null, null);
            case LookAnchor.EYES -> ArgumentAnchor.Anchor.b;
            case LookAnchor.FEET -> ArgumentAnchor.Anchor.a;
        };
    }

    public static LookAnchor toApiAnchor(ArgumentAnchor.Anchor playerAnchor) {
        return switch (playerAnchor) {
            default -> throw new MatchException(null, null);
            case ArgumentAnchor.Anchor.b -> LookAnchor.EYES;
            case ArgumentAnchor.Anchor.a -> LookAnchor.FEET;
        };
    }

    public List<Entity> getNearbyEntities(double x2, double y2, double z2) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List<net.minecraft.world.entity.Entity> notchEntityList = this.entity.dV().a(this.entity, this.entity.cR().c(x2, y2, z2), (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (net.minecraft.world.entity.Entity e2 : notchEntityList) {
            bukkitEntityList.add(e2.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    public int getEntityId() {
        return this.entity.ar();
    }

    public int getFireTicks() {
        return this.entity.aG();
    }

    public int getMaxFireTicks() {
        return this.entity.dn();
    }

    public void setFireTicks(int ticks) {
        this.entity.h(ticks);
    }

    public void setVisualFire(boolean fire) {
        this.getHandle().bg = fire;
    }

    public boolean isVisualFire() {
        return this.getHandle().bg;
    }

    public int getFreezeTicks() {
        return this.getHandle().cu();
    }

    public int getMaxFreezeTicks() {
        return this.getHandle().cx();
    }

    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((0 <= ticks ? 1 : 0) != 0, (String)"Ticks (%s) cannot be less than 0", (int)ticks);
        this.getHandle().k(ticks);
    }

    public boolean isFrozen() {
        return this.getHandle().cw();
    }

    public boolean isFreezeTickingLocked() {
        return this.entity.freezeLocked;
    }

    public void lockFreezeTicks(boolean locked) {
        this.entity.freezeLocked = locked;
    }

    public void remove() {
        this.entity.pluginRemoved = true;
        this.entity.discard(this.getHandle().generation ? null : EntityRemoveEvent.Cause.PLUGIN);
    }

    public boolean isDead() {
        return !this.entity.bL();
    }

    public boolean isValid() {
        return this.entity.bL() && this.entity.valid;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isPersistent() {
        return this.entity.persist;
    }

    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    public Entity getPassenger() {
        return this.isEmpty() ? null : this.getHandle().cY().getFirst().getBukkitEntity();
    }

    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().n(this.getHandle());
        }
        return false;
    }

    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform(this.getHandle().cY(), net.minecraft.world.entity.Entity::getBukkitEntity));
    }

    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().a(this.getHandle(), true);
    }

    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        ((CraftEntity)passenger).getHandle().ae();
        return true;
    }

    public boolean isEmpty() {
        return !this.getHandle().ca();
    }

    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().bP();
        return true;
    }

    public float getFallDistance() {
        return this.getHandle().Z;
    }

    public void setFallDistance(float distance) {
        this.getHandle().Z = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public UUID getUniqueId() {
        return this.entity.cG();
    }

    public int getTicksLived() {
        return this.getHandle().totalEntityAge;
    }

    public void setTicksLived(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Age value (%s) must be greater than 0", (int)value);
        this.getHandle().af = value;
        this.getHandle().totalEntityAge = value;
    }

    public net.minecraft.world.entity.Entity getHandle() {
        return this.entity;
    }

    public net.minecraft.world.entity.Entity getHandleRaw() {
        return this.entity;
    }

    public final EntityType getType() {
        return this.entityType;
    }

    public void playEffect(EntityEffect effect) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Entity effect cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        Preconditions.checkArgument((boolean)effect.isApplicableTo((Entity)this), (Object)"Entity effect cannot apply to this entity");
        this.getHandle().dV().a(this.getHandle(), effect.getData());
    }

    public Sound getSwimSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSound0());
    }

    public Sound getSwimSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSplashSound0());
    }

    public Sound getSwimHighSpeedSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimHighSpeedSplashSound0());
    }

    public void setHandle(net.minecraft.world.entity.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.entity == other.entity;
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isInsideVehicle() {
        return this.getHandle().bZ();
    }

    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().ae();
        return true;
    }

    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().dk().getBukkitEntity();
    }

    public Component customName() {
        IChatBaseComponent name = this.getHandle().an();
        return name != null ? PaperAdventure.asAdventure(name) : null;
    }

    public void customName(Component customName) {
        this.getHandle().b(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.DISPLAY_NAME, this::name).withDynamic(Identity.UUID, this::getUniqueId).withStatic(PermissionChecker.POINTER, arg_0 -> ((CraftEntity)this).permissionValue(arg_0)).build();
        }
        return this.adventure$pointers;
    }

    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().b(CraftChatMessage.fromStringOrNull(name));
    }

    public String getCustomName() {
        IChatBaseComponent name = this.getHandle().an();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    public void setCustomNameVisible(boolean flag) {
        this.getHandle().p(flag);
    }

    public boolean isCustomNameVisible() {
        return this.getHandle().cL();
    }

    public void setVisibleByDefault(boolean visible) {
        if (this.getHandle().visibleByDefault != visible) {
            if (visible) {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndShowEntity(this);
                }
            } else {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndHideEntity(this);
                }
            }
            this.getHandle().visibleByDefault = visible;
        }
    }

    public boolean isVisibleByDefault() {
        return this.getHandle().visibleByDefault;
    }

    public Set<Player> getTrackedBy() {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get tracking players during world generation");
        ImmutableSet.Builder players = ImmutableSet.builder();
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.m().a.K.get(this.getEntityId());
        if (entityTracker != null) {
            for (ServerPlayerConnection connection : entityTracker.f) {
                players.add((Object)connection.o().getBukkitEntity());
            }
        }
        return players.build();
    }

    public void sendMessage(String message) {
    }

    public void sendMessage(String ... messages) {
    }

    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().al());
    }

    public @NotNull Component name() {
        return PaperAdventure.asAdventure(this.getHandle().al());
    }

    public @NotNull Component teamDisplayName() {
        return PaperAdventure.asAdventure(this.getHandle().p_());
    }

    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    public void setGlowing(boolean flag) {
        this.getHandle().j(flag);
    }

    public boolean isGlowing() {
        return this.getHandle().co();
    }

    public void setInvulnerable(boolean flag) {
        this.getHandle().n(flag);
    }

    public boolean isInvulnerable() {
        return this.getHandle().d(this.getHandle().dW().p());
    }

    public boolean isSilent() {
        return this.getHandle().bb();
    }

    public void setSilent(boolean flag) {
        this.getHandle().e(flag);
    }

    public boolean hasGravity() {
        return !this.getHandle().bc();
    }

    public void setGravity(boolean gravity) {
        this.getHandle().f(!gravity);
    }

    public int getPortalCooldown() {
        return this.getHandle().aC();
    }

    public void setPortalCooldown(int cooldown) {
        this.getHandle().f(cooldown);
    }

    public Set<String> getScoreboardTags() {
        return this.getHandle().as();
    }

    public boolean addScoreboardTag(String tag) {
        return this.getHandle().a(tag);
    }

    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().b(tag);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getHandle().n_().ordinal());
    }

    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().cP());
    }

    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Pose getPose() {
        return Pose.values()[this.getHandle().aw().ordinal()];
    }

    public void setSneaking(boolean sneak) {
        this.getHandle().g(sneak);
    }

    public boolean isSneaking() {
        return this.getHandle().cd();
    }

    public void setPose(Pose pose, boolean fixed) {
        Preconditions.checkNotNull((Object)pose, (Object)"Pose cannot be null");
        net.minecraft.world.entity.Entity handle = this.getHandle();
        handle.fixedPose = false;
        handle.b(EntityPose.values()[pose.ordinal()]);
        handle.fixedPose = fixed;
    }

    public boolean hasFixedPose() {
        return this.getHandle().fixedPose;
    }

    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().aq().f());
    }

    public boolean isInWorld() {
        return this.getHandle().inWorld;
    }

    public String getAsString() {
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.getHandle().saveAsPassenger(tag, false, false, false)) {
            return null;
        }
        return tag.u_();
    }

    public EntitySnapshot createSnapshot() {
        return CraftEntitySnapshot.create(this);
    }

    public Entity copy() {
        net.minecraft.world.entity.Entity copy = this.copy(this.getHandle().dV());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        return copy.getBukkitEntity();
    }

    public Entity copy(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity copy = this.copy(((CraftWorld)location.getWorld()).getHandle());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        copy.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)copy.getBukkitEntity());
    }

    private net.minecraft.world.entity.Entity copy(net.minecraft.world.level.World level) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.getHandle().saveAsPassenger(compoundTag, false, true, true);
        return EntityTypes.a(compoundTag, level, EntitySpawnReason.r, Function.identity());
    }

    public void storeBukkitValues(NBTTagCompound c2) {
        if (!this.persistentDataContainer.isEmpty()) {
            c2.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(NBTTagCompound c2) {
        NBTBase base = c2.c("BukkitValues");
        if (base instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)base);
        }
    }

    protected NBTTagCompound save() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("id", this.getHandle().bK());
        this.getHandle().f(nbttagcompound);
        return nbttagcompound;
    }

    protected void update() {
        if (!this.getHandle().bL()) {
            return;
        }
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.m().a.K.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        for (ServerPlayerConnection connection : entityTracker.f) {
            this.getHandle().resendPossiblyDesyncedEntityData(connection.o());
        }
    }

    public void update(EntityPlayer player) {
        if (!this.getHandle().bL()) {
            return;
        }
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.m().a.K.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        player.f.b(this.getHandle().a(entityTracker.b));
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                public boolean isOp() {
                    return false;
                }

                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    public CompletableFuture<Boolean> teleportAsync(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... teleportFlags) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        location.checkFinite();
        Location locationClone = location.clone();
        WorldServer world = ((CraftWorld)locationClone.getWorld()).getHandle();
        CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
        world.loadChunksForMoveAsync(this.getHandle().getBoundingBoxAt(locationClone.getX(), locationClone.getY(), locationClone.getZ()), this instanceof CraftPlayer ? Priority.HIGHER : Priority.NORMAL, list -> MinecraftServer.getServer().scheduleOnMain(() -> {
            ChunkProviderServer chunkCache = world.m();
            for (IChunkAccess chunk : list) {
                chunkCache.addTicketAtLevel(TicketType.POST_TELEPORT, chunk.f(), 33, this.getEntityId());
            }
            try {
                ret.complete(this.teleport(locationClone, cause, teleportFlags) ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                MinecraftServer.l.error("Failed to teleport entity " + String.valueOf(this), throwable);
                ret.completeExceptionally(throwable);
            }
        }));
        return ret;
    }

    public Entity.Spigot spigot() {
        return this.spigot;
    }

    public Location getOrigin() {
        Vector originVector = this.getHandle().getOriginVector();
        if (originVector == null) {
            return null;
        }
        World world = this.getWorld();
        if (this.getHandle().getOriginWorld() != null) {
            world = Bukkit.getWorld((UUID)this.getHandle().getOriginWorld());
        }
        return originVector.toLocation(world);
    }

    public boolean fromMobSpawner() {
        return this.getHandle().spawnedViaMobSpawner;
    }

    public CreatureSpawnEvent.SpawnReason getEntitySpawnReason() {
        return this.getHandle().spawnReason;
    }

    public boolean isUnderWater() {
        return this.getHandle().bo();
    }

    public boolean isInRain() {
        return this.getHandle().isInRain0();
    }

    public boolean isInBubbleColumn() {
        return this.getHandle().u();
    }

    public boolean isInWaterOrRain() {
        return this.getHandle().bk();
    }

    public boolean isInWaterOrBubbleColumn() {
        return this.getHandle().bm();
    }

    public boolean isInWaterOrRainOrBubbleColumn() {
        return this.getHandle().bl();
    }

    public boolean isInLava() {
        return this.getHandle().bx();
    }

    public boolean isTicking() {
        return this.getHandle().isTicking();
    }

    public Set<Player> getTrackedPlayers() {
        PlayerChunkMap.EntityTracker tracker;
        WorldServer world = (WorldServer)this.entity.dV();
        PlayerChunkMap.EntityTracker entityTracker = tracker = world == null ? null : (PlayerChunkMap.EntityTracker)world.m().a.K.get(this.entity.ar());
        if (tracker == null) {
            return Collections.emptySet();
        }
        HashSet<Player> set = new HashSet<Player>(tracker.f.size());
        for (ServerPlayerConnection connection : tracker.f) {
            set.add(connection.o().getBukkitEntity().getPlayer());
        }
        return set;
    }

    public boolean spawnAt(Location location, CreatureSpawnEvent.SpawnReason reason) {
        boolean spawned;
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkNotNull((Object)reason, (Object)"reason cannot be null");
        this.entity.a(((CraftWorld)location.getWorld()).getHandle());
        this.entity.a_(location.getX(), location.getY(), location.getZ());
        this.entity.b(location.getYaw(), location.getPitch());
        boolean bl = spawned = !this.entity.valid && this.entity.dV().addFreshEntity(this.entity, reason);
        if (!spawned) {
            return false;
        }
        this.entity.dc().forEach(e2 -> e2.dV().addFreshEntity((net.minecraft.world.entity.Entity)e2, reason));
        return true;
    }

    public boolean isInPowderedSnow() {
        return this.getHandle().av || this.getHandle().aw;
    }

    public double getX() {
        return this.entity.dA();
    }

    public double getY() {
        return this.entity.dC();
    }

    public double getZ() {
        return this.entity.dG();
    }

    public float getPitch() {
        return this.entity.dN();
    }

    public float getYaw() {
        return this.entity.getBukkitYaw();
    }

    public boolean isInvisible() {
        return this.getHandle().cp();
    }

    public void setInvisible(boolean invisible) {
        this.getHandle().persistentInvisibility = invisible;
        this.getHandle().b(5, invisible);
    }

    public void setNoPhysics(boolean noPhysics) {
        this.getHandle().ad = noPhysics;
    }

    public boolean hasNoPhysics() {
        return this.getHandle().ad;
    }

    public boolean collidesAt(@NotNull Location location) {
        AxisAlignedBB aabb = this.getHandle().getBoundingBoxAt(location.getX(), location.getY(), location.getZ());
        return !this.getHandle().dV().a(this.getHandle(), aabb);
    }

    public boolean wouldCollideUsing(@NotNull BoundingBox boundingBox) {
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        return !this.getHandle().dV().a(this.getHandle(), aabb);
    }

    public String getScoreboardEntryName() {
        return this.getHandle().cI();
    }

    public void broadcastHurtAnimation(Collection<Player> players) {
        Preconditions.checkArgument((!players.contains(this) ? 1 : 0) != 0, (Object)"Cannot broadcast hurt animation to self without a yaw");
        for (Player player : players) {
            ((CraftPlayer)player).sendHurtAnimation(0.0f, this);
        }
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

