/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.entity;

import io.papermc.paper.entity.PaperLeashable;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat,
PaperLeashable {
    public CraftBoat(CraftServer server, AbstractBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().aq());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().aq());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Material getBoatMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().u());
    }

    public Boat.Status getStatus() {
        AbstractBoat handle = this.getHandle();
        if (handle.aF == null) {
            if (handle.valid) {
                return CraftBoat.boatStatusFromNms(handle.I());
            }
            return Boat.Status.NOT_IN_WORLD;
        }
        return CraftBoat.boatStatusFromNms(this.getHandle().aF);
    }

    @Override
    public AbstractBoat getHandle() {
        return (AbstractBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.aG || boatType == EntityTypes.aH) {
            return Boat.Type.OAK;
        }
        if (boatType == EntityTypes.m || boatType == EntityTypes.n) {
            return Boat.Type.BIRCH;
        }
        if (boatType == EntityTypes.a || boatType == EntityTypes.b) {
            return Boat.Type.ACACIA;
        }
        if (boatType == EntityTypes.w || boatType == EntityTypes.x) {
            return Boat.Type.CHERRY;
        }
        if (boatType == EntityTypes.at || boatType == EntityTypes.au) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == EntityTypes.bo || boatType == EntityTypes.bp) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == EntityTypes.F || boatType == EntityTypes.G) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == EntityTypes.aA || boatType == EntityTypes.aB) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == EntityTypes.j || boatType == EntityTypes.i) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(AbstractBoat.EnumStatus enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case AbstractBoat.EnumStatus.e -> Boat.Status.IN_AIR;
            case AbstractBoat.EnumStatus.d -> Boat.Status.ON_LAND;
            case AbstractBoat.EnumStatus.b -> Boat.Status.UNDER_WATER;
            case AbstractBoat.EnumStatus.c -> Boat.Status.UNDER_FLOWING_WATER;
            case AbstractBoat.EnumStatus.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.bo || boatType == EntityTypes.bp) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == EntityTypes.m || boatType == EntityTypes.n) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == EntityTypes.at || boatType == EntityTypes.au) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == EntityTypes.a || boatType == EntityTypes.b) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == EntityTypes.F || boatType == EntityTypes.G) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

