/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.block;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Conduit;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;

public class CraftConduit
extends CraftBlockEntityState<TileEntityConduit>
implements Conduit {
    public CraftConduit(World world, TileEntityConduit tileEntity) {
        super(world, tileEntity);
    }

    protected CraftConduit(CraftConduit state, Location location) {
        super(state, location);
    }

    @Override
    public CraftConduit copy() {
        return new CraftConduit(this, null);
    }

    @Override
    public CraftConduit copy(Location location) {
        return new CraftConduit(this, location);
    }

    public boolean isActive() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        return conduit != null && conduit.c();
    }

    public boolean isHunting() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        return conduit != null && conduit.d();
    }

    public Collection<Block> getFrameBlocks() {
        this.ensureNoWorldGeneration();
        ArrayList<Block> blocks = new ArrayList<Block>();
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        if (conduit != null) {
            for (BlockPosition position : conduit.l) {
                blocks.add(CraftBlock.at(this.getWorldHandle(), position));
            }
        }
        return blocks;
    }

    public int getFrameBlockCount() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        return conduit != null ? conduit.l.size() : 0;
    }

    public int getRange() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        return conduit != null ? TileEntityConduit.getRange(conduit.l) : 0;
    }

    public boolean setTarget(LivingEntity target) {
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        if (conduit == null) {
            return false;
        }
        EntityLiving currentTarget = conduit.m;
        if (target == null) {
            if (currentTarget == null) {
                return false;
            }
            conduit.m = null;
            conduit.q = null;
        } else {
            if (currentTarget != null && target.getUniqueId().equals(currentTarget.cG())) {
                return false;
            }
            conduit.m = ((CraftLivingEntity)target).getHandle();
            conduit.q = target.getUniqueId();
        }
        TileEntityConduit.updateDestroyTarget(conduit.i(), this.getPosition(), this.data, conduit.l, conduit, false);
        return true;
    }

    public LivingEntity getTarget() {
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        if (conduit == null) {
            return null;
        }
        EntityLiving nmsEntity = conduit.m;
        return nmsEntity != null ? (LivingEntity)nmsEntity.getBukkitEntity() : null;
    }

    public boolean hasTarget() {
        TileEntityConduit conduit = (TileEntityConduit)this.getTileEntityFromWorld();
        return conduit != null && conduit.m != null && conduit.m.bL();
    }

    public BoundingBox getHuntingArea() {
        AxisAlignedBB bounds = TileEntityConduit.a(this.getPosition());
        return new BoundingBox(bounds.a, bounds.b, bounds.c, bounds.d, bounds.e, bounds.f);
    }
}

