/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;

public final class CapturedBlockState
extends CraftBlockState {
    private final boolean treeBlock;

    public CapturedBlockState(Block block, int flag, boolean treeBlock) {
        super(block, flag);
        this.treeBlock = treeBlock;
    }

    protected CapturedBlockState(CapturedBlockState state, Location location) {
        super(state, location);
        this.treeBlock = state.treeBlock;
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        this.addBees();
        return result;
    }

    private void updatedTree() {
        this.world.getHandle().a(CraftLocation.toBlockPosition(this.getLocation()), this.getHandle(), this.getFlag());
        this.addBees();
    }

    private void addBees() {
        if (this.treeBlock && this.getType() == Material.BEE_NEST) {
            WorldServer generatoraccessseed = this.world.getHandle();
            BlockPosition blockposition1 = this.getPosition();
            RandomSource random = generatoraccessseed.H_();
            TileEntity tileentity = generatoraccessseed.c_(blockposition1);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                int j2 = 2 + random.a(2);
                for (int k2 = 0; k2 < j2; ++k2) {
                    tileentitybeehive.a(TileEntityBeehive.c.a(random.a(599)));
                }
            }
        }
    }

    @Override
    public CapturedBlockState copy() {
        return new CapturedBlockState(this, null);
    }

    @Override
    public CapturedBlockState copy(Location location) {
        return new CapturedBlockState(this, location);
    }

    public static CapturedBlockState getBlockState(World world, BlockPosition pos, int flag) {
        return new CapturedBlockState(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), flag, false);
    }

    public static CapturedBlockState getTreeBlockState(World world, BlockPosition pos, int flag) {
        return new CapturedBlockState(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), flag, true);
    }

    public static void setBlockState(BlockState blockState) {
        if (blockState instanceof CapturedBlockState) {
            CapturedBlockState capturedBlockState = (CapturedBlockState)blockState;
            capturedBlockState.updatedTree();
        } else {
            blockState.update(true);
        }
    }
}

