/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.attribute;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.attribute.AttributeMappings;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.EquipmentSlotGroup;

public class CraftAttributeInstance
implements AttributeInstance {
    private final AttributeModifiable handle;
    private final Attribute attribute;

    public CraftAttributeInstance(AttributeModifiable handle, Attribute attribute) {
        this.handle = handle;
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.handle.b();
    }

    public void setBaseValue(double d2) {
        this.handle.a(d2);
    }

    public Collection<AttributeModifier> getModifiers() {
        ArrayList<AttributeModifier> result = new ArrayList<AttributeModifier>();
        for (net.minecraft.world.entity.ai.attributes.AttributeModifier nms : this.handle.c()) {
            result.add(CraftAttributeInstance.convert(nms));
        }
        return result;
    }

    public AttributeModifier getModifier(Key key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        net.minecraft.world.entity.ai.attributes.AttributeModifier modifier = this.handle.a(PaperAdventure.asVanilla(key));
        return modifier == null ? null : CraftAttributeInstance.convert(modifier);
    }

    public void removeModifier(Key key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.handle.c(PaperAdventure.asVanilla(key));
    }

    public AttributeModifier getModifier(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getModifier((Key)AttributeMappings.uuidToKey(uuid));
    }

    public void removeModifier(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        this.removeModifier((Key)AttributeMappings.uuidToKey(uuid));
    }

    public void addModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.d(CraftAttributeInstance.convert(modifier));
    }

    public void addTransientModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.b(CraftAttributeInstance.convert(modifier));
    }

    public void removeModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.e(CraftAttributeInstance.convert(modifier));
    }

    public double getValue() {
        return this.handle.g();
    }

    public double getDefaultValue() {
        return this.handle.a().a().a();
    }

    public static net.minecraft.world.entity.ai.attributes.AttributeModifier convert(AttributeModifier bukkit) {
        return new net.minecraft.world.entity.ai.attributes.AttributeModifier(CraftNamespacedKey.toMinecraft(bukkit.getKey()), bukkit.getAmount(), AttributeModifier.Operation.values()[bukkit.getOperation().ordinal()]);
    }

    public static AttributeModifier convert(net.minecraft.world.entity.ai.attributes.AttributeModifier nms) {
        return new AttributeModifier(CraftNamespacedKey.fromMinecraft(nms.b()), nms.c(), AttributeModifier.Operation.values()[nms.d().ordinal()], EquipmentSlotGroup.ANY);
    }

    public static AttributeModifier convert(net.minecraft.world.entity.ai.attributes.AttributeModifier nms, net.minecraft.world.entity.EquipmentSlotGroup slot) {
        return new AttributeModifier(CraftNamespacedKey.fromMinecraft(nms.b()), nms.c(), AttributeModifier.Operation.values()[nms.d().ordinal()], CraftEquipmentSlot.getSlot(slot));
    }
}

