/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R3.attribute;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R3.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R3.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R3.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftAttribute
implements Attribute,
Handleable<AttributeBase> {
    private static int count = 0;
    private final NamespacedKey key;
    private final AttributeBase attributeBase;
    private final String name;
    private final int ordinal;

    public static Attribute minecraftToBukkit(AttributeBase minecraft) {
        return (Attribute)CraftRegistry.minecraftToBukkit(minecraft, Registries.c);
    }

    public static Attribute minecraftHolderToBukkit(Holder<AttributeBase> minecraft) {
        return CraftAttribute.minecraftToBukkit(minecraft.a());
    }

    public static Attribute stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertAttributeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        if (key == null) {
            return null;
        }
        return (Attribute)CraftRegistry.get(RegistryKey.ATTRIBUTE, key, ApiVersion.CURRENT);
    }

    public static AttributeBase bukkitToMinecraft(Attribute bukkit) {
        return (AttributeBase)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<AttributeBase> bukkitToMinecraftHolder(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry<AttributeBase> registry = CraftRegistry.getMinecraftRegistry(Registries.c);
        Holder<AttributeBase> holder = registry.e(CraftAttribute.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public CraftAttribute(NamespacedKey key, AttributeBase attributeBase) {
        this.key = key;
        this.attributeBase = attributeBase;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public AttributeBase getHandle() {
        return this.attributeBase;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getTranslationKey() {
        return this.attributeBase.c();
    }

    @NotNull
    public String translationKey() {
        return this.attributeBase.c();
    }

    public int compareTo(@NotNull Attribute attribute) {
        return this.ordinal - attribute.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftAttribute)) {
            return false;
        }
        CraftAttribute otherAttribute = (CraftAttribute)other;
        return this.getKey().equals((Object)otherAttribute.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

