/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public final class TickListChunk<T>
extends Record {
    private final T b;
    private final BlockPosition c;
    private final int d;
    private final TickListPriority e;
    private static final String f = "i";
    private static final String g = "x";
    private static final String h = "y";
    private static final String i = "z";
    private static final String j = "t";
    private static final String k = "p";
    public static final Hash.Strategy<TickListChunk<?>> a = new Hash.Strategy<TickListChunk<?>>(){

        public int a(TickListChunk<?> savedTick) {
            return 31 * savedTick.b().hashCode() + savedTick.a().hashCode();
        }

        public boolean a(@Nullable TickListChunk<?> first, @Nullable TickListChunk<?> second) {
            return first == second || first != null && second != null && first.a() == second.a() && first.b().equals(second.b());
        }
    };

    public TickListChunk(T type, BlockPosition pos, int delay, TickListPriority priority) {
        this.b = type;
        this.c = pos;
        this.d = delay;
        this.e = priority;
    }

    public static <T> List<TickListChunk<T>> a(NBTTagList tickList, Function<String, Optional<T>> idParser, ChunkCoordIntPair chunkPos) {
        ArrayList list = new ArrayList(tickList.size());
        long packedChunkPos = chunkPos.a();
        for (int i2 = 0; i2 < tickList.size(); ++i2) {
            NBTTagCompound compound = tickList.a(i2);
            TickListChunk.a(compound, idParser).ifPresent(savedTick -> {
                if (ChunkCoordIntPair.a(savedTick.b()) == packedChunkPos) {
                    list.add((TickListChunk)savedTick);
                }
            });
        }
        return list;
    }

    public static <T> Optional<TickListChunk<T>> a(NBTTagCompound tag, Function<String, Optional<T>> idParser) {
        return idParser.apply(tag.l(f)).map(object -> {
            BlockPosition blockPos = new BlockPosition(tag.h(g), tag.h(h), tag.h(i));
            return new TickListChunk<Object>(object, blockPos, tag.h(j), TickListPriority.a(tag.h(k)));
        });
    }

    private static NBTTagCompound a(String id, BlockPosition pos, int delay, TickListPriority priority) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a(f, id);
        compoundTag.a(g, pos.u());
        compoundTag.a(h, pos.v());
        compoundTag.a(i, pos.w());
        compoundTag.a(j, delay);
        compoundTag.a(k, priority.a());
        return compoundTag;
    }

    public NBTTagCompound a(Function<T, String> idGetter) {
        return TickListChunk.a(idGetter.apply(this.b), this.c, this.d, this.e);
    }

    public NextTickListEntry<T> a(long gameTime, long subTickOrder) {
        return new NextTickListEntry<T>(this.b, this.c, gameTime + (long)this.d, this.e, subTickOrder);
    }

    public static <T> TickListChunk<T> a(T type, BlockPosition pos) {
        return new TickListChunk<T>(type, pos, 0, TickListPriority.d);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this, o2);
    }

    public T a() {
        return this.b;
    }

    public BlockPosition b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public TickListPriority d() {
        return this.e;
    }
}

