/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String a = "#";
    private static final Logger b = LogUtils.getLogger();
    private final Object2ObjectMap<String, ScoreboardObjective> c = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<IScoreboardCriteria, List<ScoreboardObjective>> d = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> e = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, ScoreboardObjective> f = new EnumMap<DisplaySlot, ScoreboardObjective>(DisplaySlot.class);
    private final Object2ObjectMap<String, ScoreboardTeam> g = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ScoreboardTeam> h = new Object2ObjectOpenHashMap();

    @Nullable
    public ScoreboardObjective a(@Nullable String name) {
        return (ScoreboardObjective)this.c.get((Object)name);
    }

    public ScoreboardObjective a(String name, IScoreboardCriteria criteria, IChatBaseComponent displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType, boolean displayAutoUpdate, @Nullable NumberFormat numberFormat) {
        if (this.c.containsKey((Object)name)) {
            throw new IllegalArgumentException("An objective with the name '" + name + "' already exists!");
        }
        ScoreboardObjective objective = new ScoreboardObjective(this, name, criteria, displayName, renderType, displayAutoUpdate, numberFormat);
        ((List)this.d.computeIfAbsent((Object)criteria, object -> Lists.newArrayList())).add(objective);
        this.c.put((Object)name, (Object)objective);
        this.a(objective);
        return objective;
    }

    public final void a(IScoreboardCriteria criteria, ScoreHolder scoreHolder, Consumer<ScoreAccess> action) {
        ((List)this.d.getOrDefault((Object)criteria, Collections.emptyList())).forEach(objective -> action.accept(this.a(scoreHolder, (ScoreboardObjective)objective, true)));
    }

    private PlayerScores f(String username) {
        return this.e.computeIfAbsent(username, string -> new PlayerScores());
    }

    public ScoreAccess c(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        return this.a(scoreHolder, objective, false);
    }

    public ScoreAccess a(final ScoreHolder scoreHolder, final ScoreboardObjective objective, boolean readOnly) {
        final boolean flag = readOnly || !objective.c().e();
        PlayerScores playerInfo = this.f(scoreHolder.cI());
        final MutableBoolean mutableBoolean = new MutableBoolean();
        final ScoreboardScore score = playerInfo.a(objective, (ScoreboardScore score1) -> mutableBoolean.setTrue());
        return new ScoreAccess(){

            @Override
            public int a() {
                return score.a();
            }

            @Override
            public void a(int value) {
                IChatBaseComponent displayName;
                if (!flag) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean isTrue = mutableBoolean.isTrue();
                if (objective.e() && (displayName = scoreHolder.p_()) != null && !displayName.equals(score.d())) {
                    score.a(displayName);
                    isTrue = true;
                }
                if (value != score.a()) {
                    score.a(value);
                    isTrue = true;
                }
                if (isTrue) {
                    this.h();
                }
            }

            @Override
            @Nullable
            public IChatBaseComponent g() {
                return score.d();
            }

            @Override
            public void a(@Nullable IChatBaseComponent value) {
                if (mutableBoolean.isTrue() || !Objects.equals(value, score.d())) {
                    score.a(value);
                    this.h();
                }
            }

            @Override
            public void a(@Nullable NumberFormat format) {
                score.b(format);
                this.h();
            }

            @Override
            public boolean d() {
                return score.b();
            }

            @Override
            public void e() {
                this.a(false);
            }

            @Override
            public void f() {
                this.a(true);
            }

            private void a(boolean locked) {
                score.a(locked);
                if (mutableBoolean.isTrue()) {
                    this.h();
                }
                Scoreboard.this.a(scoreHolder, objective);
            }

            private void h() {
                Scoreboard.this.a(scoreHolder, objective, score);
                mutableBoolean.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo d(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        PlayerScores playerScores = this.e.get(scoreHolder.cI());
        return playerScores != null ? playerScores.a(objective) : null;
    }

    public Collection<PlayerScoreEntry> i(ScoreboardObjective objective) {
        ArrayList<PlayerScoreEntry> list = new ArrayList<PlayerScoreEntry>();
        this.e.forEach((string, playerScores) -> {
            ScoreboardScore score = playerScores.a(objective);
            if (score != null) {
                list.add(new PlayerScoreEntry((String)string, score.a(), score.d(), score.c()));
            }
        });
        return list;
    }

    public Collection<ScoreboardObjective> c() {
        return this.c.values();
    }

    public Collection<String> d() {
        return this.c.keySet();
    }

    public Collection<ScoreHolder> e() {
        return this.e.keySet().stream().map(ScoreHolder::c).toList();
    }

    public void b(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.e.remove(scoreHolder.cI());
        if (playerScores != null) {
            this.a(scoreHolder);
        }
    }

    public void e(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        PlayerScores playerScores = this.e.get(scoreHolder.cI());
        if (playerScores != null) {
            boolean flag = playerScores.b(objective);
            if (!playerScores.a()) {
                PlayerScores playerScores1 = this.e.remove(scoreHolder.cI());
                if (playerScores1 != null) {
                    this.a(scoreHolder);
                }
            } else if (flag) {
                this.b(scoreHolder, objective);
            }
        }
    }

    public Object2IntMap<ScoreboardObjective> c(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.e.get(scoreHolder.cI());
        return playerScores != null ? playerScores.b() : Object2IntMaps.emptyMap();
    }

    public void j(ScoreboardObjective objective) {
        this.c.remove((Object)objective.b());
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            this.a(displaySlot, null);
        }
        List list = (List)this.d.get((Object)objective.c());
        if (list != null) {
            list.remove(objective);
        }
        for (PlayerScores playerScores : this.e.values()) {
            playerScores.b(objective);
        }
        this.c(objective);
    }

    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        this.f.put(slot, objective);
    }

    @Nullable
    public ScoreboardObjective a(DisplaySlot slot) {
        return this.f.get(slot);
    }

    @Nullable
    public ScoreboardTeam b(String teamName) {
        return (ScoreboardTeam)this.g.get((Object)teamName);
    }

    public ScoreboardTeam c(String name) {
        ScoreboardTeam playerTeam = this.b(name);
        if (playerTeam != null) {
            b.warn("Requested creation of existing team '{}'", (Object)name);
            return playerTeam;
        }
        playerTeam = new ScoreboardTeam(this, name);
        this.g.put((Object)name, (Object)playerTeam);
        this.a(playerTeam);
        return playerTeam;
    }

    public void d(ScoreboardTeam playerTeam) {
        this.g.remove((Object)playerTeam.b());
        for (String string : playerTeam.g()) {
            this.h.remove((Object)string);
        }
        this.c(playerTeam);
    }

    public boolean a(String playerName, ScoreboardTeam team) {
        if (this.e(playerName) != null) {
            this.d(playerName);
        }
        this.h.put((Object)playerName, (Object)team);
        return team.g().add(playerName);
    }

    public boolean d(String playerName) {
        ScoreboardTeam playersTeam = this.e(playerName);
        if (playersTeam != null) {
            this.b(playerName, playersTeam);
            return true;
        }
        return false;
    }

    public void b(String username, ScoreboardTeam playerTeam) {
        if (this.e(username) != playerTeam) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + playerTeam.b() + "'.");
        }
        this.h.remove((Object)username);
        playerTeam.g().remove(username);
    }

    public Collection<String> f() {
        return this.g.keySet();
    }

    public Collection<ScoreboardTeam> g() {
        return this.g.values();
    }

    @Nullable
    public ScoreboardTeam e(String username) {
        return (ScoreboardTeam)this.h.get((Object)username);
    }

    public void a(ScoreboardObjective objective) {
    }

    public void b(ScoreboardObjective objective) {
    }

    public void c(ScoreboardObjective objective) {
    }

    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective, ScoreboardScore score) {
    }

    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective) {
    }

    public void a(ScoreHolder scoreHolder) {
    }

    public void b(ScoreHolder scoreHolder, ScoreboardObjective objective) {
    }

    public void a(ScoreboardTeam playerTeam) {
    }

    public void b(ScoreboardTeam playerTeam) {
    }

    public void c(ScoreboardTeam playerTeam) {
    }

    public void a(Entity entity) {
        if (!(entity instanceof EntityHuman) && !entity.bL()) {
            this.b(entity);
            this.d(entity.cI());
        }
    }

    protected NBTTagList a(HolderLookup.a levelRegistry) {
        NBTTagList listTag = new NBTTagList();
        this.e.forEach((string, playerScores) -> playerScores.c().forEach((objective, score) -> {
            NBTTagCompound compoundTag = score.a(levelRegistry);
            compoundTag.a("Name", (String)string);
            compoundTag.a("Objective", objective.b());
            listTag.add(compoundTag);
        }));
        return listTag;
    }

    protected void a(NBTTagList tag, HolderLookup.a levelRegistry) {
        for (int i2 = 0; i2 < tag.size(); ++i2) {
            NBTTagCompound compound = tag.a(i2);
            ScoreboardScore score = ScoreboardScore.a(compound, levelRegistry);
            String string = compound.l("Name");
            String string1 = compound.l("Objective");
            ScoreboardObjective objective = this.a(string1);
            if (objective == null) {
                b.error("Unknown objective {} for name {}, ignoring", (Object)string1, (Object)string);
                continue;
            }
            this.f(string).a(objective, score);
        }
    }
}

