/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class PersistentScoreboard
extends PersistentBase {
    private static final Logger b = LogUtils.getLogger();
    public static final String a = "scoreboard";
    private final Scoreboard c;

    public PersistentScoreboard(Scoreboard scoreboard) {
        this.c = scoreboard;
    }

    public PersistentScoreboard b(NBTTagCompound tag, HolderLookup.a levelRegistry) {
        this.b(tag.c("Objectives", 10), levelRegistry);
        this.c.a(tag.c("PlayerScores", 10), levelRegistry);
        if (tag.b("DisplaySlots", 10)) {
            this.a(tag.p("DisplaySlots"));
        }
        if (tag.b("Teams", 9)) {
            this.a(tag.c("Teams", 10), levelRegistry);
        }
        return this;
    }

    private void a(NBTTagList tag, HolderLookup.a levelRegistry) {
        for (int i2 = 0; i2 < tag.size(); ++i2) {
            ScoreboardTeamBase.EnumTeamPush collisionRule;
            ScoreboardTeamBase.EnumNameTagVisibility visibility;
            IChatMutableComponent component1;
            NBTTagCompound compound = tag.a(i2);
            String string = compound.l("Name");
            ScoreboardTeam playerTeam = this.c.c(string);
            IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(compound.l("DisplayName"), levelRegistry);
            if (component != null) {
                playerTeam.a(component);
            }
            if (compound.b("TeamColor", 8)) {
                playerTeam.a(EnumChatFormat.b(compound.l("TeamColor")));
            }
            if (compound.b("AllowFriendlyFire", 99)) {
                playerTeam.a(compound.q("AllowFriendlyFire"));
            }
            if (compound.b("SeeFriendlyInvisibles", 99)) {
                playerTeam.b(compound.q("SeeFriendlyInvisibles"));
            }
            if (compound.b("MemberNamePrefix", 8) && (component1 = IChatBaseComponent.ChatSerializer.a(compound.l("MemberNamePrefix"), levelRegistry)) != null) {
                playerTeam.b(component1);
            }
            if (compound.b("MemberNameSuffix", 8) && (component1 = IChatBaseComponent.ChatSerializer.a(compound.l("MemberNameSuffix"), levelRegistry)) != null) {
                playerTeam.c(component1);
            }
            if (compound.b("NameTagVisibility", 8) && (visibility = ScoreboardTeamBase.EnumNameTagVisibility.a(compound.l("NameTagVisibility"))) != null) {
                playerTeam.a(visibility);
            }
            if (compound.b("DeathMessageVisibility", 8) && (visibility = ScoreboardTeamBase.EnumNameTagVisibility.a(compound.l("DeathMessageVisibility"))) != null) {
                playerTeam.b(visibility);
            }
            if (compound.b("CollisionRule", 8) && (collisionRule = ScoreboardTeamBase.EnumTeamPush.a(compound.l("CollisionRule"))) != null) {
                playerTeam.a(collisionRule);
            }
            this.a(playerTeam, compound.c("Players", 8));
        }
    }

    private void a(ScoreboardTeam playerTeam, NBTTagList tagList) {
        for (int i2 = 0; i2 < tagList.size(); ++i2) {
            this.c.a(tagList.j(i2), playerTeam);
        }
    }

    private void a(NBTTagCompound compound) {
        for (String string : compound.e()) {
            DisplaySlot displaySlot = DisplaySlot.t.a(string);
            if (displaySlot == null) continue;
            String string1 = compound.l(string);
            ScoreboardObjective objective = this.c.a(string1);
            this.c.a(displaySlot, objective);
        }
    }

    private void b(NBTTagList tag, HolderLookup.a levelRegistry) {
        for (int i2 = 0; i2 < tag.size(); ++i2) {
            NBTTagCompound compound = tag.a(i2);
            String string = compound.l("CriteriaName");
            IScoreboardCriteria objectiveCriteria = IScoreboardCriteria.a(string).orElseGet(() -> {
                b.warn("Unknown scoreboard criteria {}, replacing with {}", (Object)string, (Object)IScoreboardCriteria.b.d());
                return IScoreboardCriteria.b;
            });
            String string1 = compound.l("Name");
            IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(compound.l("DisplayName"), levelRegistry);
            IScoreboardCriteria.EnumScoreboardHealthDisplay renderType = IScoreboardCriteria.EnumScoreboardHealthDisplay.a(compound.l("RenderType"));
            boolean _boolean = compound.q("display_auto_update");
            NumberFormat numberFormat = NumberFormatTypes.b.parse(levelRegistry.a(DynamicOpsNBT.a), (Object)compound.c("format")).result().orElse(null);
            this.c.a(string1, objectiveCriteria, component, renderType, _boolean, numberFormat);
        }
    }

    @Override
    public NBTTagCompound a(NBTTagCompound tag, HolderLookup.a registries) {
        tag.a("Objectives", this.c(registries));
        tag.a("PlayerScores", this.c.a(registries));
        tag.a("Teams", this.b(registries));
        this.b(tag);
        return tag;
    }

    private NBTTagList b(HolderLookup.a levelRegistry) {
        NBTTagList listTag = new NBTTagList();
        for (ScoreboardTeam playerTeam : this.c.g()) {
            if (!GlobalConfiguration.get().scoreboards.saveEmptyScoreboardTeams && playerTeam.g().isEmpty()) continue;
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Name", playerTeam.b());
            compoundTag.a("DisplayName", IChatBaseComponent.ChatSerializer.a(playerTeam.c(), levelRegistry));
            if (playerTeam.n().b() >= 0) {
                compoundTag.a("TeamColor", playerTeam.n().g());
            }
            compoundTag.a("AllowFriendlyFire", playerTeam.h());
            compoundTag.a("SeeFriendlyInvisibles", playerTeam.i());
            compoundTag.a("MemberNamePrefix", IChatBaseComponent.ChatSerializer.a(playerTeam.e(), levelRegistry));
            compoundTag.a("MemberNameSuffix", IChatBaseComponent.ChatSerializer.a(playerTeam.f(), levelRegistry));
            compoundTag.a("NameTagVisibility", playerTeam.j().e);
            compoundTag.a("DeathMessageVisibility", playerTeam.k().e);
            compoundTag.a("CollisionRule", playerTeam.l().e);
            NBTTagList listTag1 = new NBTTagList();
            for (String string : playerTeam.g()) {
                listTag1.add(NBTTagString.a(string));
            }
            compoundTag.a("Players", listTag1);
            listTag.add(compoundTag);
        }
        return listTag;
    }

    private void b(NBTTagCompound compound) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            ScoreboardObjective displayObjective = this.c.a(displaySlot);
            if (displayObjective == null) continue;
            compoundTag.a(displaySlot.c(), displayObjective.b());
        }
        if (!compoundTag.g()) {
            compound.a("DisplaySlots", compoundTag);
        }
    }

    private NBTTagList c(HolderLookup.a levelRegistry) {
        NBTTagList listTag = new NBTTagList();
        for (ScoreboardObjective objective : this.c.c()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Name", objective.b());
            compoundTag.a("CriteriaName", objective.c().d());
            compoundTag.a("DisplayName", IChatBaseComponent.ChatSerializer.a(objective.d(), levelRegistry));
            compoundTag.a("RenderType", objective.h().a());
            compoundTag.a("display_auto_update", objective.e());
            NumberFormat numberFormat = objective.f();
            if (numberFormat != null) {
                NumberFormatTypes.b.encodeStart(levelRegistry.a(DynamicOpsNBT.a), (Object)numberFormat).ifSuccess(tag -> compoundTag.a("format", (NBTBase)tag));
            }
            listTag.add(compoundTag);
        }
        return listTag;
    }
}

